/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.tdd;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.ctrl_1.IAnalysisMarkersParticipant;
import com.python.pydev.refactoring.tdd.NullPyCreateAction;
import com.python.pydev.refactoring.tdd.PyCreateClass;
import com.python.pydev.refactoring.tdd.PyCreateMethodOrField;
import com.python.pydev.refactoring.tdd.TddRefactorCompletion;
import com.python.pydev.refactoring.tdd.TddRefactorCompletionInInexistentModule;
import com.python.pydev.refactoring.tdd.TddRefactorCompletionInModule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.PyImportsHandling;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TddQuickFixParticipant
implements IAnalysisMarkersParticipant {
    Image imageClass;
    Image imageMethod;
    Image imageModule;

    public TddQuickFixParticipant() {
        ImageCache imageCache = PydevPlugin.getImageCache();
        if (imageCache != null) {
            this.imageClass = imageCache.get("icons/new/create_class_obj.png");
            this.imageMethod = imageCache.get("icons/new/create_method_obj.png");
            this.imageModule = imageCache.get("icons/new/create_python_module.png");
        }
    }

    public void addProps(MarkerAnnotationAndPosition markerAnnotation, IAnalysisPreferences analysisPreferences, String line, PySelection ps, int offset, IPythonNature nature, PyEdit edit, List<ICompletionProposal> props) throws BadLocationException, CoreException {
        String markerContents;
        if (nature == null) {
            return;
        }
        ICodeCompletionASTManager astManager = nature.getAstManager();
        if (astManager == null) {
            return;
        }
        IMarker marker = markerAnnotation.markerAnnotation.getMarker();
        Integer id = (Integer)marker.getAttribute("PYDEV_TYPE");
        int start = markerAnnotation.position.offset;
        int end = start + markerAnnotation.position.length;
        ps.setSelection(start, end);
        try {
            markerContents = ps.getSelectedText();
        }
        catch (Exception exception) {
            return;
        }
        IDocument doc = ps.getDoc();
        List parametersAfterCall = ps.getParametersAfterCall(end);
        switch (id) {
            case 3: {
                this.addCreateClassOption(ps, edit, props, markerContents, parametersAfterCall);
                this.addCreateMethodOption(ps, edit, props, markerContents, parametersAfterCall);
                break;
            }
            case 9: {
                String[] activationTokenAndQual = ps.getActivationTokenAndQual(true);
                if (!activationTokenAndQual[0].endsWith(".")) break;
                ArrayList<IDefinition> selected = this.findDefinitions(nature, edit, start - 2, doc);
                for (IDefinition iDefinition : selected) {
                    IModule module = iDefinition.getModule();
                    if (module.getFile() == null) continue;
                    Definition definition = (Definition)iDefinition;
                    File file = module.getFile();
                    if (definition.ast == null) {
                        this.addCreateClassOption(ps, edit, props, markerContents, parametersAfterCall, file);
                        this.addCreateMethodOption(ps, edit, props, markerContents, parametersAfterCall, file);
                        continue;
                    }
                    if (!(definition.ast instanceof ClassDef)) continue;
                    ClassDef classDef = (ClassDef)definition.ast;
                    PyCreateMethodOrField pyCreateMethod = new PyCreateMethodOrField();
                    String className = NodeUtils.getNameFromNameTok((NameTokType)classDef.name);
                    pyCreateMethod.setCreateInClass(className);
                    pyCreateMethod.setCreateAs(1);
                    this.addCreateClassmethodOption(ps, edit, props, markerContents, parametersAfterCall, pyCreateMethod, file, className);
                }
                break;
            }
            case 6: {
                String fullPath;
                PyImportsHandling importsHandling = new PyImportsHandling(ps.getDoc(), false);
                int offsetLine = ps.getLineOfOffset(start);
                String selectedText = ps.getSelectedText();
                Tuple found = null;
                String foundFromImportStr = null;
                boolean isImportFrom = false;
                block10: for (ImportHandle handle : importsHandling) {
                    if (handle.startFoundLine != offsetLine && handle.endFoundLine != offsetLine && (handle.startFoundLine >= offsetLine || handle.endFoundLine <= offsetLine)) continue;
                    List importInfo = handle.getImportInfo();
                    for (ImportHandle.ImportHandleInfo importHandleInfo : importInfo) {
                        String fromImportStr = importHandleInfo.getFromImportStr();
                        List importedStr = importHandleInfo.getImportedStr();
                        for (String imported : importedStr) {
                            if (!selectedText.equals(imported)) continue;
                            if (fromImportStr != null) {
                                foundFromImportStr = new StringBuffer(String.valueOf(fromImportStr)).append(".").append(imported).toString();
                                isImportFrom = true;
                            } else {
                                foundFromImportStr = imported;
                            }
                            try {
                                String currentModule = nature.resolveModule(edit.getEditorFile());
                                ICompletionState state = CompletionStateFactory.getEmptyCompletionState((IPythonNature)nature, (ICompletionCache)new CompletionCache());
                                found = nature.getAstManager().findModule(foundFromImportStr, currentModule, state);
                            }
                            catch (Exception e) {
                                PydevPlugin.log((Throwable)e);
                            }
                            break block10;
                        }
                    }
                }
                boolean addOptionToCreateClassOrMethod = isImportFrom;
                if (found != null && found.o1 != null) {
                    File f;
                    if (!(found.o1 instanceof SourceModule) || found.o2 == null || ((String)found.o2).length() <= 0) break;
                    SourceModule sourceModule = (SourceModule)found.o1;
                    File file = sourceModule.getFile();
                    if (((String)found.o2).indexOf(46) != -1) {
                        if (!addOptionToCreateClassOrMethod) {
                            if (!sourceModule.getName().endsWith(".__init__")) break;
                            f = this.getFileStructure(file.getParentFile(), (String)found.o2);
                            this.addCreateModuleOption(ps, edit, props, markerContents, f);
                            break;
                        }
                        if (!sourceModule.getName().endsWith(".__init__")) break;
                        String moduleName = FullRepIterable.getWithoutLastPart((String)sourceModule.getName());
                        String withoutLastPart = FullRepIterable.getWithoutLastPart((String)((String)found.o2));
                        moduleName = new StringBuffer(String.valueOf(moduleName)).append(".").append(withoutLastPart).toString();
                        String classOrMethodName = FullRepIterable.getLastPart((String)((String)found.o2));
                        File f2 = this.getFileStructure(file.getParentFile(), withoutLastPart);
                        this.addCreateClassInNewModuleOption(ps, edit, props, classOrMethodName, moduleName, parametersAfterCall, f2);
                        this.addCreateMethodInNewModuleOption(ps, edit, props, classOrMethodName, moduleName, parametersAfterCall, f2);
                        break;
                    }
                    if (!addOptionToCreateClassOrMethod || sourceModule.getName().endsWith(".__init__")) {
                        if (!sourceModule.getName().endsWith(".__init__")) break;
                        f = new File(file.getParent(), new StringBuffer(String.valueOf((String)found.o2)).append(FileTypesPreferencesPage.getDefaultDottedPythonExtension()).toString());
                        this.addCreateModuleOption(ps, edit, props, markerContents, f);
                        break;
                    }
                    this.addCreateClassOption(ps, edit, props, markerContents, parametersAfterCall, file);
                    this.addCreateMethodOption(ps, edit, props, markerContents, parametersAfterCall, file);
                    break;
                }
                if (foundFromImportStr == null) break;
                File editorFile = edit.getEditorFile();
                String onlyProjectPythonPathStr = nature.getPythonPathNature().getOnlyProjectPythonPathStr(false);
                List split = StringUtils.splitAndRemoveEmptyTrimmed((String)onlyProjectPythonPathStr, (char)'|');
                int i = 0;
                while (i < split.size()) {
                    fullPath = REF.getFileAbsolutePath((String)((String)split.get(i)));
                    fullPath = PythonPathHelper.getDefaultPathStr((String)fullPath);
                    split.set(i, fullPath);
                    ++i;
                }
                HashSet projectSourcePath = new HashSet(split);
                if (projectSourcePath.size() == 0) {
                    return;
                }
                fullPath = REF.getFileAbsolutePath((File)editorFile);
                fullPath = PythonPathHelper.getDefaultPathStr((String)fullPath);
                String foundSourceFolderFullPath = null;
                if (projectSourcePath.size() == 1) {
                    foundSourceFolderFullPath = (String)projectSourcePath.iterator().next();
                } else {
                    for (String string : projectSourcePath) {
                        if (!fullPath.startsWith(string)) continue;
                        foundSourceFolderFullPath = string;
                        break;
                    }
                }
                if (foundSourceFolderFullPath == null) break;
                if (!addOptionToCreateClassOrMethod) {
                    File f = this.getFileStructure(new File(foundSourceFolderFullPath), foundFromImportStr);
                    this.addCreateModuleOption(ps, edit, props, foundFromImportStr, f);
                    break;
                }
                String moduleName = FullRepIterable.getWithoutLastPart((String)foundFromImportStr);
                File file = this.getFileStructure(new File(foundSourceFolderFullPath), moduleName);
                String lastPart = FullRepIterable.getLastPart((String)foundFromImportStr);
                this.addCreateClassInNewModuleOption(ps, edit, props, lastPart, moduleName, parametersAfterCall, file);
                this.addCreateMethodInNewModuleOption(ps, edit, props, lastPart, moduleName, parametersAfterCall, file);
            }
        }
    }

    protected File getFileStructure(File file, String withoutLastPart) {
        File f = file;
        List split = StringUtils.dotSplit((String)withoutLastPart);
        int size = split.size();
        int i = 0;
        while (i < size) {
            f = i == size - 1 ? new File(f, new StringBuffer(String.valueOf((String)split.get(i))).append(FileTypesPreferencesPage.getDefaultDottedPythonExtension()).toString()) : new File(f, (String)split.get(i));
            ++i;
        }
        return f;
    }

    private void addCreateClassmethodOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, List<String> parametersAfterCall, PyCreateMethodOrField pyCreateMethod, File file, String className) {
        props.add((ICompletionProposal)new TddRefactorCompletionInModule(markerContents, this.imageMethod, new StringBuffer("Create ").append(markerContents).append(" classmethod at ").append(className).append(" in ").append(file.getName()).toString(), null, new StringBuffer("Create ").append(markerContents).append(" classmethod at class: ").append(className).append(" in ").append(file).toString(), 5, edit, file, parametersAfterCall, pyCreateMethod, ps));
    }

    private void addCreateMethodOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, List<String> parametersAfterCall, File file) {
        props.add((ICompletionProposal)new TddRefactorCompletionInModule(markerContents, this.imageMethod, new StringBuffer("Create ").append(markerContents).append(" method at ").append(file.getName()).toString(), null, new StringBuffer("Create ").append(markerContents).append(" method at ").append(file).toString(), 5, edit, file, parametersAfterCall, new PyCreateMethodOrField(), ps));
    }

    private void addCreateClassOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, List<String> parametersAfterCall, File file) {
        props.add((ICompletionProposal)new TddRefactorCompletionInModule(markerContents, this.imageClass, new StringBuffer("Create ").append(markerContents).append(" class at ").append(file.getName()).toString(), null, new StringBuffer("Create ").append(markerContents).append(" class at ").append(file).toString(), 5, edit, file, parametersAfterCall, new PyCreateClass(), ps));
    }

    private void addCreateClassInNewModuleOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, String moduleName, List<String> parametersAfterCall, File file) {
        props.add((ICompletionProposal)new TddRefactorCompletionInInexistentModule(markerContents, this.imageClass, new StringBuffer("Create ").append(markerContents).append(" class at new module ").append(moduleName).toString(), null, new StringBuffer("Create ").append(markerContents).append(" class at new module ").append(file).toString(), 5, edit, file, new ArrayList<String>(), new PyCreateClass(), ps));
    }

    private void addCreateMethodInNewModuleOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, String moduleName, List<String> parametersAfterCall, File file) {
        props.add((ICompletionProposal)new TddRefactorCompletionInInexistentModule(markerContents, this.imageMethod, new StringBuffer("Create ").append(markerContents).append(" method at new module ").append(moduleName).toString(), null, new StringBuffer("Create ").append(markerContents).append(" method at new module ").append(file).toString(), 5, edit, file, new ArrayList<String>(), new PyCreateMethodOrField(), ps));
    }

    private void addCreateModuleOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, File file) {
        props.add((ICompletionProposal)new TddRefactorCompletionInInexistentModule(markerContents, this.imageModule, new StringBuffer("Create ").append(markerContents).append(" module").toString(), null, new StringBuffer("Create ").append(markerContents).append(" module (").append(file).append(")").toString(), 5, edit, file, new ArrayList<String>(), new NullPyCreateAction(), ps));
    }

    private void addCreateMethodOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, List<String> parametersAfterCall) {
        props.add((ICompletionProposal)new TddRefactorCompletion(markerContents, this.imageMethod, new StringBuffer("Create ").append(markerContents).append(" method").toString(), null, null, 5, edit, 0, parametersAfterCall, new PyCreateMethodOrField(), ps));
    }

    private void addCreateClassOption(PySelection ps, PyEdit edit, List<ICompletionProposal> props, String markerContents, List<String> parametersAfterCall) {
        props.add((ICompletionProposal)new TddRefactorCompletion(markerContents, this.imageClass, new StringBuffer("Create ").append(markerContents).append(" class").toString(), null, null, 5, edit, 0, parametersAfterCall, new PyCreateClass(), ps));
    }

    private ArrayList<IDefinition> findDefinitions(IPythonNature nature, PyEdit edit, int start, IDocument doc) {
        CompletionCache completionCache = new CompletionCache();
        ArrayList<IDefinition> selected = new ArrayList<IDefinition>();
        RefactoringRequest request = new RefactoringRequest(edit.getEditorFile(), new PySelection(doc, (ITextSelection)new TextSelection(doc, start, 0)), (IProgressMonitor)new NullProgressMonitor(), nature, edit);
        try {
            PyRefactoringFindDefinition.findActualDefinition((RefactoringRequest)request, (CompletionCache)completionCache, selected);
        }
        catch (CompletionRecursionException e1) {
            Log.log((Throwable)e1);
        }
        return selected;
    }
}

