/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.refactoring.wizards.TextInputWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.refactoring.RefactoringRequest;

public class PyRenameRefactoringWizard
extends RefactoringWizard {
    private final String fInputPageDescription;
    private RefactoringRequest req;
    private TextInputWizardPage inputPage;
    private String fInitialSetting;

    public PyRenameRefactoringWizard(Refactoring refactoring, String defaultPageTitle, String inputPageDescription, RefactoringRequest req, String initial) {
        super(refactoring, 4);
        this.setDefaultPageTitle(defaultPageTitle);
        this.fInputPageDescription = inputPageDescription;
        this.req = req;
        this.fInitialSetting = initial;
    }

    protected void addUserInputPages() {
        this.inputPage = this.createInputPage(this.fInputPageDescription, this.fInitialSetting);
        this.addPage((IWizardPage)this.inputPage);
    }

    protected TextInputWizardPage createInputPage(String message, String initialSetting) {
        return new TextInputWizardPage(message, true, initialSetting){

            protected RefactoringStatus validateTextField(String text) {
                RefactoringStatus status = new RefactoringStatus();
                if (StringUtils.isWord((String)text)) {
                    ((PyRenameRefactoringWizard)PyRenameRefactoringWizard.this).req.inputName = text;
                } else {
                    status.addFatalError("The name:" + text + " is not a valid identifier.");
                }
                return status;
            }

            public void createControl(Composite parent) {
                Composite superComposite = new Composite(parent, 0);
                this.setControl((Control)superComposite);
                this.initializeDialogUnits((Control)superComposite);
                superComposite.setLayout((Layout)new GridLayout());
                Composite composite = new Composite(superComposite, 0);
                composite.setLayoutData((Object)new GridData(768));
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                layout.verticalSpacing = 8;
                composite.setLayout((Layout)layout);
                Label label = new Label(composite, 0);
                label.setText("New value:");
                Text text = this.createTextInputField(composite);
                text.selectAll();
                GridData gd = new GridData(768);
                gd.widthHint = this.convertWidthInCharsToPixels(25);
                text.setLayoutData((Object)gd);
                Dialog.applyDialogFont((Control)superComposite);
            }
        };
    }
}

