/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.internal.console.IOConsolePartition;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.debug.core.IConsoleInputListener;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTargetWithTransmission;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.PyBreakpoint;
import org.python.pydev.debug.model.PyDebugModelPresentation;
import org.python.pydev.debug.model.PyRunToLineTarget;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.ValueModificationChecker;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.RemoveBreakpointCommand;
import org.python.pydev.debug.model.remote.RunCommand;
import org.python.pydev.debug.model.remote.SetBreakpointCommand;
import org.python.pydev.debug.model.remote.ThreadListCommand;
import org.python.pydev.debug.model.remote.VersionCommand;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDebugTarget
extends AbstractDebugTargetWithTransmission
implements IDebugTarget,
ILaunchListener {
    private static final boolean DEBUG = false;
    protected IPath[] file;
    protected PyThread[] threads;
    protected boolean disconnected = false;
    protected AbstractRemoteDebugger debugger;
    protected ILaunch launch;
    private ValueModificationChecker modificationChecker = new ValueModificationChecker();
    private PyRunToLineTarget runToLineTarget;

    public abstract boolean canTerminate();

    public abstract boolean isTerminated();

    public ValueModificationChecker getModificationChecker() {
        return this.modificationChecker;
    }

    public void terminate() {
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (Exception exception) {}
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception exception) {}
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        this.socket = null;
        this.disconnected = true;
        if (this.writer != null) {
            this.writer.done();
            this.writer = null;
        }
        if (this.reader != null) {
            this.reader.done();
            this.reader = null;
        }
        this.threads = new PyThread[0];
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public AbstractRemoteDebugger getDebugger() {
        return this.debugger;
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public String getModelIdentifier() {
        return PyDebugModelPresentation.PY_DEBUG_MODEL_ID;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getName() throws DebugException {
        if (this.file != null) {
            return PythonRunnerConfig.getRunningName(this.file);
        }
        return "unknown";
    }

    public boolean canResume() {
        int i = 0;
        while (i < this.threads.length) {
            if (this.threads[i].canResume()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canSuspend() {
        int i = 0;
        while (i < this.threads.length) {
            if (this.threads[i].canSuspend()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
        int i = 0;
        while (i < this.threads.length) {
            this.threads[i].resume();
            ++i;
        }
    }

    public void suspend() throws DebugException {
        int i = 0;
        while (i < this.threads.length) {
            this.threads[i].suspend();
            ++i;
        }
    }

    public IThread[] getThreads() throws DebugException {
        if (this.debugger == null) {
            return null;
        }
        if (this.threads == null) {
            ThreadListCommand cmd = new ThreadListCommand(this);
            this.postCommand(cmd);
            try {
                cmd.waitUntilDone(1000);
                this.threads = cmd.getThreads();
            }
            catch (InterruptedException interruptedException) {
                this.threads = new PyThread[0];
            }
        }
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof PyBreakpoint;
    }

    private boolean shouldSkipBreakpoints() {
        DebugPlugin manager = DebugPlugin.getDefault();
        return manager != null && !manager.getBreakpointManager().isEnabled();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        try {
            PyBreakpoint b;
            if (breakpoint instanceof PyBreakpoint && (b = (PyBreakpoint)breakpoint).isEnabled() && !this.shouldSkipBreakpoints()) {
                String condition = b.getCondition();
                if (condition != null) {
                    condition = StringUtils.replaceAll((String)condition, (String)"\n", (String)"@_@NEW_LINE_CHAR@_@");
                    condition = StringUtils.replaceAll((String)condition, (String)"\t", (String)"@_@TAB_CHAR@_@");
                }
                SetBreakpointCommand cmd = new SetBreakpointCommand(this, b.getFile(), b.getLine(), condition, b.getFunctionName());
                this.postCommand(cmd);
            }
        }
        catch (CoreException e) {
            PydevPlugin.log((Throwable)e);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof PyBreakpoint) {
            PyBreakpoint b = (PyBreakpoint)breakpoint;
            RemoveBreakpointCommand cmd = new RemoveBreakpointCommand(this, b.getFile(), b.getLine());
            this.postCommand(cmd);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof PyBreakpoint) {
            this.breakpointRemoved(breakpoint, null);
            this.breakpointAdded(breakpoint);
        }
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void processCommand(String sCmdCode, String sSeqCode, String payload) {
        try {
            int cmdCode = Integer.parseInt(sCmdCode);
            if (cmdCode == 103) {
                this.processThreadCreated(payload);
            } else if (cmdCode == 104) {
                this.processThreadKilled(payload);
            } else if (cmdCode == 105) {
                this.processThreadSuspended(payload);
            } else if (cmdCode == 106) {
                this.processThreadRun(payload);
            } else {
                PydevDebugPlugin.log(2, new StringBuffer("Unexpected debugger command:").append(sCmdCode).append("\nseq:").append(sSeqCode).append("\npayload:").append(payload).toString(), null);
            }
        }
        catch (Exception e) {
            PydevDebugPlugin.log(4, new StringBuffer("Error processing: ").append(sCmdCode).append("\npayload: ").append(payload).toString(), e);
        }
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected PyThread findThreadByID(String thread_id) {
        PyThread[] pyThreadArray = this.threads;
        int n = this.threads.length;
        int n2 = 0;
        while (n2 < n) {
            PyThread thread = pyThreadArray[n2];
            if (thread_id.equals(thread.getId())) {
                return thread;
            }
            ++n2;
        }
        return null;
    }

    private void processThreadCreated(String payload) {
        int i;
        PyThread[] newThreads;
        try {
            newThreads = XMLUtils.ThreadsFromXML(this, payload);
        }
        catch (CoreException e) {
            PydevDebugPlugin.errorDialog("Error in processThreadCreated", e);
            return;
        }
        if (PydevDebugPlugin.getDefault().getPreferenceStore().getBoolean("HIDE_PYDEVD_THREADS")) {
            int removeThisMany = 0;
            i = 0;
            while (i < newThreads.length) {
                if (newThreads[i].isPydevThread()) {
                    ++removeThisMany;
                }
                ++i;
            }
            if (removeThisMany > 0) {
                int newSize = newThreads.length - removeThisMany;
                if (newSize == 0) {
                    return;
                }
                PyThread[] newnewThreads = new PyThread[newSize];
                int i2 = 0;
                PyThread[] pyThreadArray = newThreads;
                int n = newThreads.length;
                int n2 = 0;
                while (n2 < n) {
                    PyThread newThread = pyThreadArray[n2];
                    if (!newThread.isPydevThread()) {
                        newnewThreads[i2] = newThread;
                        ++i2;
                    }
                    ++n2;
                }
                newThreads = newnewThreads;
            }
        }
        if (this.threads == null) {
            this.threads = newThreads;
        } else {
            PyThread[] combined = new PyThread[this.threads.length + newThreads.length];
            i = 0;
            i = 0;
            while (i < this.threads.length) {
                combined[i] = this.threads[i];
                ++i;
            }
            int j = 0;
            while (j < newThreads.length) {
                combined[i] = newThreads[j];
                ++i;
                ++j;
            }
            this.threads = combined;
        }
        int i3 = 0;
        while (i3 < newThreads.length) {
            this.fireEvent(new DebugEvent((Object)newThreads[i3], 4));
            ++i3;
        }
    }

    private void processThreadKilled(String thread_id) {
        PyThread threadToDelete = this.findThreadByID(thread_id);
        if (threadToDelete != null) {
            int j = 0;
            PyThread[] newThreads = new PyThread[this.threads.length - 1];
            int i = 0;
            while (i < this.threads.length) {
                if (this.threads[i] != threadToDelete) {
                    newThreads[j++] = this.threads[i];
                }
                ++i;
            }
            this.threads = newThreads;
            this.fireEvent(new DebugEvent((Object)threadToDelete, 8));
        }
    }

    private void processThreadSuspended(String payload) {
        Object[] threadNstack;
        try {
            threadNstack = XMLUtils.XMLToStack(this, payload);
        }
        catch (CoreException e) {
            PydevDebugPlugin.errorDialog("Error reading ThreadSuspended", e);
            return;
        }
        PyThread t = (PyThread)((Object)threadNstack[0]);
        int reason = 0;
        String stopReason = (String)threadNstack[1];
        if (stopReason != null) {
            int stopReason_i = Integer.parseInt(stopReason);
            if (stopReason_i == 108 || stopReason_i == 107 || stopReason_i == 109 || stopReason_i == 118 || stopReason_i == 121) {
                reason = 8;
            } else if (stopReason_i == 105) {
                reason = 32;
            } else if (stopReason_i == 111) {
                reason = 16;
            } else {
                PydevDebugPlugin.log(4, "Unexpected reason for suspension", null);
                reason = 0;
            }
        }
        if (t != null) {
            this.modificationChecker.onlyLeaveThreads(this.threads);
            IStackFrame[] stackFrame = (IStackFrame[])threadNstack[2];
            t.setSuspended(true, stackFrame);
            this.fireEvent(new DebugEvent((Object)t, 2, reason));
        }
    }

    public static Tuple<String, String> getThreadIdAndReason(String payload) throws CoreException {
        List split = StringUtils.split((String)payload.trim(), (char)'\t');
        if (split.size() != 2) {
            String msg = new StringBuffer("Unexpected threadRun payload ").append(payload).append("(unable to match)").toString();
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, msg, new RuntimeException(msg)));
        }
        return new Tuple((Object)((String)split.get(0)), (Object)((String)split.get(1)));
    }

    private void processThreadRun(String payload) {
        try {
            Tuple<String, String> threadIdAndReason = AbstractDebugTarget.getThreadIdAndReason(payload);
            int resumeReason = 0;
            try {
                int raw_reason = Integer.parseInt((String)threadIdAndReason.o2);
                if (raw_reason == 108) {
                    resumeReason = 2;
                } else if (raw_reason == 109) {
                    resumeReason = 4;
                } else if (raw_reason == 107) {
                    resumeReason = 1;
                } else if (raw_reason == 118) {
                    resumeReason = 0;
                } else if (raw_reason == 121) {
                    resumeReason = 0;
                } else if (raw_reason == 106) {
                    resumeReason = 32;
                } else {
                    PydevDebugPlugin.log(4, "Unexpected resume reason code", null);
                    resumeReason = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                resumeReason = 0;
            }
            String threadID = (String)threadIdAndReason.o1;
            PyThread t = this.findThreadByID(threadID);
            if (t != null) {
                t.setSuspended(false, null);
                this.fireEvent(new DebugEvent((Object)t, 1, resumeReason));
            } else {
                FastStringBuffer buf = new FastStringBuffer();
                PyThread[] pyThreadArray = this.threads;
                int n = this.threads.length;
                int n2 = 0;
                while (n2 < n) {
                    PyThread thread = pyThreadArray[n2];
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(new StringBuffer("id: ").append(thread.getId()).toString());
                    ++n2;
                }
                String msg = new StringBuffer("Unable to find thread: ").append(threadID).append(" available: ").append(buf).toString();
                PydevDebugPlugin.log(4, msg, new RuntimeException(msg));
            }
        }
        catch (CoreException e1) {
            Log.log((Throwable)e1);
        }
    }

    public void initialize() {
        this.postCommand(new VersionCommand(this));
        this.addBreakpointsFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        RunCommand run = new RunCommand(this);
        this.postCommand(run);
    }

    private void addBreakpointsFor(IContainer container) {
        try {
            PyBreakpoint brk;
            IMarker marker;
            IMarker[] markers = container.findMarkers("org.python.pydev.debug.pyStopBreakpointMarker", true, 2);
            IMarker[] condMarkers = container.findMarkers("org.python.pydev.debug.pyConditionalStopBreakpointMarker", true, 2);
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                brk = (PyBreakpoint)breakpointManager.getBreakpoint(marker);
                this.breakpointAdded((IBreakpoint)brk);
                ++n2;
            }
            iMarkerArray = condMarkers;
            n = condMarkers.length;
            n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                brk = (PyBreakpoint)breakpointManager.getBreakpoint(marker);
                this.breakpointAdded((IBreakpoint)brk);
                ++n2;
            }
        }
        catch (Throwable t) {
            PydevDebugPlugin.errorDialog("Error setting breakpoints", t);
        }
    }

    public void addConsoleInputListener() {
        IConsole console = DebugUITools.getConsole((IProcess)this.getProcess());
        if (console instanceof ProcessConsole) {
            ProcessConsole c = (ProcessConsole)console;
            final List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.debug.pydev_debug_console_input_listener");
            final AbstractDebugTarget target = this;
            c.getDocument().addDocumentListener(new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                    if (event.fText.indexOf(13) != -1 || event.fText.indexOf(10) != -1) {
                        try {
                            IOConsolePartition p;
                            ITypedRegion partition = event.fDocument.getPartition(event.fOffset);
                            if (partition instanceof IOConsolePartition && (p = (IOConsolePartition)partition).getType().equals(IOConsolePartition.INPUT_PARTITION_TYPE) && event.fText.length() <= 2) {
                                String inputFound = p.getString();
                                Iterator iterator = participants.iterator();
                                while (iterator.hasNext()) {
                                    IConsoleInputListener listener = (IConsoleInputListener)iterator.next();
                                    listener.newLineReceived(inputFound, target);
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                }

                public void documentChanged(DocumentEvent event) {
                    if (event.fText.indexOf(13) != -1 || event.fText.indexOf(10) != -1) {
                        try {
                            IOConsolePartition p;
                            ITypedRegion partition = event.fDocument.getPartition(event.fOffset);
                            if (partition instanceof IOConsolePartition && (p = (IOConsolePartition)partition).getType().equals(IOConsolePartition.INPUT_PARTITION_TYPE) && event.fText.length() > 2) {
                                Iterator iterator = participants.iterator();
                                while (iterator.hasNext()) {
                                    IConsoleInputListener listener = (IConsoleInputListener)iterator.next();
                                    listener.pasteReceived(event.fText, target);
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public boolean canDisconnect() {
        return !this.disconnected;
    }

    public void disconnect() throws DebugException {
        this.terminate();
        this.modificationChecker = null;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public Object getAdapter(Class adapter) {
        AdapterDebug.print((Object)this, adapter);
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/core/ILaunch"))) {
            return this.launch;
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"))) {
            if (this.file != null) {
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(this.file[0]);
                if (files != null && files.length > 0) {
                    return files[0];
                }
                return null;
            }
        } else {
            if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/ui/actions/IRunToLineTarget"))) {
                return this.getRunToLineTarget();
            }
            if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/properties/IPropertySource"))) {
                return this.launch.getAdapter(adapter);
            }
            if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/tasklist/ITaskListResourceAdapter")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/ui/actions/IToggleBreakpointsTarget"))) {
                return super.getAdapter(adapter);
            }
        }
        AdapterDebug.printDontKnow((Object)this, adapter);
        return super.getAdapter(adapter);
    }

    public PyRunToLineTarget getRunToLineTarget() {
        if (this.runToLineTarget == null) {
            this.runToLineTarget = new PyRunToLineTarget();
        }
        return this.runToLineTarget;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }
}

