/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.python.pydev.debug.pyunit.ClearTerminatedAction;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.debug.pyunit.SetCurrentRunAction;
import org.python.pydev.plugin.PydevPlugin;

public class HistoryAction
extends Action {
    private WeakReference<PyUnitView> view;

    public HistoryAction(PyUnitView view) {
        this.view = new WeakReference<PyUnitView>(view);
        this.setMenuCreator(new HistoryMenuCreator());
        this.setToolTipText("Test Run History");
        this.setImageDescriptor(PydevPlugin.getImageCache().getDescriptor("icons/history_list.gif"));
    }

    public class HistoryMenuCreator
    implements IMenuCreator {
        private Menu fMenu;

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(final IMenuManager manager2) {
                    HistoryMenuCreator.this.fillMenuManager(new IActionsMenu(){

                        public void add(IAction action) {
                            manager2.add(action);
                        }
                    });
                }
            });
            this.fMenu = manager.createContextMenu(parent);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void fillMenuManager(IActionsMenu actionsMenu) {
            if (HistoryAction.this.view == null) {
                return;
            }
            PyUnitView pyUnitView = (PyUnitView)((Object)HistoryAction.this.view.get());
            if (pyUnitView == null) {
                return;
            }
            PyUnitTestRun currentTestRun = pyUnitView.getCurrentTestRun();
            List<PyUnitTestRun> allTestRuns = pyUnitView.getAllTestRuns();
            Iterator<PyUnitTestRun> iterator = allTestRuns.iterator();
            while (iterator.hasNext()) {
                PyUnitTestRun pyUnitTestRun = iterator.next();
                SetCurrentRunAction runAction = new SetCurrentRunAction(HistoryAction.this.view, pyUnitTestRun);
                runAction.setChecked(pyUnitTestRun == currentTestRun);
                runAction.setText(pyUnitTestRun.name);
                actionsMenu.add((IAction)runAction);
            }
            actionsMenu.add((IAction)new ClearTerminatedAction(HistoryAction.this.view));
        }
    }

    public static interface IActionsMenu {
        public void add(IAction var1);
    }
}

