/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.core.launching;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerLog;
import org.radrails.server.core.ServerManager;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLaunchListener
implements ILaunchListener {
    public void launchRemoved(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
        Server matching = this.grabLaunchedServer(launch);
        if (matching == null) {
            return;
        }
        matching.started(launch.getProcesses()[0]);
    }

    public void launchAdded(ILaunch launch) {
        Server matching = this.grabLaunchedServer(launch);
        if (matching == null) {
            return;
        }
        matching.updateStatus("Starting...");
    }

    private Server grabLaunchedServer(ILaunch launch) {
        ILaunchConfiguration config;
        block7: {
            block6: {
                block5: {
                    try {
                        config = launch.getLaunchConfiguration();
                        if (config != null) break block5;
                        return null;
                    }
                    catch (CoreException e) {
                        ServerLog.log((CoreException)e);
                        return null;
                    }
                }
                String typeId = config.getType().getIdentifier();
                if (!typeId.equals("org.radrails.server.ui.RailsAppLaunchConfigurationType")) break block6;
                return null;
            }
            String filename = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, null);
            if (this.looksLikeServerLaunchFile(filename)) break block7;
            return null;
        }
        String projectName = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        Collection<Server> servers = ServerManager.getInstance().getServersForProject(project);
        return this.findMatchingServer(config, servers);
    }

    private boolean looksLikeServerLaunchFile(String filename) {
        if (filename == null) {
            return false;
        }
        if (filename.endsWith("gem")) {
            return false;
        }
        if (filename.endsWith("script/server") || filename.endsWith("script\\server")) {
            return true;
        }
        return filename.endsWith("mongrel_rails") && filename.equals(RailsPlugin.getInstance().getMongrelPath());
    }

    private Server findMatchingServer(ILaunchConfiguration config, Collection<Server> servers) {
        if (servers == null || servers.isEmpty()) {
            return null;
        }
        if (servers.size() == 1) {
            return servers.iterator().next();
        }
        try {
            String args = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            for (Server server : servers) {
                if (!args.equals(server.getProgramArguments())) continue;
                return server;
            }
        }
        catch (CoreException e) {
            ServerLog.log((CoreException)e);
        }
        return null;
    }
}

