/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.testunit.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.rubypeople.rdt.internal.testunit.ui.OpenTestAction;
import org.rubypeople.rdt.internal.testunit.ui.RerunAction;
import org.rubypeople.rdt.internal.testunit.ui.TestRunInfo;
import org.rubypeople.rdt.internal.testunit.ui.TestRunTab;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitView;

public class FailureTab
extends TestRunTab
implements IMenuListener {
    private Table fTable;
    private TestUnitView fRunnerViewPart;
    private boolean fMoveSelection = false;
    private final Image fErrorIcon = TestUnitView.createImage("obj16/testerr.gif");
    private final Image fFailureIcon = TestUnitView.createImage("obj16/testfail.gif");
    private final Image fFailureTabIcon = TestUnitView.createImage("obj16/failures.gif");

    public void createTabControl(CTabFolder tabFolder, Clipboard clipboard, TestUnitView runner) {
        this.fRunnerViewPart = runner;
        CTabItem failureTab = new CTabItem(tabFolder, 0);
        failureTab.setText(this.getName());
        failureTab.setImage(this.fFailureTabIcon);
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.fTable = new Table(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fTable.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        this.fTable.setLayoutData((Object)gridData);
        failureTab.setControl((Control)composite);
        failureTab.setToolTipText(TestUnitMessages.FailureRunView_tab_tooltip);
        this.initMenu();
        this.addListeners();
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
        this.fFailureTabIcon.dispose();
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public String getName() {
        return TestUnitMessages.FailureRunView_tab_title;
    }

    public String getSelectedTestId() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.getTestInfo(this.fTable.getItem(index)).getTestId();
    }

    public String getAllFailedTestNames() {
        StringBuffer trace = new StringBuffer();
        String lineDelim = System.getProperty("line.separator", "\n");
        int i = 0;
        while (i < this.fTable.getItemCount()) {
            TestRunInfo testInfo = this.getTestInfo(this.fTable.getItem(i));
            trace.append(testInfo.getTestName()).append(lineDelim);
            String failureTrace = testInfo.getTrace();
            if (failureTrace != null) {
                StringReader stringReader = new StringReader(failureTrace);
                BufferedReader bufferedReader = new BufferedReader(stringReader);
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        trace.append(String.valueOf(line) + lineDelim);
                    }
                }
                catch (IOException iOException) {
                    trace.append(lineDelim);
                }
            }
            ++i;
        }
        return trace.toString();
    }

    private String getClassName() {
        TableItem item = this.getSelectedItem();
        TestRunInfo info = this.getTestInfo(item);
        return info.getClassName();
    }

    private String getMethodName() {
        TableItem item = this.getSelectedItem();
        TestRunInfo info = this.getTestInfo(item);
        return info.getTestMethodName();
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTable.getSelectionCount() > 0) {
            String className = this.getClassName();
            String methodName = this.getMethodName();
            if (className != null) {
                manager.add((IAction)new OpenTestAction(this.fRunnerViewPart, className, methodName, true));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new RerunAction(this.fRunnerViewPart, this.getSelectedTestId(), className, methodName, "run"));
                manager.add((IAction)new RerunAction(this.fRunnerViewPart, this.getSelectedTestId(), className, methodName, "debug"));
                manager.add((IContributionItem)new Separator());
            }
        }
    }

    private TableItem getSelectedItem() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.fTable.getItem(index);
    }

    public void setSelectedTest(String testId) {
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem tableItem = items[i];
            TestRunInfo info = this.getTestInfo(tableItem);
            if (info.getTestId().equals(testId)) {
                this.fTable.setSelection(new TableItem[]{tableItem});
                this.fTable.showItem(tableItem);
                return;
            }
            ++i;
        }
    }

    private TestRunInfo getTestInfo(TableItem item) {
        return (TestRunInfo)item.getData();
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    public void endTest(String testId) {
        TestRunInfo testInfo = this.fRunnerViewPart.getTestInfo(testId);
        if (testInfo == null || testInfo.getStatus() == 0) {
            return;
        }
        TableItem tableItem = new TableItem(this.fTable, 0);
        this.updateTableItem(testInfo, tableItem);
        this.fTable.showItem(tableItem);
    }

    private void updateTableItem(TestRunInfo testInfo, TableItem tableItem) {
        String label = TestUnitMessages.getFormattedString(TestUnitMessages.FailureRunView_labelfmt, new String[]{testInfo.getTestMethodName(), testInfo.getClassName()});
        tableItem.setText(label);
        if (testInfo.getStatus() == 2) {
            tableItem.setImage(this.fFailureIcon);
        } else {
            tableItem.setImage(this.fErrorIcon);
        }
        tableItem.setData((Object)testInfo);
    }

    private TableItem findItem(String testId) {
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            TestRunInfo info = this.getTestInfo(items[i]);
            if (info.getTestId().equals(testId)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public void activate() {
        this.fMoveSelection = false;
        this.testSelected();
    }

    public void aboutToStart() {
        this.fMoveSelection = false;
        this.fTable.removeAll();
    }

    private void testSelected() {
        this.fRunnerViewPart.handleTestSelected(this.getSelectedTestId());
    }

    private void addListeners() {
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FailureTab.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FailureTab.this.activate();
            }
        });
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FailureTab.this.disposeIcons();
            }
        });
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FailureTab.this.handleDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                FailureTab.this.activate();
            }

            public void mouseUp(MouseEvent e) {
                FailureTab.this.activate();
            }
        });
    }

    void handleDoubleClick(MouseEvent e) {
        if (this.fTable.getSelectionCount() > 0) {
            new OpenTestAction(this.fRunnerViewPart, this.getClassName(), this.getMethodName(), true).run();
        }
    }

    public void testStatusChanged(TestRunInfo info) {
        TableItem item = this.findItem(info.getTestId());
        if (item != null) {
            if (info.getStatus() == 0) {
                item.dispose();
                return;
            }
            this.updateTableItem(info, item);
        }
        if (item == null && info.getStatus() != 0) {
            item = new TableItem(this.fTable, 0);
            this.updateTableItem(info, item);
        }
        if (item != null) {
            this.fTable.showItem(item);
        }
    }

    public void selectNext() {
        if (this.fTable.getItemCount() == 0) {
            return;
        }
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            index = 0;
        }
        if (this.fMoveSelection) {
            index = Math.min(this.fTable.getItemCount() - 1, index + 1);
        } else {
            this.fMoveSelection = true;
        }
        this.selectTest(index);
    }

    public void selectPrevious() {
        if (this.fTable.getItemCount() == 0) {
            return;
        }
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            index = this.fTable.getItemCount() - 1;
        }
        if (this.fMoveSelection) {
            index = Math.max(0, index - 1);
        } else {
            this.fMoveSelection = true;
        }
        this.selectTest(index);
    }

    private void selectTest(int index) {
        TableItem item = this.fTable.getItem(index);
        TestRunInfo info = this.getTestInfo(item);
        this.fRunnerViewPart.showTest(info);
    }
}

