/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.testunit.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.rubypeople.rdt.internal.testunit.ui.CompareResultsAction;
import org.rubypeople.rdt.internal.testunit.ui.CopyTraceAction;
import org.rubypeople.rdt.internal.testunit.ui.EnableStackFilterAction;
import org.rubypeople.rdt.internal.testunit.ui.OpenEditorAtLineAction;
import org.rubypeople.rdt.internal.testunit.ui.TestRunInfo;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitPreferencePage;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitView;
import org.rubypeople.rdt.internal.ui.util.StackTraceLine;

public class FailureTrace
implements IMenuListener {
    static final String FRAME_PREFIX = "at ";
    private final Image fStackIcon = TestUnitView.createImage("obj16/stkfrm_obj.gif");
    private final Image fExceptionIcon = TestUnitView.createImage("obj16/exc_catch.gif");
    private Table fTable;
    private String fInputTrace;
    private final Clipboard fClipboard;
    private TestRunInfo fFailure;
    private CompareResultsAction fCompareAction;
    private TestUnitView fTestRunner;

    public FailureTrace(Composite parent, Clipboard clipboard, TestUnitView testRunner, ToolBar toolBar) {
        Assert.isNotNull((Object)clipboard);
        ToolBarManager failureToolBarmanager = new ToolBarManager(toolBar);
        failureToolBarmanager.add((IAction)new EnableStackFilterAction(this));
        this.fCompareAction = new CompareResultsAction(this);
        this.fCompareAction.setEnabled(false);
        failureToolBarmanager.add((IAction)this.fCompareAction);
        failureToolBarmanager.update(true);
        this.fTestRunner = testRunner;
        this.fTable = new Table(parent, 772);
        this.fClipboard = clipboard;
        OpenStrategy handler = new OpenStrategy((Control)this.fTable);
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                Action a;
                if (FailureTrace.this.fTable.getSelectionIndex() == 0 && FailureTrace.this.fFailure.isComparisonFailure()) {
                    new CompareResultsAction(FailureTrace.this).run();
                }
                if (FailureTrace.this.fTable.getSelection().length != 0 && (a = FailureTrace.this.createOpenEditorAction(FailureTrace.this.getSelectedText())) != null) {
                    a.run();
                }
            }
        });
        this.initMenu();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FailureTrace.this.disposeIcons();
            }
        });
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTable.getSelectionCount() > 0) {
            Action a = this.createOpenEditorAction(this.getSelectedText());
            if (a != null) {
                manager.add((IAction)a);
            }
            manager.add((IAction)new CopyTraceAction(this, this.fClipboard));
        }
        if (this.fFailure != null && this.fFailure.isComparisonFailure()) {
            manager.add((IAction)new CompareResultsAction(this));
        }
    }

    public String getTrace() {
        return this.fInputTrace;
    }

    private String getSelectedText() {
        return this.fTable.getSelection()[0].getText();
    }

    private Action createOpenEditorAction(String traceLine) {
        StackTraceLine stack = new StackTraceLine(traceLine, this.fTestRunner.getLaunchedProject());
        return new OpenEditorAtLineAction(this.fTestRunner, stack.getFilename(), stack.getLineNumber());
    }

    private void disposeIcons() {
        if (this.fExceptionIcon != null && !this.fExceptionIcon.isDisposed()) {
            this.fExceptionIcon.dispose();
        }
        if (this.fStackIcon != null && !this.fStackIcon.isDisposed()) {
            this.fStackIcon.dispose();
        }
    }

    public Composite getComposite() {
        return this.fTable;
    }

    public void refresh() {
        this.updateTable(this.fInputTrace);
    }

    public void showFailure(TestRunInfo failure) {
        this.fFailure = failure;
        String trace = "";
        this.updateEnablement(failure);
        if (failure != null) {
            trace = failure.getTrace();
        }
        if (this.fInputTrace == trace) {
            return;
        }
        this.fInputTrace = trace;
        this.updateTable(trace);
    }

    public void updateEnablement(TestRunInfo failure) {
        this.fCompareAction.setEnabled(failure != null && failure.isComparisonFailure());
    }

    private void updateTable(String trace) {
        if (trace == null || trace.trim().equals("")) {
            this.clear();
            return;
        }
        trace = trace.trim();
        this.fTable.setRedraw(false);
        this.fTable.removeAll();
        this.fillTable(this.filterStack(trace, this.getFilterPatterns()));
        this.fTable.setRedraw(true);
    }

    private String[] getFilterPatterns() {
        if (TestUnitPreferencePage.getFilterStack()) {
            return TestUnitPreferencePage.getFilterPatterns();
        }
        return new String[0];
    }

    private void fillTable(String trace) {
        StringReader stringReader = new StringReader(trace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                return;
            }
            TableItem tableItem = new TableItem(this.fTable, 0);
            String itemLabel = line.replace('\t', ' ');
            tableItem.setText(itemLabel);
            tableItem.setImage(this.fExceptionIcon);
            while ((line = bufferedReader.readLine()) != null) {
                itemLabel = line.replace('\t', ' ');
                tableItem = new TableItem(this.fTable, 0);
                if (itemLabel.indexOf(" at ") >= 0) {
                    tableItem.setImage(this.fStackIcon);
                }
                tableItem.setText(itemLabel);
            }
        }
        catch (IOException iOException) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            tableItem.setText(trace);
        }
    }

    public void setInformation(String text) {
        this.clear();
        TableItem tableItem = new TableItem(this.fTable, 0);
        tableItem.setText(text);
    }

    public void clear() {
        this.fTable.removeAll();
        this.fInputTrace = null;
    }

    private String filterStack(String stackTrace, String[] filterPatterns) {
        if (filterPatterns.length == 0 || stackTrace == null) {
            return stackTrace;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(stackTrace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String[] patterns = filterPatterns;
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (this.filterLine(patterns, line)) continue;
                printWriter.println(line);
            }
        }
        catch (IOException iOException) {
            return stackTrace;
        }
        return stringWriter.toString();
    }

    private boolean filterLine(String[] patterns, String line) {
        if (line == null || line.trim().length() == 0) {
            return false;
        }
        if (Character.isDigit(line.trim().charAt(0))) {
            return false;
        }
        int i = patterns.length - 1;
        while (i >= 0) {
            String pattern = patterns[i];
            int len = pattern.length() - 1;
            if (pattern.charAt(len) == '*') {
                pattern = pattern.substring(0, len);
            } else if (Character.isUpperCase(pattern.charAt(0))) {
                pattern = FRAME_PREFIX + pattern + '.';
            } else {
                int lastDotIndex = pattern.lastIndexOf(46);
                if (lastDotIndex != -1 && lastDotIndex != len && Character.isUpperCase(pattern.charAt(lastDotIndex + 1))) {
                    pattern = String.valueOf(pattern) + '.';
                }
            }
            if (line.indexOf(pattern) > 0) {
                return true;
            }
            --i;
        }
        return false;
    }

    public TestRunInfo getFailedTest() {
        return this.fFailure;
    }

    public Shell getShell() {
        return this.fTable.getShell();
    }
}

