/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.testunit.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.debug.ui.RubySourceLocator;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitView;
import org.rubypeople.rdt.internal.testunit.ui.TestunitPlugin;

public class OpenEditorAtLineAction
extends Action {
    private int fLineNumber;
    private String fileName;
    private TestUnitView fTestRunner;

    public OpenEditorAtLineAction(TestUnitView testRunner, String fileName, int line) {
        super(TestUnitMessages.OpenEditorAction_action_label);
        this.fLineNumber = line;
        this.fTestRunner = testRunner;
        IRubyProject project = testRunner.getLaunchedProject();
        this.fileName = project != null ? fileName.replace("#{RAILS_ROOT}", project.getProject().getLocation().toPortableString()) : fileName;
    }

    public void run() {
        try {
            IEditorInput input = this.getInput();
            if (input == null) {
                if (TestunitPlugin.getDefault().isDebugging()) {
                    System.out.println("Could not create editor input for stack trace: " + this.fileName);
                }
                return;
            }
            IEditorPart editorPart = this.getEditorPart(input);
            this.setEditorToLine(editorPart, input);
        }
        catch (CoreException e) {
            TestunitPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.testunit", 0, "Could not open editor or set line in editor." + this.fileName, (Throwable)e));
        }
    }

    private IEditorPart getEditorPart(IEditorInput input) throws PartInitException {
        ISourceLocator sourceLocator = this.getSourceLocator();
        if (!(sourceLocator instanceof RubySourceLocator)) {
            return null;
        }
        RubySourceLocator rubySourceLocator = (RubySourceLocator)sourceLocator;
        RubySourceLocator.SourceElement sourceElement = (RubySourceLocator.SourceElement)rubySourceLocator.getSourceElement(this.fileName);
        IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)sourceElement.getFilename());
        return IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)descriptor.getId());
    }

    private void setEditorToLine(IEditorPart pEditorPart, IEditorInput pInput) throws CoreException {
        IDocumentProvider provider;
        block5: {
            if (!(pEditorPart instanceof ITextEditor)) {
                return;
            }
            if (this.fLineNumber > 0) {
                --this.fLineNumber;
            }
            if (this.fLineNumber == 0) {
                return;
            }
            ITextEditor textEditor = (ITextEditor)pEditorPart;
            provider = textEditor.getDocumentProvider();
            provider.connect((Object)pInput);
            IDocument document = provider.getDocument((Object)pInput);
            try {
                IRegion line = document.getLineInformation(this.fLineNumber);
                textEditor.selectAndReveal(line.getOffset(), line.getLength());
            }
            catch (BadLocationException badLocationException) {
                if (!TestunitPlugin.getDefault().isDebugging()) break block5;
                System.out.println("Could not set editor to line: " + this.fLineNumber);
            }
        }
        provider.disconnect((Object)pInput);
    }

    protected void reveal(ITextEditor textEditor) {
        if (this.fLineNumber >= 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(this.fLineNumber - 1), document.getLineLength(this.fLineNumber - 1));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public boolean isEnabled() {
        return this.getInput() != null;
    }

    private IEditorInput getInput() {
        ISourceLocator sourceLocator = this.getSourceLocator();
        if (!(sourceLocator instanceof RubySourceLocator)) {
            return null;
        }
        RubySourceLocator rubySourceLocator = (RubySourceLocator)sourceLocator;
        Object sourceElement = rubySourceLocator.getSourceElement(this.fileName);
        IEditorInput input = rubySourceLocator.getEditorInput(sourceElement);
        return input;
    }

    private ISourceLocator getSourceLocator() {
        ILaunch launch = this.fTestRunner.getLastLaunch();
        if (launch == null) {
            return null;
        }
        return launch.getSourceLocator();
    }

    protected Shell getShell() {
        return this.fTestRunner.getSite().getShell();
    }

    protected IRubyProject getLaunchedProject() {
        return this.fTestRunner.getLaunchedProject();
    }
}

