/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.testunit.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitPreferencesConstants;
import org.rubypeople.rdt.internal.testunit.ui.TestunitPlugin;
import org.rubypeople.rdt.internal.testunit.util.LayoutUtil;
import org.rubypeople.rdt.internal.ui.util.SWTUtil;
import org.rubypeople.rdt.internal.ui.util.TableLayoutComposite;
import org.rubypeople.rdt.ui.RubyUI;

public class TestUnitPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_NEW_FILTER_TEXT = "";
    private static final Image IMG_CUNIT = RubyUI.getSharedImages().getImage("org.rubypeople.rdt.ui.class_obj.gif");
    private static final Image IMG_PKG = RubyUI.getSharedImages().getImage("org.rubypeople.rdt.ui.fldr_obj.gif");
    private Label fFilterViewerLabel;
    private CheckboxTableViewer fFilterViewer;
    private Table fFilterTable;
    private Button fRemoveFilterButton;
    private Button fAddFilterButton;
    private Button fEnableAllButton;
    private Button fDisableAllButton;
    private Text fEditorText;
    private String fInvalidEditorText = null;
    private TableEditor fTableEditor;
    private TableItem fNewTableItem;
    private Filter fNewStackFilter;
    private StackFilterContentProvider fStackFilterContentProvider;

    public TestUnitPreferencePage() {
        this.setDescription(TestUnitMessages.TestUnitPreferencePage_description);
        this.setPreferenceStore(TestunitPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createStackFilterPreferences(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createStackFilterPreferences(Composite composite) {
        this.fFilterViewerLabel = new Label(composite, 16388);
        this.fFilterViewerLabel.setText(TestUnitMessages.TestUnitPreferencePage_filter_label);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createFilterTable(container);
        this.createStepFilterButtons(container);
    }

    private void createFilterTable(Composite container) {
        TableLayoutComposite layouter = new TableLayoutComposite(container, 0);
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        layouter.setLayoutData((Object)new GridData(1808));
        this.fFilterTable = new Table((Composite)layouter, 67618);
        new TableColumn(this.fFilterTable, 0);
        this.fFilterViewer = new CheckboxTableViewer(this.fFilterTable);
        this.fTableEditor = new TableEditor(this.fFilterTable);
        this.fFilterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fFilterViewer.setSorter((ViewerSorter)new FilterViewerSorter());
        this.fStackFilterContentProvider = new StackFilterContentProvider();
        this.fFilterViewer.setContentProvider((IContentProvider)this.fStackFilterContentProvider);
        this.fFilterViewer.setInput((Object)this);
        this.fFilterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Filter filter = (Filter)event.getElement();
                TestUnitPreferencePage.this.fStackFilterContentProvider.toggleFilter(filter);
            }
        });
        this.fFilterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                TestUnitPreferencePage.this.fRemoveFilterButton.setEnabled(!selection.isEmpty());
            }
        });
    }

    private void createStepFilterButtons(Composite container) {
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = new Button(buttonContainer, 8);
        this.fAddFilterButton.setText(TestUnitMessages.TestUnitPreferencePage_addfilterbutton_label);
        this.fAddFilterButton.setToolTipText(TestUnitMessages.TestUnitPreferencePage_addfilterbutton_tooltip);
        gd = new GridData(770);
        this.fAddFilterButton.setLayoutData((Object)gd);
        LayoutUtil.setButtonDimensionHint(this.fAddFilterButton);
        this.fAddFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestUnitPreferencePage.this.editFilter();
            }
        });
        this.fRemoveFilterButton = new Button(buttonContainer, 8);
        this.fRemoveFilterButton.setText(TestUnitMessages.TestUnitPreferencePage_removefilterbutton_label);
        this.fRemoveFilterButton.setToolTipText(TestUnitMessages.TestUnitPreferencePage_removefilterbutton_tooltip);
        gd = this.getButtonGridData(this.fRemoveFilterButton);
        this.fRemoveFilterButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fRemoveFilterButton);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestUnitPreferencePage.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        this.fEnableAllButton = new Button(buttonContainer, 8);
        this.fEnableAllButton.setText(TestUnitMessages.TestUnitPreferencePage_enableallbutton_label);
        this.fEnableAllButton.setToolTipText(TestUnitMessages.TestUnitPreferencePage_enableallbutton_tooltip);
        gd = this.getButtonGridData(this.fEnableAllButton);
        this.fEnableAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fEnableAllButton);
        this.fEnableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestUnitPreferencePage.this.checkAllFilters(true);
            }
        });
        this.fDisableAllButton = new Button(buttonContainer, 8);
        this.fDisableAllButton.setText(TestUnitMessages.TestUnitPreferencePage_disableallbutton_label);
        this.fDisableAllButton.setToolTipText(TestUnitMessages.TestUnitPreferencePage_disableallbutton_tooltip);
        gd = this.getButtonGridData(this.fDisableAllButton);
        this.fDisableAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fDisableAllButton);
        this.fDisableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestUnitPreferencePage.this.checkAllFilters(false);
            }
        });
    }

    private GridData getButtonGridData(Button button) {
        GridData gd = new GridData(770);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return gd;
    }

    public void init(IWorkbench workbench) {
    }

    private void editFilter() {
        if (this.fEditorText != null) {
            this.validateChangeAndCleanup();
        }
        this.fNewStackFilter = this.fStackFilterContentProvider.addFilter(DEFAULT_NEW_FILTER_TEXT, true);
        this.fNewTableItem = this.fFilterTable.getItem(0);
        int textStyles = 16388;
        if (!SWT.getPlatform().equals("motif")) {
            textStyles |= 0x800;
        }
        this.fEditorText = new Text((Composite)this.fFilterTable, textStyles);
        GridData gd = new GridData(1808);
        this.fEditorText.setLayoutData((Object)gd);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        this.fTableEditor.setEditor((Control)this.fEditorText, this.fNewTableItem, 0);
        this.fEditorText.setText(this.fNewStackFilter.getName());
        this.fEditorText.selectAll();
        this.setEditorListeners(this.fEditorText);
        this.fEditorText.setFocus();
    }

    private void setEditorListeners(Text text) {
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    if (TestUnitPreferencePage.this.fInvalidEditorText != null) {
                        TestUnitPreferencePage.this.fEditorText.setText(TestUnitPreferencePage.this.fInvalidEditorText);
                        TestUnitPreferencePage.this.fInvalidEditorText = null;
                    } else {
                        TestUnitPreferencePage.this.validateChangeAndCleanup();
                    }
                } else if (event.character == '\u001b') {
                    TestUnitPreferencePage.this.removeNewFilter();
                    TestUnitPreferencePage.this.cleanupEditor();
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (TestUnitPreferencePage.this.fInvalidEditorText != null) {
                    TestUnitPreferencePage.this.fEditorText.setText(TestUnitPreferencePage.this.fInvalidEditorText);
                    TestUnitPreferencePage.this.fInvalidEditorText = null;
                } else {
                    TestUnitPreferencePage.this.validateChangeAndCleanup();
                }
            }
        });
        text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
    }

    private void validateChangeAndCleanup() {
        String trimmedValue = this.fEditorText.getText().trim();
        if (trimmedValue.length() < 1) {
            this.removeNewFilter();
        } else {
            if (!this.validateEditorInput(trimmedValue)) {
                this.fInvalidEditorText = trimmedValue;
                this.fEditorText.setText(TestUnitMessages.TestUnitPreferencePage_invalidstepfilterreturnescape);
                this.getShell().getDisplay().beep();
                return;
            }
            Object[] filters = this.fStackFilterContentProvider.getElements(null);
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                if (filter.getName().equals(trimmedValue)) {
                    this.removeNewFilter();
                    this.cleanupEditor();
                    return;
                }
                ++i;
            }
            this.fNewTableItem.setText(trimmedValue);
            this.fNewStackFilter.setName(trimmedValue);
            this.fFilterViewer.refresh();
        }
        this.cleanupEditor();
    }

    private void cleanupEditor() {
        if (this.fEditorText == null) {
            return;
        }
        this.fNewStackFilter = null;
        this.fNewTableItem = null;
        this.fTableEditor.setEditor(null, null, 0);
        this.fEditorText.dispose();
        this.fEditorText = null;
    }

    private void removeNewFilter() {
        this.fStackFilterContentProvider.removeFilters(new Object[]{this.fNewStackFilter});
    }

    private boolean validateEditorInput(String trimmedValue) {
        char firstChar = trimmedValue.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar) || firstChar == '*') {
            return false;
        }
        int length = trimmedValue.length();
        int i = 1;
        while (i < length) {
            char c = trimmedValue.charAt(i);
            if (!(Character.isJavaIdentifierPart(c) || c == '.' && i != length - 1 || c == '*' && i == length - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void removeFilters() {
        IStructuredSelection selection = (IStructuredSelection)this.fFilterViewer.getSelection();
        this.fStackFilterContentProvider.removeFilters(selection.toArray());
    }

    private void checkAllFilters(boolean check) {
        Object[] filters = this.fStackFilterContentProvider.getElements(null);
        int i = filters.length - 1;
        while (i >= 0) {
            ((Filter)filters[i]).setChecked(check);
            --i;
        }
        this.fFilterViewer.setAllChecked(check);
    }

    public boolean performOk() {
        this.fStackFilterContentProvider.saveFilters();
        return true;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fStackFilterContentProvider.setDefaults();
    }

    protected List createActiveStackFiltersList() {
        return Arrays.asList(TestUnitPreferencePage.getFilterPatterns());
    }

    protected List createInactiveStackFiltersList() {
        String[] strings = TestUnitPreferencePage.parseList(this.getPreferenceStore().getString("org.rubypeople.rdt.testunit.inactive_filters"));
        return Arrays.asList(strings);
    }

    protected void updateActions() {
        if (this.fEnableAllButton == null) {
            return;
        }
        boolean enabled = this.fFilterViewer.getTable().getItemCount() > 0;
        this.fEnableAllButton.setEnabled(enabled);
        this.fDisableAllButton.setEnabled(enabled);
    }

    public static String[] getFilterPatterns() {
        IPreferenceStore store = TestunitPlugin.getDefault().getPreferenceStore();
        return TestUnitPreferencePage.parseList(store.getString("org.rubypeople.rdt.testunit.active_filters"));
    }

    public static boolean getFilterStack() {
        IPreferenceStore store = TestunitPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.rubypeople.rdt.testunit.do_filter_stack");
    }

    public static void setFilterStack(boolean filter) {
        IPreferenceStore store = TestunitPlugin.getDefault().getPreferenceStore();
        store.setValue("org.rubypeople.rdt.testunit.do_filter_stack", filter);
    }

    private static String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    private static class Filter {
        private String fName;
        private boolean fChecked;

        public Filter(String name, boolean checked) {
            this.setName(name);
            this.setChecked(checked);
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public boolean isChecked() {
            return this.fChecked;
        }

        public void setChecked(boolean checked) {
            this.fChecked = checked;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)o;
            return this.getName().equals(other.getName());
        }

        public int hashCode() {
            return this.fName.hashCode();
        }
    }

    private static class FilterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FilterLabelProvider() {
        }

        public String getColumnText(Object object, int column) {
            return column == 0 ? ((Filter)object).getName() : TestUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT;
        }

        public String getText(Object element) {
            return ((Filter)element).getName();
        }

        public Image getColumnImage(Object object, int column) {
            String name = ((Filter)object).getName();
            if (name.endsWith(".*") || name.equals(TestUnitMessages.TestUnitMainTab_label_defaultpackage)) {
                return IMG_PKG;
            }
            if (TestUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT.equals(name)) {
                return null;
            }
            if (Character.isUpperCase(name.charAt(0)) && name.indexOf(46) < 0) {
                return IMG_CUNIT;
            }
            int lastDotIndex = name.lastIndexOf(46);
            if (-1 != lastDotIndex && name.length() - 1 != lastDotIndex && Character.isUpperCase(name.charAt(lastDotIndex + 1))) {
                return IMG_CUNIT;
            }
            return null;
        }
    }

    private static class FilterViewerSorter
    extends WorkbenchViewerSorter {
        private FilterViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ILabelProvider lprov = (ILabelProvider)((ContentViewer)viewer).getLabelProvider();
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 == null) {
                name1 = TestUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT;
            }
            if (name2 == null) {
                name2 = TestUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT;
            }
            if (name1.length() > 0 && name2.length() > 0) {
                char char1 = name1.charAt(name1.length() - 1);
                char char2 = name2.charAt(name2.length() - 1);
                if (char1 == '*' && char1 != char2) {
                    return -1;
                }
                if (char2 == '*' && char2 != char1) {
                    return 1;
                }
            }
            return name1.compareTo(name2);
        }
    }

    private class StackFilterContentProvider
    implements IStructuredContentProvider {
        private List fFilters;

        public StackFilterContentProvider() {
            List active = TestUnitPreferencePage.this.createActiveStackFiltersList();
            List inactive = TestUnitPreferencePage.this.createInactiveStackFiltersList();
            this.populateFilters(active, inactive);
        }

        public void setDefaults() {
            TestUnitPreferencePage.this.fFilterViewer.remove(this.fFilters.toArray());
            List active = TestUnitPreferencesConstants.createDefaultStackFiltersList();
            ArrayList inactive = new ArrayList();
            this.populateFilters(active, inactive);
        }

        protected void populateFilters(List activeList, List inactiveList) {
            this.fFilters = new ArrayList(activeList.size() + inactiveList.size());
            this.populateList(activeList, true);
            if (inactiveList.size() != 0) {
                this.populateList(inactiveList, false);
            }
        }

        protected void populateList(List list, boolean checked) {
            for (String name : list) {
                this.addFilter(name, checked);
            }
        }

        public Filter addFilter(String name, boolean checked) {
            Filter filter = new Filter(name, checked);
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
                TestUnitPreferencePage.this.fFilterViewer.add((Object)filter);
                TestUnitPreferencePage.this.fFilterViewer.setChecked((Object)filter, checked);
            }
            TestUnitPreferencePage.this.updateActions();
            return filter;
        }

        public void saveFilters() {
            ArrayList<String> active = new ArrayList<String>(this.fFilters.size());
            ArrayList<String> inactive = new ArrayList<String>(this.fFilters.size());
            for (Filter filter : this.fFilters) {
                String name = filter.getName();
                if (filter.isChecked()) {
                    active.add(name);
                    continue;
                }
                inactive.add(name);
            }
            String pref = TestUnitPreferencesConstants.serializeList(active.toArray(new String[active.size()]));
            TestUnitPreferencePage.this.getPreferenceStore().setValue("org.rubypeople.rdt.testunit.active_filters", pref);
            pref = TestUnitPreferencesConstants.serializeList(inactive.toArray(new String[inactive.size()]));
            TestUnitPreferencePage.this.getPreferenceStore().setValue("org.rubypeople.rdt.testunit.inactive_filters", pref);
        }

        public void removeFilters(Object[] filters) {
            int i = filters.length - 1;
            while (i >= 0) {
                Filter filter = (Filter)filters[i];
                this.fFilters.remove(filter);
                --i;
            }
            TestUnitPreferencePage.this.fFilterViewer.remove(filters);
            TestUnitPreferencePage.this.updateActions();
        }

        public void toggleFilter(Filter filter) {
            boolean newState = !filter.isChecked();
            filter.setChecked(newState);
            TestUnitPreferencePage.this.fFilterViewer.setChecked((Object)filter, newState);
        }

        public Object[] getElements(Object inputElement) {
            return this.fFilters.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

