/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.testunit.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitView;
import org.rubypeople.rdt.testunit.ITestRunListener;
import org.rubypeople.rdt.testunit.launcher.TestUnitLaunchConfigurationDelegate;

public class TestunitPlugin
extends AbstractUIPlugin
implements ILaunchListener {
    public static final String PLUGIN_ID = "org.rubypeople.rdt.testunit";
    public static final String TESTUNIT_PORT_ATTR = "org.rubypeople.rdt.testunit.port";
    private static TestunitPlugin plugin;
    private ResourceBundle resourceBundle;
    private AbstractSet<ILaunch> fTrackedLaunches = new HashSet<ILaunch>(20);
    private Set<ITestRunListener> fTestRunListeners = new HashSet<ITestRunListener>();
    private static URL fgIconBaseURL;

    public TestunitPlugin() {
        plugin = this;
        String pathSuffix = "icons/full/";
        try {
            fgIconBaseURL = new URL(Platform.getBundle((String)PLUGIN_ID).getEntry("/"), pathSuffix);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.rubypeople.rdt.testunit.TestunitPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static URL makeIconFileURL(String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(fgIconBaseURL, name);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        try {
            return ImageDescriptor.createFromURL((URL)TestunitPlugin.makeIconFileURL(relativePath));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static TestunitPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = TestunitPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(Throwable e) {
        TestunitPlugin.log((IStatus)new Status(4, TestunitPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        TestunitPlugin.getDefault().getLog().log(status);
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = TestunitPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (plugin == null) {
            return null;
        }
        IWorkbench workBench = plugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkspace getWorkspace() {
        return RubyCore.getWorkspace();
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = TestunitPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public void connectTestRunner(ILaunch launch, IType finalType, int port) {
        TestUnitView testRunnerViewPart = this.showTestUnitViewInActivePage(this.findTestUnitViewInActivePage());
        if (testRunnerViewPart != null) {
            testRunnerViewPart.startTestRunListening(port, finalType, launch, this.fTestRunListeners);
        }
    }

    public void addTestRunListener(ITestRunListener listener) {
        this.fTestRunListeners.add(listener);
    }

    public void removeTestRunListener(ITestRunListener listener) {
        this.fTestRunListeners.remove(listener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TestUnitView showTestUnitViewInActivePage(TestUnitView testRunner) {
        block12: {
            block11: {
                block9: {
                    block10: {
                        activePart = null;
                        page = null;
                        try {
                            if (testRunner != null && testRunner.isCreated()) {
                                var6_4 = testRunner;
                                if (page == null || activePart == null) break block9;
                                break block10;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (PartInitException pie) {
                            TestunitPlugin.log(pie);
                        }
                        finally {
                            if (page == null || activePart == null) break block11;
                        }
                    }
                    page.activate(activePart);
                }
                return var6_4;
lbl-1000:
                // 1 sources

                {
                    page = TestunitPlugin.getActivePage();
                    if (page == null) {
                    }
                    ** GOTO lbl-1000
                }
                page.activate(activePart);
            }
            return null;
lbl-1000:
            // 1 sources

            {
                activePart = page.getActivePart();
                var6_5 = (TestUnitView)page.showView("org.rubypeople.rdt.testunit.views.TestUnitView");
                if (page == null || activePart == null) break block12;
            }
            page.activate(activePart);
        }
        return var6_5;
    }

    public TestUnitView findTestUnitViewInActivePage() {
        IWorkbenchPage page = TestunitPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        return (TestUnitView)page.findView("org.rubypeople.rdt.testunit.views.TestUnitView");
    }

    public static void log(String string) {
        TestunitPlugin.log(new Throwable(string));
    }

    public void launchRemoved(final ILaunch launch) {
        this.fTrackedLaunches.remove(launch);
        TestunitPlugin.getDisplay().asyncExec(new Runnable(){

            public void run() {
                TestUnitView testRunnerViewPart = TestunitPlugin.this.findTestRunnerViewPartInActivePage();
                if (testRunnerViewPart != null && testRunnerViewPart.isCreated() && launch.equals(testRunnerViewPart.getLastLaunch())) {
                    testRunnerViewPart.reset();
                }
            }
        });
    }

    private TestUnitView findTestRunnerViewPartInActivePage() {
        IWorkbenchPage page = TestunitPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        return (TestUnitView)page.findView("org.rubypeople.rdt.testunit.views.TestUnitView");
    }

    public void launchChanged(final ILaunch launch) {
        IRubyElement element;
        String typeStr;
        if (!this.fTrackedLaunches.contains(launch)) {
            return;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        IType launchedType = null;
        if (config != null && (typeStr = launch.getAttribute("org.rubypeople.rdt.testunit.TESTTYPE")) != null && typeStr.trim().length() > 0 && (element = RubyCore.create((String)typeStr)) instanceof IType) {
            launchedType = (IType)element;
        }
        this.fTrackedLaunches.remove(launch);
        final IType finalType = launchedType;
        final int finalPort = Integer.parseInt(launch.getAttribute(TESTUNIT_PORT_ATTR));
        TestunitPlugin.getDisplay().asyncExec(new Runnable(){

            public void run() {
                TestunitPlugin.this.connectTestRunner(launch, finalType, finalPort);
            }
        });
    }

    public void launchAdded(ILaunch launch) {
        try {
            if (launch == null || launch.getLaunchConfiguration() == null || launch.getLaunchConfiguration().getType() == null) {
                return;
            }
            if (launch.getLaunchConfiguration().getType().getDelegate(launch.getLaunchMode()).getClass() != TestUnitLaunchConfigurationDelegate.class) {
                return;
            }
            this.fTrackedLaunches.add(launch);
        }
        catch (Exception ex) {
            TestunitPlugin.log(ex);
        }
    }
}

