/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.SocketUtil;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.testunit.ui.TestunitPlugin;
import org.rubypeople.rdt.launching.RubyLaunchDelegate;

public class TestUnitLaunchConfigurationDelegate
extends RubyLaunchDelegate {
    public static final String TESTTYPE_ATTR = "org.rubypeople.rdt.testunit.TESTTYPE";
    public static final String TESTNAME_ATTR = "org.rubypeople.rdt.testunit.TESTNAME";
    public static final String LAUNCH_CONTAINER_ATTR = "org.rubypeople.rdt.testunit.CONTAINER";
    public static final String ID_TESTUNIT_APPLICATION = "org.rubypeople.rdt.testunit.launchconfig";
    private static final String TEST_RUNNER_FILE = "RemoteTestRunner.rb";
    private int port = -1;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IType[] testTypes = this.findTestTypes(configuration, monitor);
        TestUnitLaunchConfigurationDelegate.getTestRunnerPath();
        launch.setAttribute("org.rubypeople.rdt.testunit.port", Integer.toString(this.getPort()));
        if (testTypes != null && testTypes.length > 0 && testTypes[0] != null) {
            launch.setAttribute(TESTTYPE_ATTR, testTypes[0].getHandleIdentifier());
        }
        super.launch(configuration, mode, launch, monitor);
    }

    protected IType[] findTestTypes(ILaunchConfiguration configuration, IProgressMonitor pm) throws CoreException {
        String testTypeName;
        IRubyElement element;
        String containerHandle;
        IRubyProject javaProject = this.getRubyProject(configuration);
        if (javaProject == null || !javaProject.exists()) {
            this.informAndAbort(TestUnitMessages.TestUnitBaseLaunchConfiguration_error_invalidproject, null, 107);
        }
        if ((containerHandle = configuration.getAttribute(LAUNCH_CONTAINER_ATTR, "")).length() > 0 && (element = RubyCore.create((String)containerHandle)) != null) {
            IType type;
            if (element.isType(5)) {
                return new IType[]{(IType)element};
            }
            IRubyScript script = (IRubyScript)element;
            if (script != null && (type = script.findPrimaryType()) != null) {
                return new IType[]{type};
            }
        }
        if ((testTypeName = configuration.getAttribute(TESTTYPE_ATTR, null)) != null && testTypeName.length() > 0) {
            return new IType[]{javaProject.findType(testTypeName, pm)};
        }
        return new IType[0];
    }

    protected void informAndAbort(String message, Throwable exception, int code) throws CoreException {
        Status status = new Status(1, "org.rubypeople.rdt.testunit", code, message, exception);
        if (this.showStatusMessage((IStatus)status)) {
            throw new CoreException((IStatus)status);
        }
        this.abort(message, exception, code);
    }

    private boolean showStatusMessage(final IStatus status) {
        final boolean[] success = new boolean[1];
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = TestunitPlugin.getActiveWorkbenchShell();
                if (shell == null) {
                    shell = TestUnitLaunchConfigurationDelegate.this.getDisplay().getActiveShell();
                }
                if (shell != null) {
                    MessageDialog.openInformation((Shell)shell, (String)TestUnitMessages.JUnitBaseLaunchConfiguration_dialog_title, (String)status.getMessage());
                    success[0] = true;
                }
            }
        });
        return success[0];
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String getTestRunnerPath() {
        RubyCore.copyToStateLocation((Plugin)TestunitPlugin.getDefault(), (IPath)new Path("ruby").append(TEST_RUNNER_FILE));
        RubyCore.copyToStateLocation((Plugin)TestunitPlugin.getDefault(), (IPath)new Path("ruby").append("RemoteTestRunnerRSpec.rb"));
        IPath path = TestunitPlugin.getDefault().getStateLocation().append(new Path("ruby").append(TEST_RUNNER_FILE));
        if (!path.toFile().exists()) {
            throw new RuntimeException("Expected directory of ruby/RemoteTestRunner.rb does not exist: " + path);
        }
        return path.toPortableString();
    }

    private int getPort() {
        if (this.port == -1) {
            this.port = SocketUtil.findFreePort();
        }
        return this.port;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLaunchContainerPath(configuration));
        buffer.append(' ');
        buffer.append(Integer.toString(this.getPort()));
        buffer.append(' ');
        buffer.append(Boolean.toString(false));
        buffer.append(' ');
        buffer.append(configuration.getAttribute(TESTTYPE_ATTR, ""));
        buffer.append(' ');
        buffer.append(configuration.getAttribute(TESTNAME_ATTR, ""));
        return buffer.toString();
    }

    private String getLaunchContainerPath(ILaunchConfiguration configuration) throws CoreException {
        String container = configuration.getAttribute(LAUNCH_CONTAINER_ATTR, "");
        IRubyElement element = RubyCore.create((String)container);
        if (element != null) {
            container = element.getResource().getProjectRelativePath().toOSString();
        }
        if (!container.startsWith("\"") && container.indexOf(32) != -1) {
            container = String.valueOf('\"') + container + '\"';
        }
        return container;
    }
}

