/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.corext.codemanipulation.StubUtility;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.testunit.util.LayoutUtil;
import org.rubypeople.rdt.internal.testunit.util.TestUnitStatus;
import org.rubypeople.rdt.internal.testunit.wizards.MethodStubsSelectionButtonGroup;
import org.rubypeople.rdt.internal.testunit.wizards.WizardMessages;
import org.rubypeople.rdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.rubypeople.rdt.testunit.wizards.RubyNewTestCaseWizardPageTwo;
import org.rubypeople.rdt.ui.wizards.NewTypeWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyNewTestCaseWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewTestCaseCreationWizardPage";
    public static final String CLASS_UNDER_TEST = "NewTestCaseCreationWizardPage.classundertest";
    private static final String TEST_SUFFIX = "Test";
    private static final String PREFIX = "test";
    private static final String STORE_SETUP = "NewTestCaseCreationWizardPage.USE_SETUP";
    private static final String STORE_TEARDOWN = "NewTestCaseCreationWizardPage.USE_TEARDOWN";
    private static final String STORE_CONSTRUCTOR = "NewTestCaseCreationWizardPage.USE_CONSTRUCTOR";
    private static final int IDX_SETUP = 0;
    private static final int IDX_TEARDOWN = 1;
    private static final int IDX_CONSTRUCTOR = 2;
    private String fClassUnderTestText;
    private MethodStubsSelectionButtonGroup fMethodStubsButtons;
    private Text fClassUnderTestControl;
    private Button fClassUnderTestButton;
    private IStatus fClassUnderTestStatus;
    private IType fClassUnderTest;
    private RubyNewTestCaseWizardPageTwo fPage2;

    public RubyNewTestCaseWizardPage(RubyNewTestCaseWizardPageTwo page2) {
        super(true, PAGE_NAME);
        this.fPage2 = page2;
        this.setTitle(WizardMessages.NewTestCaseWizardPage_title);
        this.setDescription(WizardMessages.NewTestCaseWizardPage_description);
        String[] buttonNames = new String[]{WizardMessages.NewTestCaseWizardPage_methodStub_setUp, WizardMessages.NewTestCaseWizardPage_methodStub_tearDown, WizardMessages.NewTestCaseWizardPage_methodStub_constructor};
        this.fMethodStubsButtons = new MethodStubsSelectionButtonGroup(32, buttonNames, 2);
        this.fMethodStubsButtons.setLabelText(WizardMessages.NewTestCaseWizardPage_method_Stub_label);
        this.fClassUnderTestStatus = new TestUnitStatus();
        this.fClassUnderTestText = "";
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        container.setLayout((Layout)layout);
        this.createContainerControls(container, nColumns);
        this.createSeparator(container, nColumns);
        this.createTypeNameControls(container, nColumns);
        this.createSuperClassControls(container, nColumns);
        this.createMethodStubSelectionControls(container, nColumns);
        this.createSeparator(container, nColumns);
        this.createClassUnderTestControls(container, nColumns);
        this.setControl((Control)container);
        this.setSuperClass("Test::Unit::TestCase", true);
        String classUnderTest = this.getClassUnderTestText();
        if (classUnderTest.length() > 0) {
            this.setTypeName(String.valueOf(classUnderTest) + TEST_SUFFIX, true);
        }
        Dialog.applyDialogFont((Control)container);
        this.setFocus();
    }

    protected void createTypeMembers(IType type, IProgressMonitor monitor) throws CoreException {
        String lineDelimiter = this.getLineDelimiter();
        if (this.fMethodStubsButtons.isSelected(2)) {
            this.createConstructor(type, lineDelimiter);
        }
        if (this.fMethodStubsButtons.isSelected(0)) {
            this.createSetUp(type, lineDelimiter);
        }
        if (this.fMethodStubsButtons.isSelected(1)) {
            this.createTearDown(type, lineDelimiter);
        }
        if (this.fClassUnderTest != null) {
            this.createTestMethodStubs(type);
        }
    }

    protected List<String> addImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("test/unit");
        return imports;
    }

    private void createConstructor(IType type, String lineDelimiter) throws CoreException {
        StringBuffer content = new StringBuffer();
        content.append("def initialize").append(lineDelimiter);
        content.append("  super").append(lineDelimiter);
        content.append("end").append(lineDelimiter);
        type.createMethod(content.toString(), null, true, null);
    }

    private void createSetUp(IType type, String lineDelimiter) throws CoreException {
        StringBuffer content = new StringBuffer();
        content.append("def setup").append(lineDelimiter);
        content.append("  super").append(lineDelimiter);
        content.append("end").append(lineDelimiter);
        type.createMethod(content.toString(), null, true, null);
    }

    private void createTearDown(IType type, String lineDelimiter) throws CoreException {
        StringBuffer content = new StringBuffer();
        content.append("def teardown").append(lineDelimiter);
        content.append("  super").append(lineDelimiter);
        content.append("end").append(lineDelimiter);
        type.createMethod(content.toString(), null, true, null);
    }

    private void createTestMethodStubs(IType type) throws CoreException {
        IMethod[] methods = this.fPage2.getCheckedMethods();
        if (methods.length == 0) {
            return;
        }
        IMethod[] allMethodsArray = this.fPage2.getAllMethods();
        ArrayList allMethods = new ArrayList();
        allMethods.addAll(Arrays.asList(allMethodsArray));
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < methods.length) {
            IMethod method = methods[i];
            String elementName = method.getElementName();
            StringBuffer name = new StringBuffer(PREFIX).append("_").append(elementName);
            StringBuffer buffer = new StringBuffer();
            String testName = name.toString();
            if (names.contains(testName)) {
                int suffix = 1;
                while (names.contains(String.valueOf(testName) + Integer.toString(suffix))) {
                    ++suffix;
                }
                name.append(Integer.toString(suffix));
            }
            testName = name.toString();
            names.add(testName);
            buffer.append("  def ");
            buffer.append(testName).append(this.getLineDelimiter());
            this.appendTestMethodBody(buffer, testName, method, type.getRubyScript());
            buffer.append("  end").append(this.getLineDelimiter());
            type.createMethod(buffer.toString(), null, false, null);
            ++i;
        }
    }

    private void appendTestMethodBody(StringBuffer buffer, String name, IMethod method, IRubyScript targetCu) throws CoreException {
        String todoTaskTag;
        String delimiter = this.getLineDelimiter();
        String todoTask = "";
        if (this.fPage2.isCreateTasks() && (todoTaskTag = "TODO") != null) {
            todoTask = " # " + todoTaskTag;
        }
        String message = WizardMessages.NewTestCaseWizardPageOne_not_yet_implemented_string;
        buffer.append(Messages.format((String)"    flunk \"{0}\"", (Object)message)).append(todoTask).append(delimiter);
    }

    private String getLineDelimiter() throws RubyModelException {
        IType classToTest = this.getClassUnderTest();
        if (classToTest == null && this.getSourceFolder() != null && this.getSourceFolder().exists()) {
            return StubUtility.getLineDelimiterUsed((IRubyElement)this.getSourceFolder());
        }
        if (classToTest != null && classToTest.exists() && classToTest.getRubyScript() != null) {
            return classToTest.getRubyScript().findRecommendedLineSeparator();
        }
        return "\n";
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), nColumns);
        LayoutUtil.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    protected void createClassUnderTestControls(Composite composite, int nColumns) {
        Label classUnderTestLabel = new Label(composite, 16448);
        classUnderTestLabel.setFont(composite.getFont());
        classUnderTestLabel.setText(WizardMessages.NewTestCaseWizardPage_class_to_test_label);
        classUnderTestLabel.setLayoutData((Object)new GridData());
        this.fClassUnderTestControl = new Text(composite, 2052);
        this.fClassUnderTestControl.setEnabled(true);
        this.fClassUnderTestControl.setFont(composite.getFont());
        this.fClassUnderTestControl.setText(this.fClassUnderTestText);
        this.fClassUnderTestControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RubyNewTestCaseWizardPage.this.internalSetClassUnderText(((Text)e.widget).getText());
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        this.fClassUnderTestControl.setLayoutData((Object)gd);
        this.fClassUnderTestButton = new Button(composite, 8);
        this.fClassUnderTestButton.setText(WizardMessages.NewTestCaseWizardPage_class_to_test_browse);
        this.fClassUnderTestButton.setEnabled(true);
        this.fClassUnderTestButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RubyNewTestCaseWizardPage.this.classToTestButtonPressed();
            }

            public void widgetSelected(SelectionEvent e) {
                RubyNewTestCaseWizardPage.this.classToTestButtonPressed();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = 1;
        gd.widthHint = LayoutUtil.getButtonWidthHint(this.fClassUnderTestButton);
        this.fClassUnderTestButton.setLayoutData((Object)gd);
    }

    private IType chooseClassToTestType() {
        ISourceFolder root = this.getSourceFolder();
        if (root == null) {
            return null;
        }
        IRubyElement[] elements = new IRubyElement[]{root.getRubyProject()};
        IRubySearchScope scope = SearchEngine.createRubySearchScope((IRubyElement[])elements);
        TypeSelectionDialog2 dialog = new TypeSelectionDialog2(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 4);
        dialog.setTitle(WizardMessages.NewTestCaseWizardPage_class_to_test_dialog_title);
        dialog.setMessage(WizardMessages.NewTestCaseWizardPage_class_to_test_dialog_message);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private void classToTestButtonPressed() {
        IType type = this.chooseClassToTestType();
        if (type != null) {
            this.setClassUnderTest(type.getElementName());
        }
    }

    public void setClassUnderTest(String name) {
        if (this.fClassUnderTestControl != null && !this.fClassUnderTestControl.isDisposed()) {
            this.fClassUnderTestControl.setText(name);
        }
        this.internalSetClassUnderText(name);
    }

    private void internalSetClassUnderText(String name) {
        this.fClassUnderTestText = name;
        this.fClassUnderTestStatus = this.classUnderTestChanged();
        this.handleFieldChanged(CLASS_UNDER_TEST);
    }

    protected IStatus classUnderTestChanged() {
        IStatus val;
        TestUnitStatus status = new TestUnitStatus();
        this.fClassUnderTest = null;
        ISourceFolder root = this.getSourceFolder();
        if (root == null) {
            return status;
        }
        String classToTestName = this.getClassUnderTestText();
        if (classToTestName.length() == 0) {
            return status;
        }
        String classUnderTest = this.getClassUnderTestText();
        if (classUnderTest.length() > 0) {
            this.setTypeName(String.valueOf(classUnderTest) + TEST_SUFFIX, true);
        }
        if ((val = RubyConventions.validateRubyTypeName((String)classToTestName)).getSeverity() == 4) {
            status.setError(WizardMessages.NewTestCaseWizardPage_error_class_to_test_not_valid);
            return status;
        }
        try {
            IType type = this.resolveClassNameToType(root.getRubyProject(), classToTestName);
            if (type == null) {
                status.setError(WizardMessages.NewTestCaseWizardPage_error_class_to_test_not_exist);
                return status;
            }
            if (type.isModule()) {
                status.setWarning(Messages.format((String)WizardMessages.NewTestCaseWizardPage_warning_class_to_test_is_interface, (Object)classToTestName));
            }
            this.fClassUnderTest = type;
            this.fPage2.setClassUnderTest(this.fClassUnderTest);
        }
        catch (RubyModelException rubyModelException) {
            status.setError(WizardMessages.NewTestCaseWizardPage_error_class_to_test_not_valid);
        }
        return status;
    }

    public IType getClassUnderTest() {
        return this.fClassUnderTest;
    }

    private IType resolveClassNameToType(IRubyProject rproject, String classToTestName) throws RubyModelException {
        if (!rproject.exists()) {
            return null;
        }
        IType type = rproject.findType(classToTestName);
        return type;
    }

    public String getClassUnderTestText() {
        return this.fClassUnderTestText;
    }

    public void init(IStructuredSelection selection) {
        IRubyElement element = this.getInitialRubyElement(selection);
        this.initContainerPage(element);
        this.initTypePage(element);
        if (element != null) {
            IType classToTest = null;
            IType typeInCompUnit = (IType)element.getAncestor(5);
            if (typeInCompUnit != null) {
                if (typeInCompUnit.getRubyScript() != null) {
                    classToTest = typeInCompUnit;
                }
            } else {
                IRubyScript cu = (IRubyScript)element.getAncestor(4);
                if (cu != null) {
                    classToTest = cu.findPrimaryType();
                }
            }
            if (classToTest != null) {
                this.setClassUnderTest(classToTest.getFullyQualifiedName());
            }
        }
        this.restoreWidgetValues();
        this.updateStatus(this.getStatusList());
    }

    protected IStatus[] getStatusList() {
        return new IStatus[]{this.fContainerStatus, this.fTypeNameStatus, this.fClassUnderTestStatus, this.fSuperClassStatus};
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fMethodStubsButtons.setSelection(0, settings.getBoolean(STORE_SETUP));
            this.fMethodStubsButtons.setSelection(1, settings.getBoolean(STORE_TEARDOWN));
            this.fMethodStubsButtons.setSelection(2, settings.getBoolean(STORE_CONSTRUCTOR));
        } else {
            this.fMethodStubsButtons.setSelection(0, false);
            this.fMethodStubsButtons.setSelection(1, false);
            this.fMethodStubsButtons.setSelection(2, false);
        }
    }
}

