/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.commands;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.rubypeople.rdt.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.DebuggerNotFoundException;
import org.rubypeople.rdt.internal.debug.core.commands.AbstractCommand;
import org.rubypeople.rdt.internal.debug.core.parsing.AbstractReadStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.MultiReaderStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.SuspensionReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class AbstractDebuggerConnection {
    private int commandPort;
    private Socket commandSocket;
    private PrintWriter writer;
    private AbstractReadStrategy commandReadStrategy;
    private String host;

    public AbstractDebuggerConnection(int port) {
        this("localhost", port);
    }

    public AbstractDebuggerConnection(String host, int port) {
        this.host = host;
        this.commandPort = port;
    }

    public abstract void connect() throws DebuggerNotFoundException, IOException;

    public abstract SuspensionReader start() throws DebuggerNotFoundException, IOException;

    public abstract boolean isStarted();

    protected AbstractReadStrategy sendCommand(AbstractCommand command) throws DebuggerNotFoundException, IOException {
        if (!this.isCommandPortConnected()) {
            throw new IllegalStateException(command + " could not be sent since command socket is not open");
        }
        RdtDebugCorePlugin.debug("Sending command: " + command.getCommand());
        this.getWriter().println(command.getCommand());
        return this.getCommandReadStrategy();
    }

    public AbstractReadStrategy getCommandReadStrategy() {
        return this.commandReadStrategy;
    }

    protected void createCommandConnection() throws DebuggerNotFoundException, IOException {
        this.getSocket();
        XmlPullParser xpp = AbstractDebuggerConnection.createXpp(this.commandSocket);
        this.commandReadStrategy = new MultiReaderStrategy(xpp);
    }

    public boolean isCommandPortConnected() {
        return this.commandSocket != null;
    }

    protected Socket getSocket() throws IOException, DebuggerNotFoundException {
        if (this.commandSocket == null) {
            this.commandSocket = AbstractDebuggerConnection.acquireSocket(this.host, this.commandPort);
            if (this.commandSocket == null) {
                throw new DebuggerNotFoundException("Could not connect to debugger on port " + this.commandPort);
            }
        }
        return this.commandSocket;
    }

    protected static Socket acquireSocket(String host, int port) throws IOException {
        Socket socket = null;
        int tryCount = 10;
        int i = 0;
        while (i < tryCount) {
            try {
                socket = new Socket(host, port);
                break;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        return socket;
    }

    private PrintWriter getWriter() throws IOException, DebuggerNotFoundException {
        if (this.writer == null) {
            this.writer = new PrintWriter(this.commandSocket.getOutputStream(), true);
        }
        return this.writer;
    }

    protected static XmlPullParser createXpp(Socket socket) {
        XmlPullParser xpp = null;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)"org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer", null);
            xpp = factory.newPullParser();
            xpp.setInput(socket.getInputStream(), "UTF-8");
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xpp;
    }

    public int getCommandPort() {
        return this.commandPort;
    }

    public void exit() throws IOException {
        if (this.commandSocket != null) {
            this.commandSocket.close();
        }
    }
}

