/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.core.railsplugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.core.railsplugins.IRailsPluginListener;
import org.radrails.rails.core.railsplugins.RailsPluginDescriptor;
import org.radrails.rails.core.railsplugins.RailsPluginsContentHandler;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.core.RailsRuntime;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsPluginsManager {
    private static final String SERVICE_URL = "http://agilewebdevelopment.com/plugins/script_list";
    private static final String PLUGINS_FILE = "rails_plugins.xml";
    private static RailsPluginsManager fInstance;
    private List<RailsPluginDescriptor> fPlugins;
    private static Set<IRailsPluginListener> listeners;

    static {
        listeners = new HashSet<IRailsPluginListener>();
    }

    private RailsPluginsManager() {
    }

    public static RailsPluginsManager getInstance() {
        if (fInstance == null) {
            fInstance = new RailsPluginsManager();
        }
        return fInstance;
    }

    public static void addRailsPluginListener(IRailsPluginListener listener) {
        listeners.add(listener);
    }

    public static void removeRailsPluginListener(IRailsPluginListener listener) {
        listeners.remove(listener);
    }

    public List<RailsPluginDescriptor> getPlugins() throws RailsPluginException {
        if (this.fPlugins == null) {
            this.fPlugins = this.loadPlugins();
            if (this.fPlugins.isEmpty()) {
                this.fPlugins = this.updatePlugins((IProgressMonitor)new NullProgressMonitor());
            }
        }
        return this.fPlugins;
    }

    public List<RailsPluginDescriptor> updatePlugins(IProgressMonitor monitor) throws RailsPluginException {
        HttpURLConnection conn;
        List<RailsPluginDescriptor> plugins = new ArrayList<RailsPluginDescriptor>();
        monitor.beginTask("Updating plugin list", 3);
        monitor.subTask("Accessing plugin directory");
        try {
            conn = this.getConnection();
        }
        catch (MalformedURLException e1) {
            throw new RailsPluginException(e1);
        }
        catch (ProtocolException e1) {
            throw new RailsPluginException(e1);
        }
        catch (IOException e1) {
            throw new RailsPluginException(e1);
        }
        monitor.worked(1);
        monitor.subTask("Downloading plugin list");
        String pxml = null;
        try {
            pxml = this.getPluginXMLFeed(monitor, conn);
        }
        catch (IOException e) {
            monitor.subTask("Error downloading plugin list.  See log for details.");
            RailsLog.log(e);
            monitor.done();
            return plugins;
        }
        monitor.worked(1);
        monitor.subTask("Processing plugin information");
        StringReader strIn = new StringReader(pxml);
        try {
            plugins = this.parsePluginsXML(strIn);
        }
        catch (SAXException e) {
            throw new RailsPluginException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RailsPluginException(e);
        }
        catch (IOException e) {
            throw new RailsPluginException(e);
        }
        this.writeOutPluginsXML(pxml);
        monitor.worked(1);
        for (IRailsPluginListener listener : listeners) {
            listener.remotePluginsRefreshed();
        }
        monitor.done();
        return plugins;
    }

    private HttpURLConnection getConnection() throws MalformedURLException, IOException, ProtocolException {
        URL url = new URL(SERVICE_URL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        return conn;
    }

    private String getPluginXMLFeed(IProgressMonitor monitor, HttpURLConnection conn) throws IOException {
        BufferedReader bufIn = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer pxml = new StringBuffer();
        String l = null;
        while ((l = bufIn.readLine()) != null) {
            pxml.append(l);
        }
        return pxml.toString();
    }

    private void writeOutPluginsXML(String pxml) {
        PrintWriter out = null;
        try {
            try {
                File f = new File(this.getLocalPluginXMLCache().toOSString());
                out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                out.write(pxml);
                out.flush();
            }
            catch (IllegalStateException e) {
                RailsLog.log(e);
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                RailsLog.log(e);
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private List<RailsPluginDescriptor> loadPlugins() {
        File f = new File(this.getLocalPluginXMLCache().toOSString());
        if (f.exists()) {
            try {
                FileReader fis = new FileReader(f);
                return this.parsePluginsXML(fis);
            }
            catch (SAXException e) {
                RailsLog.logError("Error parsing Rails plugins XML", e);
            }
            catch (ParserConfigurationException e) {
                RailsLog.logError("Error parsing Rails plugins XML: parser misconfigured.", e);
            }
            catch (IOException e) {
                RailsLog.logError("Error parsing Rails plugins XML: I/O problems.", e);
            }
        }
        return new ArrayList<RailsPluginDescriptor>();
    }

    private IPath getLocalPluginXMLCache() {
        return RailsPlugin.getInstance().getStateLocation().append(PLUGINS_FILE);
    }

    private List<RailsPluginDescriptor> parsePluginsXML(Reader rdr) throws SAXException, ParserConfigurationException, IOException {
        XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        RailsPluginsContentHandler handler = new RailsPluginsContentHandler();
        reader.setContentHandler(handler);
        reader.parse(new InputSource(rdr));
        return handler.getRailsPlugins();
    }

    public static void installPlugin(IProject project, RailsPluginDescriptor plugin, boolean externals, boolean checkout) {
        String repos = plugin.getRepository();
        if (repos == null || repos.trim().length() == 0) {
            RailsLog.log("Plugin has no repository: " + plugin.toString());
            repos = plugin.getName();
        }
        String command = "install ";
        if (externals || checkout) {
            String ext_str = externals ? "x" : "";
            String check_str = checkout ? "o" : "";
            command = String.valueOf(command) + "-" + ext_str + check_str + " " + repos;
        } else {
            command = String.valueOf(command) + repos;
        }
        RailsPluginsManager.run(project, command);
        for (IRailsPluginListener listener : listeners) {
            listener.pluginInstalled(project, plugin);
        }
    }

    public static ILaunch run(IProject project, String args) {
        try {
            ILaunchConfigurationWorkingCopy wc = RailsPluginsManager.makeWorkingCopy(RailsPluginsManager.getPluginScript(), args, project);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_TERMINAL_COMMAND, "script/plugin " + args);
            ILaunchConfiguration config = wc.doSave();
            return config.launch("run", null);
        }
        catch (CoreException e) {
            RailsLog.logError("Error running rake task", e);
            return null;
        }
    }

    private static String getPluginScript() {
        return new Path("script").append("plugin").toPortableString();
    }

    public static void removePlugin(IProject project, RailsPluginDescriptor plugin) {
        String name = plugin.getProperty("name");
        if (name.indexOf(32) > -1) {
            System.out.println("WTF!");
        }
        RailsPluginsManager.run(project, "remove " + name);
        for (IRailsPluginListener listener : listeners) {
            listener.pluginRemoved(project, plugin);
        }
    }

    private static ILaunchConfigurationWorkingCopy makeWorkingCopy(String file, String args, IProject project) throws CoreException {
        String workingDirectory = "";
        IPath path = RailsPlugin.findRailsRoot(project);
        workingDirectory = path.toPortableString().length() != 0 ? project.getFolder(path).getLocation().toOSString() : project.getLocation().toOSString();
        return RailsRuntime.createInternalLaunch(file, args, project, workingDirectory);
    }

    public static List<RailsPluginDescriptor> getInstalledPlugins(IProject project) {
        ArrayList<RailsPluginDescriptor> plugins = new ArrayList<RailsPluginDescriptor>();
        if (project == null) {
            return plugins;
        }
        IPath railsRoot = RailsPlugin.findRailsRoot(project);
        IPath pluginsDir = railsRoot.append("vendor").append("plugins");
        IFolder pluginsFolder = project.getFolder(pluginsDir);
        try {
            IResource[] members = pluginsFolder.members();
            int i = 0;
            while (i < members.length) {
                IResource member = members[i];
                if (member.getType() == 2) {
                    RailsPluginDescriptor desc = new RailsPluginDescriptor();
                    desc.setProperty("name", member.getName());
                    plugins.add(desc);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            RailsLog.log(e);
        }
        return plugins;
    }

    public static boolean pluginInstalled(RailsPluginDescriptor plugin, IProject project) {
        List<RailsPluginDescriptor> plugins = RailsPluginsManager.getInstalledPlugins(project);
        for (RailsPluginDescriptor descriptor : plugins) {
            if (!RailsPluginsManager.normalize(descriptor.getName()).equalsIgnoreCase(plugin.getName())) continue;
            return true;
        }
        return false;
    }

    private static String normalize(String string) {
        return string.replace('_', ' ');
    }

    public class RailsPluginException
    extends Exception {
        public RailsPluginException(Exception e) {
            super(e);
        }
    }
}

