/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.SymbolNode;
import org.radrails.rails.core.Inflector;
import org.radrails.rails.core.RailsLog;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.codeassist.CodeResolver;
import org.rubypeople.rdt.core.codeassist.ResolveContext;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.ti.util.FirstPrecursorNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;

public class RailsCodeResolver
extends CodeResolver {
    private static final String HAS_AND_BELONGS_TO_MANY = "has_and_belongs_to_many";
    private static final String HAS_ONE = "has_one";
    private static final String HAS_MANY = "has_many";
    private static final String BELONGS_TO = "belongs_to";

    public void select(ResolveContext context) throws RubyModelException {
        if (this.tryResolvingAssociation(context)) {
            return;
        }
        this.narrowResolvedForMigrations(context);
    }

    private void narrowResolvedForMigrations(ResolveContext context) throws RubyModelException {
        IRubyElement[] resolved = context.getResolved();
        if (resolved == null || resolved.length <= 1) {
            return;
        }
        IType primary = context.getScript().findPrimaryType();
        if (primary == null) {
            return;
        }
        String superclass = primary.getSuperclassName();
        if (!superclass.equals("ActiveRecord::Migration")) {
            return;
        }
        String name = resolved[0].getElementName();
        if (!name.equals("create_table")) {
            return;
        }
        int i = 0;
        while (i < resolved.length) {
            String typeName = ((IMethod)resolved[i]).getDeclaringType().getFullyQualifiedName();
            if (typeName.equals("ActiveRecord::ConnectionAdapters::SchemaStatements")) {
                context.putResolved(new IRubyElement[]{resolved[i]});
                return;
            }
            ++i;
        }
    }

    private boolean tryResolvingAssociation(ResolveContext context) throws RubyModelException {
        String modelName;
        Node selected = context.getSelectedNode();
        if (!(selected instanceof SymbolNode)) {
            return false;
        }
        SymbolNode sym = (SymbolNode)selected;
        String symbolName = sym.getName();
        Node methodCall = FirstPrecursorNodeLocator.Instance().findFirstPrecursor((Node)context.getAST(), selected.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof FCallNode;
            }
        });
        if (methodCall == null) {
            return false;
        }
        FCallNode fCall = (FCallNode)methodCall;
        String methodName = fCall.getName();
        if (methodName.equals(HAS_MANY) || methodName.equals(HAS_AND_BELONGS_TO_MANY)) {
            modelName = Inflector.singularize(symbolName);
            modelName = Util.underscoresToCamelCase((String)modelName);
        } else if (methodName.equals(BELONGS_TO) || methodName.equals(HAS_ONE)) {
            modelName = Util.underscoresToCamelCase((String)symbolName);
        } else {
            return false;
        }
        try {
            SearchEngine engine = new SearchEngine();
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            CollectingSearchRequestor requestor = new CollectingSearchRequestor();
            SearchPattern pattern = SearchPattern.createPattern((int)5, (String)modelName, (int)0, (int)0);
            IRubySearchScope scope = SearchEngine.createRubySearchScope((IRubyElement[])new IRubyElement[]{context.getScript().getRubyProject()});
            engine.search(pattern, participants, scope, (SearchRequestor)requestor, null);
            List matches = requestor.getResults();
            Iterator iterator = matches.iterator();
            if (iterator.hasNext()) {
                SearchMatch searchMatch = (SearchMatch)iterator.next();
                IRubyElement element = (IRubyElement)searchMatch.getElement();
                context.putResolved(new IRubyElement[]{element});
                return true;
            }
        }
        catch (CoreException e) {
            RailsLog.log(e);
        }
        return false;
    }
}

