/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.core;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.IGemManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;
import org.osgi.util.tracker.ServiceTracker;
import org.radrails.rails.core.RailsLog;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.radrails.rails.core";
    public HashSet<String> optionNames = new HashSet(20);
    public Hashtable<String, String> optionsCache;
    public final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    static final int PREF_INSTANCE = 0;
    static final int PREF_DEFAULT = 1;
    private static final String WACKY_DEBIAN_RAILS_PATH = "/usr/share/rails/railties/bin/rails";
    private static final String RAILS = "rails";
    public static final String RAILS_DEPRECATION_INSTANCE_VARIABLES = "org.radrails.rails.core.compiler.problem.railsInstanceVariable";
    public static final String RAILS_DEPRECATION_RENDER_CALLS = "org.radrails.rails.core.compiler.problem.railsDeprecationRenderCalls";
    public static final String RAILS_DEPRECATION_REDIRECT_CALLS = "org.radrails.rails.core.compiler.problem.railsDeprecationRedirectCalls";
    public static final String RAILS_DEPRECATION_POST_FORMAT = "org.radrails.rails.core.compiler.problem.railsDeprecationPostFormat";
    public static final String RAILS_DEPRECATION_START_END_FORM_TAG = "org.radrails.rails.core.compiler.problem.railsDeprecationStartEndFormTag";
    public static final String RAILS_DEPRECATION_UPDATE_ELEMENT_FUNCTION = "org.radrails.rails.core.compiler.problem.railsDeprecationUpdateElementFunction";
    public static final String RAILS_DEPRECATION_IMAGE_LINK_METHODS = "org.radrails.rails.core.compiler.problem.railsDeprecationImageLinkMethods";
    public static final String RAILS_DEPRECATION_HUMAN_SIZE_HELPER_ALIAS = "org.radrails.rails.core.compiler.problem.railsDeprecationHumanSizeHelperAlias";
    public static final String RAILS_DEPRECATION_ACTIVE_RECORD_FIND_METHODS = "org.radrails.rails.core.compiler.problem.railsDeprecationActiveRecordFindMethods";
    public static final String RAILS_DEPRECATION_PUSH_WITH_ATTRIBUTES = "org.radrails.rails.core.compiler.problem.railsDeprecationPushWithAttributes";
    private static RailsPlugin instance;
    private static Map<IProject, String> fgRailsVersions;
    private static Map<IProject, Long> fgFileModifications;
    private ServiceTracker gemManagerTracker;

    static {
        fgRailsVersions = new HashMap<IProject, String>();
        fgFileModifications = new HashMap<IProject, Long>();
    }

    public RailsPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.gemManagerTracker = new ServiceTracker(context, IGemManager.class.getName(), null);
        this.gemManagerTracker.open();
        this.initializePreferences();
    }

    public static boolean hasRailsNature(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            return project.hasNature("org.radrails.rails.core.railsnature");
        }
        catch (CoreException e) {
            RailsLog.log(e);
            return false;
        }
    }

    public static void addRailsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        RubyCore.addRubyNature((IProject)project, (IProgressMonitor)monitor);
        if (!project.hasNature("org.radrails.rails.core.railsnature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.radrails.rails.core.railsnature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    public static IPath findRailsRoot(IProject project) {
        return RailsRootFinder.findRailsRoot(project);
    }

    public static String getRailsVersion(IProject project) {
        IPath railsRoot = RailsPlugin.findRailsRoot(project);
        railsRoot = railsRoot == null || railsRoot.segmentCount() == 0 ? project.getLocation() : project.getLocation().append(railsRoot);
        File file = railsRoot.append("config").append("environment.rb").toFile();
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        Long lastModification = fgFileModifications.get(project);
        if (lastModification == null) {
            lastModification = Long.MIN_VALUE;
        }
        if (file.lastModified() > lastModification) {
            String version = RailsPlugin.getRailsVersion(file);
            fgRailsVersions.put(project, version);
            fgFileModifications.put(project, file.lastModified());
        }
        return fgRailsVersions.get(project);
    }

    private static String getRailsVersion(File file) {
        int end;
        String content;
        block7: {
            int index;
            block6: {
                try {
                    content = new String(Util.getFileCharContent((File)file, null));
                    index = content.indexOf("RAILS_GEM_VERSION = ");
                    if (index != -1) break block6;
                    return null;
                }
                catch (IOException e) {
                    RailsLog.log(e);
                    return null;
                }
            }
            content = content.substring(index + 20);
            content = content.trim();
            if (content.startsWith("'") || content.startsWith("\"")) {
                content = content.substring(1);
            }
            if ((end = content.indexOf("'")) == -1) {
                end = content.indexOf("\"");
            }
            if (end != -1) break block7;
            return null;
        }
        return content.substring(0, end);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.gemManagerTracker.close();
            this.savePluginPreferences();
        }
        finally {
            super.stop(context);
        }
    }

    public static RailsPlugin getInstance() {
        return instance;
    }

    public String getRubyScriptPath(String rubyFile) {
        String directoryFile = String.valueOf(this.getStateLocation().toOSString()) + File.separator + rubyFile;
        File pluginDirFile = new File(directoryFile);
        if (!pluginDirFile.exists()) {
            try {
                String line;
                pluginDirFile.createNewFile();
                URL u = this.getBundle().getEntry("/ruby/" + rubyFile);
                BufferedReader input = new BufferedReader(new InputStreamReader(u.openStream()));
                FileWriter output = new FileWriter(pluginDirFile);
                while ((line = input.readLine()) != null) {
                    output.write(line);
                    output.write(10);
                }
                output.flush();
                output.close();
                input.close();
            }
            catch (IOException e) {
                RailsLog.logError("Error writing plugin script to metadata", e);
            }
        }
        String path = "";
        try {
            path = pluginDirFile.getCanonicalPath();
        }
        catch (IOException e) {
            RailsLog.logError("Error getting file path", e);
        }
        return path;
    }

    public String getRailsPath() {
        String path = this.getSavedPath("rails.core.path.rails");
        if (path != null && path.trim().length() > 0) {
            return path;
        }
        return this.buildBinExecutablePath(RAILS, RAILS);
    }

    public String getMongrelPath() {
        String path = this.getSavedPath("rails.core.path.mongrel");
        if (path != null && path.trim().length() > 0) {
            return path;
        }
        return this.buildBinExecutablePath("mongrel_rails", "mongrel");
    }

    private String getSavedPath(String prefKey) {
        String path = this.getPluginPreferences().getString(prefKey);
        if (path == null || path.trim().length() > 0) {
            return null;
        }
        if (path.endsWith(".bat") || path.endsWith(".cmd")) {
            return path.substring(0, path.length() - 4);
        }
        return path;
    }

    public File findBinScript(String binScriptName, String relatedGemName) {
        String result = this.buildBinExecutablePath(binScriptName, relatedGemName);
        if (result != null) {
            return new File(result);
        }
        return null;
    }

    private String buildBinExecutablePath(String command, String gemName) {
        IPath path = RubyRuntime.checkInterpreterBin((String)command);
        if (path != null && path.toFile().exists()) {
            Path debianPath;
            if (command.equals(RAILS) && (debianPath = new Path(WACKY_DEBIAN_RAILS_PATH)).toFile().exists()) {
                return debianPath.toOSString();
            }
            return path.toOSString();
        }
        path = AptanaRDTPlugin.checkBinDir((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        if (gemName != null && (path = AptanaRDTPlugin.checkGemBinDir((String)gemName, (String)command)) != null && path.toFile().exists()) {
            return path.toOSString();
        }
        path = RubyCore.checkSystemPath((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        return null;
    }

    public static Set<IProject> getRailsProjects() {
        HashSet<IProject> projectSet = new HashSet<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            try {
                if (project.hasNature("org.radrails.rails.core.railsnature")) {
                    projectSet.add(project);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return projectSet;
    }

    public IGemManager getGemManager() {
        return (IGemManager)this.gemManagerTracker.getService();
    }

    private void initializePreferences() {
        this.preferencesLookup[0] = new InstanceScope().getNode(PLUGIN_ID);
        this.preferencesLookup[1] = new DefaultScope().getNode(PLUGIN_ID);
        Object listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == RailsPlugin.this.preferencesLookup[0]) {
                    RailsPlugin.this.preferencesLookup[0] = new InstanceScope().getNode(RailsPlugin.PLUGIN_ID);
                    RailsPlugin.this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new RubyModelManager.EclipsePreferencesListener());
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener(listener);
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new RubyModelManager.EclipsePreferencesListener());
        listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == RailsPlugin.this.preferencesLookup[1]) {
                    RailsPlugin.this.preferencesLookup[1] = new DefaultScope().getNode(RailsPlugin.PLUGIN_ID);
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener(listener);
    }

    public Hashtable<String, String> getOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        IPreferencesService service = Platform.getPreferencesService();
        for (String propertyName : this.optionNames) {
            String propertyValue = service.get(propertyName, null, (Preferences[])this.preferencesLookup);
            if (propertyValue == null) continue;
            options.put(propertyName, propertyValue);
        }
        this.optionsCache = new Hashtable(options);
        return options;
    }

    public static List<String> getEligibleDatabaseNamesforCurrentVM() {
        ArrayList<String> dbNames = new ArrayList<String>();
        dbNames.add("db2");
        if (RubyRuntime.currentVMIsJRuby()) {
            dbNames.add("derby");
        } else {
            dbNames.add("sqlite3");
            dbNames.add("sqlite2");
        }
        dbNames.add("mysql");
        dbNames.add("oracle");
        dbNames.add("postgresql");
        dbNames.add("sqlserver");
        return dbNames;
    }

    private static class RailsRootFinder
    implements IResourceVisitor {
        private IPath path;

        private RailsRootFinder() {
        }

        public static IPath findRailsRoot(IProject project) {
            if (RailsRootFinder.looksLikeRailsRoot((IContainer)project)) {
                return project.getProjectRelativePath();
            }
            try {
                RailsRootFinder finder = new RailsRootFinder();
                project.accept((IResourceVisitor)finder);
                if (finder.getRailsRoot() != null) {
                    return finder.getRailsRoot();
                }
            }
            catch (CoreException coreException) {}
            return project.getProjectRelativePath();
        }

        public boolean visit(IResource resource) throws CoreException {
            IFolder folder;
            if (resource.getType() == 1) {
                return false;
            }
            if (resource.getType() == 2 && RailsRootFinder.looksLikeRailsRoot((IContainer)(folder = (IFolder)resource))) {
                this.path = folder.getProjectRelativePath();
                return false;
            }
            return true;
        }

        private static boolean looksLikeRailsRoot(IContainer folder) {
            if (folder == null) {
                return false;
            }
            return RailsRootFinder.folderExists(folder, new String[]{"app", "config", "public", "db"});
        }

        public IPath getRailsRoot() {
            return this.path;
        }

        private static boolean folderExists(IContainer folder, String[] strings) {
            int i = 0;
            while (i < strings.length) {
                if (!RailsRootFinder.folderExists(folder, strings[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean folderExists(IContainer folder, String name) {
            IFolder test = folder.getFolder((IPath)new Path(name));
            return test.exists();
        }
    }
}

