/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.generators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Generator
implements Comparable {
    private String name;
    private String location;

    public Generator(String name, String location) {
        this.location = location;
        this.name = name;
    }

    public Generator(String location) {
        this(Generator.parseName(location), location);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    private static String parseName(String location) {
        String patternStr = ".*/(\\w+)_generator.rb\\Z";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(location);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    public int compareTo(Object arg0) {
        Generator g = (Generator)arg0;
        return this.name.compareTo(g.getName());
    }
}

