/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.generators;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.generators.Generator;
import org.radrails.rails.internal.generators.GeneratorsLocator;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsGemGeneratorLocator
extends GeneratorsLocator {
    public RailsGemGeneratorLocator(IProject project) {
        super(project);
    }

    @Override
    public void locateGenerators() {
        this.generators.clear();
        try {
            IPath railsPath = this.findRailsPath();
            if (railsPath == null) {
                this.addDefaultGenerators();
                return;
            }
            List<File> generatorFiles = this.getGeneratorFiles(railsPath);
            if (generatorFiles == null || generatorFiles.isEmpty()) {
                this.addDefaultGenerators();
                return;
            }
            for (File file : generatorFiles) {
                this.generators.add(new Generator("/" + file.getName()));
            }
        }
        catch (RubyModelException e) {
            RailsLog.log((CoreException)((Object)e));
            this.addDefaultGenerators();
        }
    }

    private List<File> getGeneratorFiles(IPath railsPath) {
        ArrayList<File> files = new ArrayList<File>();
        File folder = railsPath.append("rails_generator").append("generators").append("components").toFile();
        if (folder == null) {
            return files;
        }
        File[] generatorFolders = folder.listFiles();
        if (generatorFolders == null) {
            return files;
        }
        int j = 0;
        while (j < generatorFolders.length) {
            File[] actuals = generatorFolders[j].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith("_generator.rb");
                }
            });
            if (actuals != null) {
                int x = 0;
                while (x < actuals.length) {
                    files.add(actuals[x]);
                    ++x;
                }
            }
            ++j;
        }
        return files;
    }

    private IPath findRailsPath() throws RubyModelException {
        ILoadpathEntry[] entries = this.getRubyProject().getResolvedLoadpath(true);
        int i = 0;
        while (i < entries.length) {
            IPath path;
            if (entries[i].getEntryKind() == 1 && (path = entries[i].getPath()).toPortableString().indexOf("rails-") > 0) {
                return path;
            }
            ++i;
        }
        return null;
    }

    private IRubyProject getRubyProject() {
        return RubyCore.create((IProject)this.getProject());
    }

    private void addDefaultGenerators() {
        HashMap<String, String> builtinGenerators = new HashMap<String, String>();
        builtinGenerators.put("/controller_generator.rb", "ControllerName [action, ...]");
        builtinGenerators.put("/integration_test_generator.rb", "IntegrationTestName");
        builtinGenerators.put("/mailer_generator.rb", "MailerName [view, ...]");
        builtinGenerators.put("/migration_generator.rb", "MigrationName");
        builtinGenerators.put("/model_generator.rb", "ModelName");
        builtinGenerators.put("/observer_generator.rb", "ObserverName");
        builtinGenerators.put("/plugin_generator.rb", "PluginName");
        builtinGenerators.put("/resource_generator.rb", "ModelName [field:type, field:type]");
        builtinGenerators.put("/scaffold_generator.rb", "ModelName [ControllerName] [action, ...]");
        builtinGenerators.put("/session_migration_generator.rb", "SessionMigrationName");
        Iterator keysIt = builtinGenerators.keySet().iterator();
        while (keysIt.hasNext()) {
            this.generators.add(new Generator(keysIt.next().toString()));
        }
    }
}

