/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.generators;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.generators.Generator;
import org.radrails.rails.internal.generators.GeneratorsLocator;

public class VendorGeneratorsLocator
extends GeneratorsLocator
implements IResourceChangeListener {
    private static final String GENERATORS_DIRECTORY = "generators";

    public VendorGeneratorsLocator(IProject project) {
        super(project);
    }

    public void locateGenerators() {
        String[] generatorLocations = new String[]{"lib", "vendor"};
        this.generators.clear();
        int i = 0;
        while (i < generatorLocations.length) {
            IFolder folder = this.getRailsRoot().getFolder(new Path(generatorLocations[i]).append(GENERATORS_DIRECTORY));
            this.populateGeneratorsAtPath(folder);
            ++i;
        }
        this.populateGeneratorsFromPlugins(this.getRailsRoot().getFolder(new Path("vendor").append("plugins")));
    }

    private IContainer getRailsRoot() {
        IPath root = RailsPlugin.findRailsRoot(this.getProject());
        if (root == null || root.segmentCount() == 0) {
            return this.getProject();
        }
        return this.getProject().getFolder(root);
    }

    private void populateGeneratorsFromPlugins(IFolder pluginsDir) {
        if (pluginsDir == null) {
            return;
        }
        if (!pluginsDir.exists()) {
            return;
        }
        try {
            IResource[] members = pluginsDir.members();
            int i = 0;
            while (i < members.length) {
                IResource plugin = members[i];
                if (plugin.getType() == 2) {
                    IFolder generatorsFolder = ((IFolder)plugin).getFolder(GENERATORS_DIRECTORY);
                    this.populateGeneratorsAtPath(generatorsFolder);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            RailsLog.logError("Could not fetch members of " + pluginsDir.getName(), e);
        }
    }

    private void populateGeneratorsAtPath(IFolder folder) {
        if (folder == null) {
            return;
        }
        if (!folder.exists()) {
            return;
        }
        if (!folder.getName().equals(GENERATORS_DIRECTORY)) {
            return;
        }
        try {
            IResource[] genFolderMembers = folder.members();
            int i = 0;
            while (i < genFolderMembers.length) {
                IFolder generatorFolder;
                IFile generatorFile;
                if (genFolderMembers[i].getType() == 2 && (generatorFile = (generatorFolder = (IFolder)genFolderMembers[i]).getFile(String.valueOf(generatorFolder.getName()) + "_generator.rb")).exists()) {
                    this.generators.add(new Generator(generatorFile.getLocation().toPortableString()));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            RailsLog.logError("Could not fetch members of " + folder.getName(), e);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        RailsLog.logInfo("resource changed " + event.getDelta().getFullPath().toString(), null);
    }
}

