/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;

public class CodeReloadJob
extends Job {
    private String filename;
    private IRubyDebugTarget debugTarget;

    public CodeReloadJob(IRubyDebugTarget debugTarget, String filename) {
        super("Loading " + filename);
        this.filename = filename;
        this.debugTarget = debugTarget;
    }

    public IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        final IStatus status = this.debugTarget.load(this.filename);
        if (status == null) {
            return new Status(2, RdtDebugCorePlugin.getPluginIdentifier(), -1, "Did not receive a status from the code reload operation for " + this.filename, null);
        }
        if (!status.isOK()) {
            DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)DebugUIPlugin.getStandardDisplay().getActiveShell(), (String)("Error loading " + CodeReloadJob.this.filename), (String)status.getMessage());
                }
            });
        }
        return status;
    }
}

