/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.debug.core.model.IRubyStackFrame;
import org.rubypeople.rdt.debug.core.model.IRubyThread;
import org.rubypeople.rdt.debug.ui.IEvaluationContextManager;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationContextManager
implements IDebugContextListener,
IWindowListener,
IEvaluationContextManager {
    private static EvaluationContextManager fgManager;
    private static final String DEBUGGER_ACTIVE;
    private static final String INSTANCE_OF_IRUBY_STACK_FRAME;
    private Map<IWorkbenchPage, IRubyStackFrame> fContextsByPage = null;
    private IWorkbenchWindow fActiveWindow;

    static {
        DEBUGGER_ACTIVE = String.valueOf(RdtDebugUiPlugin.getUniqueIdentifier()) + ".debuggerActive";
        INSTANCE_OF_IRUBY_STACK_FRAME = String.valueOf(RdtDebugUiPlugin.getUniqueIdentifier()) + ".instanceof.RubyStackFrame";
    }

    public EvaluationContextManager() {
        DebugContextManager.getDefault().addDebugContextListener((IDebugContextListener)this);
        fgManager = this;
    }

    @Override
    public IRubyStackFrame getEvaluationContext(IWorkbenchPart part) {
        IWorkbenchPage page = part.getSite().getPage();
        IRubyStackFrame frame = EvaluationContextManager.getContext(page);
        if (frame == null) {
            return this.getEvaluationContext(page.getWorkbenchWindow());
        }
        return frame;
    }

    @Override
    public IRubyStackFrame getEvaluationContext(IWorkbenchWindow window) {
        ArrayList<IWorkbenchWindow> alreadyVisited = new ArrayList<IWorkbenchWindow>();
        if (window == null) {
            window = EvaluationContextManager.fgManager.fActiveWindow;
        }
        return EvaluationContextManager.getEvaluationContext(window, alreadyVisited);
    }

    private static IRubyStackFrame getEvaluationContext(IWorkbenchWindow window, List<IWorkbenchWindow> alreadyVisited) {
        IWorkbenchPage activePage = window.getActivePage();
        IRubyStackFrame frame = null;
        if (activePage != null) {
            frame = EvaluationContextManager.getContext(activePage);
        }
        if (frame == null) {
            IWorkbenchPage[] pages = window.getPages();
            int i = 0;
            while (i < pages.length) {
                if (activePage != pages[i] && (frame = EvaluationContextManager.getContext(pages[i])) != null) {
                    return frame;
                }
                ++i;
            }
            alreadyVisited.add(window);
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i2 = 0;
            while (i2 < windows.length) {
                if (!alreadyVisited.contains(windows[i2]) && (frame = EvaluationContextManager.getEvaluationContext(windows[i2], alreadyVisited)) != null) {
                    return frame;
                }
                ++i2;
            }
            return null;
        }
        return frame;
    }

    private static IRubyStackFrame getContext(IWorkbenchPage page) {
        if (fgManager != null && EvaluationContextManager.fgManager.fContextsByPage != null) {
            return EvaluationContextManager.fgManager.fContextsByPage.get(page);
        }
        return null;
    }

    public void contextActivated(ISelection selection, IWorkbenchPart part) {
        if (part != null) {
            Object element;
            IStructuredSelection ss;
            IWorkbenchPage page = part.getSite().getPage();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
                boolean instOf;
                IRubyStackFrame frame = (IRubyStackFrame)((IAdaptable)element).getAdapter(IRubyStackFrame.class);
                boolean bl = instOf = element instanceof IRubyStackFrame || element instanceof IRubyThread;
                if (frame != null) {
                    this.setContext(page, frame, instOf);
                    return;
                }
            }
            this.removeContext(page);
        }
    }

    public void contextChanged(ISelection selection, IWorkbenchPart part) {
    }

    private void setContext(IWorkbenchPage page, IRubyStackFrame frame, boolean instOf) {
        if (this.fContextsByPage == null) {
            this.fContextsByPage = new HashMap<IWorkbenchPage, IRubyStackFrame>();
        }
        this.fContextsByPage.put(page, frame);
        System.setProperty(DEBUGGER_ACTIVE, "true");
        if (instOf) {
            System.setProperty(INSTANCE_OF_IRUBY_STACK_FRAME, "true");
        } else {
            System.setProperty(INSTANCE_OF_IRUBY_STACK_FRAME, "false");
        }
    }

    private void removeContext(IWorkbenchPage page) {
        if (this.fContextsByPage != null) {
            this.fContextsByPage.remove(page);
            if (this.fContextsByPage.isEmpty()) {
                System.setProperty(DEBUGGER_ACTIVE, "false");
                System.setProperty(INSTANCE_OF_IRUBY_STACK_FRAME, "false");
            }
        }
    }

    @Override
    public void startup() {
        Runnable r = new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    fgManager.windowOpened(windows[i]);
                    ++i;
                }
                workbench.addWindowListener((IWindowListener)fgManager);
                fgManager.fActiveWindow = workbench.getActiveWorkbenchWindow();
            }
        };
        RdtDebugUiPlugin.getStandardDisplay().asyncExec(r);
    }

    public static IEvaluationContextManager instance() {
        if (fgManager == null) {
            fgManager = new EvaluationContextManager();
        }
        return fgManager;
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.fActiveWindow = window;
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext(), event.getDebugContextProvider().getPart());
        }
    }
}

