/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.ContributedGemRegistry;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.IGemManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallGemsJob
extends UIJob {
    Collection<Gem> finalGems;

    public InstallGemsJob(Collection<Gem> finalGems) {
        super("Installing the selected gems");
        this.finalGems = finalGems;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (!this.getGemManager().isRubyGemsInstalled()) {
            String key;
            IPreferenceStore store = RdtDebugUiPlugin.getDefault().getPreferenceStore();
            if (!store.getString(key = "rubygems_not_installed_dialog").equals("always")) {
                MessageDialogWithToggle.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"RubyGems Not Installed", (String)"You do not appear to have RubyGems installed. It is highly recommended that you install this, as it is the standard way of installing and managing ruby libraries. Please see http://rubygems.org/read/chapter/3.", (String)"Don't bug me again", (boolean)false, (IPreferenceStore)store, (String)key);
            }
            return Status.OK_STATUS;
        }
        try {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            progressDialog.run(true, true, (IRunnableWithProgress)new InstallGemsRunnableWithProgress(this.finalGems));
        }
        catch (InvocationTargetException e) {
            AptanaRDTPlugin.log((Throwable)e);
        }
        catch (InterruptedException e) {
            AptanaRDTPlugin.log((Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected IGemManager getGemManager() {
        return AptanaRDTPlugin.getDefault().getGemManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InstallGemsRunnableWithProgress
    implements IRunnableWithProgress {
        private Collection<Gem> finalGems;

        public InstallGemsRunnableWithProgress(Collection<Gem> finalGems) {
            this.finalGems = finalGems;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Auto-installing gems...", 100);
            monitor.subTask("Sorting by dependencies");
            List sorted = ContributedGemRegistry.sortByDependency(this.finalGems);
            monitor.worked(10);
            if (monitor.isCanceled()) {
                return;
            }
            if (!sorted.isEmpty()) {
                int step = 90 / sorted.size();
                for (Gem gem : sorted) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.subTask("Installing " + gem.getName());
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, step - 1);
                    InstallGemsJob.this.getGemManager().installGem(gem, (IProgressMonitor)subMonitor);
                    subMonitor.done();
                    if (gem.isLocal()) {
                        gem.delete();
                    }
                    monitor.worked(1);
                }
            }
            monitor.done();
        }
    }
}

