/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.ContributedGemRegistry;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.Version;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.debug.ui.InstallDeveloperToolsDialog;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.launcher.InstallGemsJob;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RubyApplicationShortcut
implements ILaunchShortcut {
    private static final String RUBY_PROFILING_GEM_NAME = "ruby-prof";
    private static final String RUBY_DEBUG_IDE_GEM_NAME = "ruby-debug-ide";
    private static final String MINIMUM_RUBY_DEBUG_IDE_VERSION = "0.4.5";

    public void launch(ISelection selection, String mode) {
        Object firstSelection = null;
        if (selection instanceof IStructuredSelection) {
            firstSelection = ((IStructuredSelection)selection).getFirstElement();
        }
        if (firstSelection == null) {
            this.log("Could not find selection.");
            return;
        }
        IRubyElement rubyElement = null;
        if (firstSelection instanceof IAdaptable) {
            rubyElement = (IRubyElement)((IAdaptable)firstSelection).getAdapter(IRubyElement.class);
        }
        if (rubyElement == null) {
            this.log("Selection is not a ruby element.");
            return;
        }
        this.doLaunchWithErrorHandling(rubyElement, mode);
    }

    private void doLaunchWithErrorHandling(IRubyElement rubyElement, String mode) {
        block3: {
            if (RubyApplicationShortcut.shouldInstallGemsFirst(mode)) {
                return;
            }
            try {
                this.doLaunch(rubyElement, mode);
            }
            catch (CoreException e) {
                this.log(e);
                IStatus status = e.getStatus();
                String title = RdtDebugUiMessages.Dialog_launchErrorTitle;
                String message = RdtDebugUiMessages.Dialog_launchErrorMessage;
                if (status == null) break block3;
                ErrorDialog.openError((Shell)RdtDebugUiPlugin.getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (IStatus)status);
            }
        }
    }

    private static boolean shouldInstallGemsFirst(String mode) {
        if (mode.equals("run")) {
            return false;
        }
        if (mode.equals("debug")) {
            if (!AptanaRDTPlugin.getDefault().getGemManager().gemInstalled(RUBY_DEBUG_IDE_GEM_NAME)) {
                RubyApplicationShortcut.installNecessaryDebuggingGems();
                return true;
            }
            if (RubyApplicationShortcut.updatingRubyDebugIDEGem()) {
                return true;
            }
        } else if (mode.equals("profile")) {
            if (RubyRuntime.currentVMIsJRuby()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Profiling not yet supported on JRuby", (String)"Profiling is not yet available for the JRuby interpreter. We rely on the ruby-prof gem, which requires native code, and there is not yet a Java based version of the gem.");
                return true;
            }
            if (!AptanaRDTPlugin.getDefault().getGemManager().gemInstalled(RUBY_PROFILING_GEM_NAME)) {
                RubyApplicationShortcut.installNecessaryProfilingGems();
                return true;
            }
        }
        return false;
    }

    private static boolean updatingRubyDebugIDEGem() {
        List versions = AptanaRDTPlugin.getDefault().getGemManager().getVersions(RUBY_DEBUG_IDE_GEM_NAME);
        for (Version version : versions) {
            if (!version.isGreaterThanOrEqualTo(MINIMUM_RUBY_DEBUG_IDE_VERSION)) continue;
            return false;
        }
        if (!MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"ruby-debug-ide out of date", (String)"To debug, it is required that you use the ruby-debug-ide gem, with version >= 0.4.5. Would you like us to update that gem for you? (You will need to relaunch once it's been updated).")) {
            return true;
        }
        Job job = new Job("Updating installed ruby-debug-ide gem..."){

            protected IStatus run(IProgressMonitor monitor) {
                return AptanaRDTPlugin.getDefault().getGemManager().update(new Gem(RubyApplicationShortcut.RUBY_DEBUG_IDE_GEM_NAME, "", null), monitor);
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    private static void installNecessaryProfilingGems() {
        if (!MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"ruby-prof not installed", (String)"To profile, it is required that you use the ruby-prof gem. Would you like us to install that gem?")) {
            return;
        }
        if (InstallDeveloperToolsDialog.shouldShow()) {
            InstallDeveloperToolsDialog dialog = new InstallDeveloperToolsDialog(Display.getDefault().getActiveShell());
            dialog.open();
            return;
        }
        ArrayList<Gem> finalGems = new ArrayList<Gem>();
        Gem gem = ContributedGemRegistry.getGem((String)RUBY_PROFILING_GEM_NAME);
        if (gem != null) {
            finalGems.add(gem);
        }
        InstallGemsJob job = new InstallGemsJob(finalGems);
        job.setSystem(true);
        job.schedule();
    }

    private static void installNecessaryDebuggingGems() {
        if (!MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"ruby-debug not installed", (String)"To debug, it is recommended that you use the ruby-debug based debugger. Would you like us to install that gem?")) {
            return;
        }
        if (InstallDeveloperToolsDialog.shouldShow()) {
            InstallDeveloperToolsDialog dialog = new InstallDeveloperToolsDialog(Display.getDefault().getActiveShell());
            dialog.open();
            return;
        }
        ArrayList<Gem> finalGems = new ArrayList<Gem>();
        Gem gem = ContributedGemRegistry.getGem((String)"ruby-debug-base");
        if (gem != null) {
            finalGems.add(gem);
        }
        if ((gem = ContributedGemRegistry.getGem((String)RUBY_DEBUG_IDE_GEM_NAME)) != null) {
            finalGems.add(gem);
        }
        InstallGemsJob job = new InstallGemsJob(finalGems);
        job.setSystem(true);
        job.schedule();
    }

    protected void doLaunch(IRubyElement rubyElement, String mode) throws CoreException {
        ILaunchConfiguration config = this.findOrCreateLaunchConfiguration(rubyElement, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            this.log("Could not retrieve input from editor: " + editor.getTitle());
            return;
        }
        IRubyElement rubyElement = (IRubyElement)input.getAdapter(IRubyElement.class);
        if (rubyElement == null) {
            this.log("Editor input is not a ruby file or external ruby file.");
            return;
        }
        this.doLaunchWithErrorHandling(rubyElement, mode);
    }

    protected ILaunchConfiguration findOrCreateLaunchConfiguration(IRubyElement rubyElement, String mode) throws CoreException {
        IFile rubyFile = (IFile)rubyElement.getUnderlyingResource();
        ILaunchConfigurationType configType = this.getRubyLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = null;
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        int i = 0;
        while (i < configs.length) {
            boolean projectRelativeFileNamesEqual;
            ILaunchConfiguration config = configs[i];
            boolean projectsEqual = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(rubyFile.getProject().getName());
            if (projectsEqual && (projectRelativeFileNamesEqual = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, "").equals(rubyFile.getProjectRelativePath().toString()))) {
                candidateConfigs.add(config);
            }
            ++i;
        }
        switch (candidateConfigs.size()) {
            case 0: {
                return this.createConfiguration(rubyFile);
            }
            case 1: {
                return (ILaunchConfiguration)candidateConfigs.get(0);
            }
        }
        Status status = new Status(2, "org.rubypeople.rdt.debug.ui", 0, RdtDebugUiMessages.LaunchConfigurationShortcut_Ruby_multipleConfigurationsError, null);
        throw new CoreException((IStatus)status);
    }

    protected ILaunchConfiguration createConfiguration(IFile rubyFile) {
        if (RubyRuntime.getDefaultVMInstall() == null) {
            this.showNoInterpreterDialog();
            return null;
        }
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getRubyLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(rubyFile.getName()));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, rubyFile.getProject().getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, rubyFile.getProjectRelativePath().toString());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, RubyApplicationShortcut.getDefaultWorkingDirectory(rubyFile.getProject()));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, RubyRuntime.getDefaultVMInstall().getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, RubyRuntime.getDefaultVMInstall().getVMInstallType().getId());
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.rubypeople.rdt.debug.ui.rubySourceLocator");
            config = wc.doSave();
        }
        catch (CoreException ce) {
            this.log(ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getRubyLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION);
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void log(String message) {
        RdtDebugUiPlugin.log((IStatus)new Status(1, "org.rubypeople.rdt.debug.ui", 1, message, null));
    }

    protected void log(Throwable t) {
        RdtDebugUiPlugin.log(t);
    }

    protected void showNoInterpreterDialog() {
        MessageDialog.openInformation((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)RdtDebugUiMessages.Dialog_launchWithoutSelectedInterpreter_title, (String)RdtDebugUiMessages.Dialog_launchWithoutSelectedInterpreter);
    }

    protected static String getDefaultWorkingDirectory(IProject project) {
        if (project != null && project.exists()) {
            return project.getLocation().toOSString();
        }
        return RdtDebugUiPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }
}

