/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.debug.ui.RdtDebugUiImages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.ui.util.DirectorySelector;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

public class RubyArgumentsTab
extends AbstractLaunchConfigurationTab {
    protected Text interpreterArgsText;
    protected Text programArgsText;
    protected DirectorySelector workingDirectorySelector;
    protected Button useDefaultWorkingDirectoryButton;

    public void createControl(Composite parent) {
        Composite composite = this.createPageRoot(parent);
        new Label(composite, 0).setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyArguments_working_dir);
        this.workingDirectorySelector = new DirectorySelector(composite);
        this.workingDirectorySelector.setBrowseDialogMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyArguments_working_dir_browser_message);
        this.workingDirectorySelector.setLayoutData((Object)new GridData(768));
        this.workingDirectorySelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RubyArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite defaultWorkingDirectoryComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        defaultWorkingDirectoryComposite.setLayout((Layout)layout);
        this.useDefaultWorkingDirectoryButton = new Button(defaultWorkingDirectoryComposite, 32);
        this.useDefaultWorkingDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RubyArgumentsTab.this.setUseDefaultWorkingDirectory(((Button)e.getSource()).getSelection());
            }
        });
        new Label(defaultWorkingDirectoryComposite, 0).setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyArguments_working_dir_use_default_message);
        defaultWorkingDirectoryComposite.pack();
        new Label(composite, 0);
        new Label(composite, 0).setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyArguments_interpreter_args_box_title);
        this.interpreterArgsText = new Text(composite, 2562);
        this.interpreterArgsText.setLayoutData((Object)new GridData(1808));
        this.interpreterArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RubyArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(composite, 0).setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyArguments_program_args_box_title);
        this.programArgsText = new Text(composite, 2562);
        this.programArgsText.setLayoutData((Object)new GridData(1808));
        this.programArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RubyArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void setUseDefaultWorkingDirectory(boolean useDefault) {
        if (this.useDefaultWorkingDirectoryButton.getSelection() != useDefault) {
            this.useDefaultWorkingDirectoryButton.setSelection(useDefault);
        }
        if (useDefault) {
            this.workingDirectorySelector.setSelectionText("");
        }
        this.workingDirectorySelector.setEnabled(!useDefault);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.rubypeople.rdt.launching.USE_DEFAULT_WORKING_DIRECTORY", true);
        configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
        configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.rubypeople.rdt.debug.ui.rubySourceLocator");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String workingDirectory = "";
        String interpreterArgs = "";
        String programArgs = "";
        boolean useDefaultWorkDir = true;
        try {
            workingDirectory = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "");
            interpreterArgs = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            programArgs = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            useDefaultWorkDir = configuration.getAttribute("org.rubypeople.rdt.launching.USE_DEFAULT_WORKING_DIRECTORY", true);
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.workingDirectorySelector.setSelectionText(workingDirectory);
        this.interpreterArgsText.setText(interpreterArgs);
        this.programArgsText.setText(programArgs);
        this.setUseDefaultWorkingDirectory(useDefaultWorkDir);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, this.workingDirectorySelector.getValidatedSelectionText());
        configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.interpreterArgsText.getText());
        configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.programArgsText.getText());
        configuration.setAttribute("org.rubypeople.rdt.launching.USE_DEFAULT_WORKING_DIRECTORY", this.useDefaultWorkingDirectoryButton.getSelection());
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginWidth = 0;
        compositeLayout.numColumns = 1;
        composite.setLayout((Layout)compositeLayout);
        this.setControl((Control)composite);
        return composite;
    }

    public String getName() {
        return RdtDebugUiMessages.LaunchConfigurationTab_RubyArguments_name;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            String workingDirectory = launchConfig.getAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "");
            if (!this.useDefaultWorkingDirectoryButton() && workingDirectory.length() == 0) {
                this.setErrorMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyArguments_working_dir_error_message);
                return false;
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean useDefaultWorkingDirectoryButton() {
        if (this.useDefaultWorkingDirectoryButton == null) {
            return false;
        }
        return this.useDefaultWorkingDirectoryButton.getSelection();
    }

    protected void log(Throwable t) {
        RdtDebugUiPlugin.log(t);
    }

    public Image getImage() {
        return RdtDebugUiImages.get("org.rubypeople.rdt.debug.ui.arguments_tab.gif");
    }
}

