/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.launcher.LoadPathEntryLabelProvider;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.AddVMDialog;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.IAddVMDialogRequestor;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.RubyVMMessages;
import org.rubypeople.rdt.internal.launching.RubyLaunchConfigurationAttribute;
import org.rubypeople.rdt.internal.launching.RuntimeLoadpathEntry;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.launching.VMStandin;

public class RubyEnvironmentTab
extends AbstractLaunchConfigurationTab {
    protected ListViewer loadPathListViewer;
    protected List<IVMInstall> installedInterpretersWorkingCopy;
    protected Combo interpreterCombo;
    protected Button loadPathDefaultButton;

    public void createControl(Composite parent) {
        Composite composite = this.createPageRoot(parent);
        TabFolder tabFolder = new TabFolder(composite, 0);
        GridData gridData = new GridData(1808);
        tabFolder.setLayoutData((Object)gridData);
        this.addLoadPathTab(tabFolder);
        this.addInterpreterTab(tabFolder);
    }

    protected void addLoadPathTab(TabFolder tabFolder) {
        Composite loadPathComposite = new Composite((Composite)tabFolder, 0);
        loadPathComposite.setLayout((Layout)new GridLayout());
        this.loadPathListViewer = new ListViewer(loadPathComposite, 2818);
        this.loadPathListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.loadPathListViewer.setLabelProvider((IBaseLabelProvider)new LoadPathEntryLabelProvider());
        this.loadPathListViewer.getList().setLayoutData((Object)new GridData(1808));
        TabItem loadPathTab = new TabItem(tabFolder, 0, 0);
        loadPathTab.setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyEnvironment_loadPathTab_label);
        loadPathTab.setControl((Control)loadPathComposite);
        loadPathTab.setData((Object)this.loadPathListViewer);
        this.loadPathDefaultButton = new Button(loadPathComposite, 32);
        this.loadPathDefaultButton.setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyEnvironment_loadPathDefaultButton_label);
        this.loadPathDefaultButton.setLayoutData((Object)new GridData(32));
        this.loadPathDefaultButton.addSelectionListener(this.getLoadPathDefaultButtonSelectionListener());
        this.loadPathDefaultButton.setEnabled(true);
    }

    protected SelectionListener getLoadPathSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Loadpath list selection occurred: " + e.getSource());
            }
        };
    }

    protected SelectionListener getLoadPathDefaultButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RubyEnvironmentTab.this.setUseLoadPathDefaults(((Button)e.getSource()).getSelection());
            }
        };
    }

    protected void addInterpreterTab(TabFolder tabFolder) {
        Composite interpreterComposite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        interpreterComposite.setLayout((Layout)layout);
        interpreterComposite.setLayoutData((Object)new GridData(768));
        this.createVerticalSpacer(interpreterComposite, 2);
        this.interpreterCombo = new Combo(interpreterComposite, 8);
        this.interpreterCombo.setLayoutData((Object)new GridData(768));
        this.initializeInterpreterCombo(this.interpreterCombo);
        this.interpreterCombo.addModifyListener(this.getInterpreterComboModifyListener());
        Button interpreterAddButton = new Button(interpreterComposite, 8);
        interpreterAddButton.setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyEnvironment_interpreterAddButton_label);
        interpreterAddButton.addSelectionListener((SelectionListener)new AddInterpreterSelectionAdapter(this.interpreterCombo, this.getShell()));
        TabItem interpreterTab = new TabItem(tabFolder, 0);
        interpreterTab.setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyEnvironment_interpreterTab_label);
        interpreterTab.setControl((Control)interpreterComposite);
    }

    protected ModifyListener getInterpreterComboModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RubyEnvironmentTab.this.updateLaunchConfigurationDialog();
            }
        };
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IVMInstall defaultInterpreter = RubyRuntime.getDefaultVMInstall();
        if (defaultInterpreter != null) {
            configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, defaultInterpreter.getName());
            configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, defaultInterpreter.getVMInstallType().getId());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializeLoadPath(configuration);
        this.initializeInterpreterSelection(configuration);
    }

    protected void initializeLoadPath(ILaunchConfiguration configuration) {
        boolean useDefaultLoadPath = true;
        try {
            IRubyProject project;
            useDefaultLoadPath = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_DEFAULT_LOADPATH, true);
            this.setUseLoadPathDefaults(useDefaultLoadPath);
            String projectName = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            if (projectName.length() != 0 && (project = RubyModelManager.getRubyModelManager().getRubyModel().getRubyProject(projectName)) != null) {
                ILoadpathEntry[] entries = project.getResolvedLoadpath(true);
                this.loadPathListViewer.setInput((Object)entries);
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
    }

    protected void setUseLoadPathDefaults(boolean useDefaults) {
        this.loadPathListViewer.getList().setEnabled(!useDefaults);
        this.loadPathDefaultButton.setSelection(useDefaults);
    }

    protected void initializeInterpreterSelection(ILaunchConfiguration configuration) {
        String interpreterName = null;
        try {
            interpreterName = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
        }
        catch (CoreException e) {
            this.log(e);
        }
        if (interpreterName != null && !interpreterName.equals("")) {
            this.interpreterCombo.select(this.interpreterCombo.indexOf(interpreterName));
        }
    }

    protected void initializeInterpreterCombo(Combo interpreterCombo) {
        this.installedInterpretersWorkingCopy = new ArrayList<IVMInstall>();
        ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
        IVMInstallType[] types = RubyRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType type = types[i];
            IVMInstall[] installs = type.getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                IVMInstall install = installs[j];
                standins.add(new VMStandin(install));
                ++j;
            }
            ++i;
        }
        this.installedInterpretersWorkingCopy.addAll(standins);
        String[] interpreterNames = new String[this.installedInterpretersWorkingCopy.size()];
        int interpreterIndex = 0;
        while (interpreterIndex < this.installedInterpretersWorkingCopy.size()) {
            IVMInstall interpreter = this.installedInterpretersWorkingCopy.get(interpreterIndex);
            interpreterNames[interpreterIndex] = interpreter.getName();
            ++interpreterIndex;
        }
        interpreterCombo.setItems(interpreterNames);
        IVMInstall selectedInterpreter = RubyRuntime.getDefaultVMInstall();
        if (selectedInterpreter != null) {
            interpreterCombo.select(interpreterCombo.indexOf(selectedInterpreter.getName()));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int selectionIndex = this.interpreterCombo.getSelectionIndex();
        if (selectionIndex >= 0) {
            IVMInstall vm = this.installedInterpretersWorkingCopy.get(selectionIndex);
            configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vm.getName());
            configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vm.getVMInstallType().getId());
        }
        configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_DEFAULT_LOADPATH, this.loadPathDefaultButton.getSelection());
        if (!this.loadPathDefaultButton.getSelection()) {
            ILoadpathEntry[] loadPathEntries = (ILoadpathEntry[])this.loadPathListViewer.getInput();
            ArrayList<String> loadPathStrings = new ArrayList<String>();
            int i = 0;
            while (i < loadPathEntries.length) {
                try {
                    ILoadpathEntry entry = loadPathEntries[i];
                    if (!(entry.getEntryKind() == 3 ? entry.getPath().equals((Object)new Path("/" + configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""))) : entry.getEntryKind() == 1)) {
                        RuntimeLoadpathEntry runtime = new RuntimeLoadpathEntry(entry);
                        loadPathStrings.add(runtime.getMemento());
                    }
                }
                catch (CoreException e) {
                    this.log(e);
                }
                ++i;
            }
            configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_LOADPATH, loadPathStrings);
        }
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createVerticalSpacer(composite, 2);
        this.setControl((Control)composite);
        return composite;
    }

    public String getName() {
        return RdtDebugUiMessages.LaunchConfigurationTab_RubyEnvironment_name;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            String selectedInterpreter = launchConfig.getAttribute(RubyLaunchConfigurationAttribute.SELECTED_INTERPRETER, "");
            if (selectedInterpreter.length() == 0) {
                this.setErrorMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyEnvironment_interpreter_not_selected_error_message);
                return false;
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void log(Throwable t) {
        RdtDebugUiPlugin.log(t);
    }

    public Image getImage() {
        return RubyPluginImages.get((String)"org.rubypeople.rdt.ui.ruby.gif");
    }

    private static class AddInterpreterSelectionAdapter
    extends SelectionAdapter
    implements IAddVMDialogRequestor {
        private Combo fCombo;
        private Shell fShell;

        public AddInterpreterSelectionAdapter(Combo combo, Shell shell) {
            this.fCombo = combo;
            this.fShell = shell;
        }

        public void widgetSelected(SelectionEvent evt) {
            AddVMDialog dialog = new AddVMDialog(this, this.fShell, RubyRuntime.getVMInstallTypes(), null);
            dialog.setTitle(RubyVMMessages.InstalledJREsBlock_7);
            if (dialog.open() != 0) {
                return;
            }
        }

        public boolean isDuplicateName(String name) {
            return false;
        }

        public void vmAdded(IVMInstall vm) {
            if (vm instanceof VMStandin) {
                VMStandin standin = (VMStandin)vm;
                standin.convertToRealVM();
            }
            this.fCombo.add(vm.getName());
            this.fCombo.select(this.fCombo.indexOf(vm.getName()));
        }
    }
}

