/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.evaluation.EvaluationExpression;
import org.rubypeople.rdt.internal.debug.ui.evaluation.EvaluationExpressionReaderWriter;
import org.rubypeople.rdt.internal.debug.ui.preferences.EditEvaluationExpressionDialog;
import org.rubypeople.rdt.internal.ui.util.SWTUtil;

public class EvaluationExpressionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fImportButton;
    private Button fExportButton;
    private Button fRemoveButton;
    private EditableExpressionModel fModel = new EditableExpressionModel();

    public EvaluationExpressionsPreferencePage() {
        this.setDescription(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_description);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        Table table = new Table(innerParent, 67618);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(3);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_column_name);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_column_description);
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new EvaluationExpressionLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new EvaluationExpressionContentProvider());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                EvaluationExpressionsPreferencePage.this.edit();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                EvaluationExpressionsPreferencePage.this.selectionChanged1();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((EvaluationExpression)event.getElement()).setEnabled(event.getChecked());
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_new);
        this.fAddButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fAddButton));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EvaluationExpressionsPreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_edit);
        this.fEditButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fEditButton));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EvaluationExpressionsPreferencePage.this.edit();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_remove);
        this.fRemoveButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fRemoveButton));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EvaluationExpressionsPreferencePage.this.remove();
            }
        });
        this.createSeparator(buttons);
        this.fImportButton = new Button(buttons, 8);
        this.fImportButton.setText(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_import);
        this.fImportButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fImportButton));
        this.fImportButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EvaluationExpressionsPreferencePage.this.importFile();
            }
        });
        this.fExportButton = new Button(buttons, 8);
        this.fExportButton.setText(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_export);
        this.fExportButton.setLayoutData((Object)EvaluationExpressionsPreferencePage.getButtonGridData(this.fExportButton));
        this.fExportButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                EvaluationExpressionsPreferencePage.this.exportFile();
            }
        });
        this.fTableViewer.setInput((Object)this.fModel);
        this.setEnabledExpresions(this.fTableViewer);
        this.updateButtons();
        EvaluationExpressionsPreferencePage.configureTableResizing(innerParent, buttons, table, column1, column2);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void setEnabledExpresions(CheckboxTableViewer viewer) {
        Object[] objectArray = this.fModel.getExpressionsAsArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            EvaluationExpression expr = (EvaluationExpression)o;
            viewer.setChecked(o, expr.isEnabled());
            ++n2;
        }
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    private static void configureTableResizing(final Composite parent, final Composite buttons, final Table table, final TableColumn column1, final TableColumn column2) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > (width -= buttons.getSize().x)) {
                    column1.setWidth(width / 3);
                    column2.setWidth(width - column1.getWidth());
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    column1.setWidth(width / 3);
                    column2.setWidth(width - column1.getWidth());
                }
            }
        });
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        data.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        data.heightHint = SWTUtil.getButtonHeightHint((Button)button);
        return data;
    }

    private void selectionChanged1() {
        this.updateButtons();
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fExportButton.setEnabled(selectionCount > 0);
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount);
    }

    private void add() {
        EvaluationExpression evalExpression = new EvaluationExpression("", "", "", false);
        String title = RdtDebugUiMessages.EditEvaluationExpressionDialog_add;
        EditEvaluationExpressionDialog dialog = new EditEvaluationExpressionDialog(this.getShell(), title, evalExpression);
        if (dialog.open() == 0) {
            this.fModel.addExpression(evalExpression);
            this.fTableViewer.refresh();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)evalExpression));
        }
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        EvaluationExpression data = (EvaluationExpression)selection.getFirstElement();
        this.edit(data);
    }

    private void edit(EvaluationExpression evalExpression) {
        String title = RdtDebugUiMessages.EditEvaluationExpressionDialog_edit;
        EditEvaluationExpressionDialog dialog = new EditEvaluationExpressionDialog(this.getShell(), title, evalExpression);
        if (dialog.open() == 0) {
            this.fTableViewer.refresh();
        }
    }

    private void importFile() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_import_title);
        dialog.setFilterExtensions(new String[]{RdtDebugUiMessages.EvaluationExpressionsPreferencePage_importexport_extension});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        new TemplateReaderWriter();
        File file = new File(path);
        if (file.exists()) {
            try {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                this.fModel.importExpressions(input);
            }
            catch (Exception e) {
                RdtDebugUiPlugin.log(e);
            }
        }
        this.fTableViewer.refresh();
    }

    private void exportFile() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] expressions = selection.toArray();
        EvaluationExpression[] datas = new EvaluationExpression[expressions.length];
        int i = 0;
        while (i != expressions.length) {
            datas[i] = (EvaluationExpression)expressions[i];
            ++i;
        }
        this.export(datas);
    }

    private void export(EvaluationExpression[] expressions) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(RdtDebugUiMessages.getFormattedString(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_export_title, new Integer(expressions.length)));
        dialog.setFilterExtensions(new String[]{RdtDebugUiMessages.EvaluationExpressionsPreferencePage_importexport_extension});
        dialog.setFileName(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_export_filename);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            String title = RdtDebugUiMessages.EvaluationExpressionsPreferencePage_export_error_title;
            String message = RdtDebugUiMessages.getFormattedString(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_export_error_hidden, file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = RdtDebugUiMessages.EvaluationExpressionsPreferencePage_export_error_title;
            String message = RdtDebugUiMessages.getFormattedString(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_export_error_canNotWrite, file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            try {
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                this.fModel.exportExpressions(expressions, output);
            }
            catch (Exception exception) {}
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)RdtDebugUiMessages.EvaluationExpressionsPreferencePage_export_exists_title, (String)RdtDebugUiMessages.getFormattedString(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_export_exists_message, file.getAbsolutePath()));
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            this.fModel.removeExpression((EvaluationExpression)elements.next());
        }
        this.fTableViewer.refresh();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(RdtDebugUiMessages.EvaluationExpressionsPreferencePage_title);
        }
    }

    protected void performDefaults() {
        RdtDebugUiPlugin.getDefault().getPluginPreferences().setToDefault("org.rubypeople.rdt.debug.ui.evaluationExpressions");
        this.fModel.load();
        this.fTableViewer.refresh();
    }

    public boolean performOk() {
        this.fModel.save();
        return super.performOk();
    }

    public boolean performCancel() {
        this.fModel.load();
        return super.performCancel();
    }

    protected CheckboxTableViewer getTableViewer() {
        return this.fTableViewer;
    }

    private class EditableExpressionModel {
        private ArrayList expressions;

        public EditableExpressionModel() {
            this.load();
        }

        public Collection getExpressions() {
            return this.expressions;
        }

        public Object[] getExpressionsAsArray() {
            return this.expressions.toArray(new EvaluationExpression[this.expressions.size()]);
        }

        public void addExpression(EvaluationExpression expr) {
            this.expressions.add(expr);
        }

        public void replaceExpression(EvaluationExpression old, EvaluationExpression updated) {
            int index = this.expressions.indexOf(old);
            if (index >= 0) {
                this.expressions.set(index, updated);
            }
        }

        public void removeExpression(EvaluationExpression expr) {
            this.expressions.remove(expr);
        }

        public void save() {
            StringWriter xmlWriter = new StringWriter();
            try {
                new EvaluationExpressionReaderWriter().save((EvaluationExpression[])this.getExpressionsAsArray(), xmlWriter);
                RdtDebugUiPlugin.getDefault().getPluginPreferences().setValue("org.rubypeople.rdt.debug.ui.evaluationExpressions", xmlWriter.toString());
            }
            catch (IOException e) {
                RdtDebugUiPlugin.log(e);
            }
        }

        public void load() {
            EvaluationExpression[] exprs = RdtDebugUiPlugin.getDefault().getEvaluationExpressionModel().getEvaluationExpressions();
            this.expressions = new ArrayList(exprs.length);
            int i = 0;
            while (i < exprs.length) {
                EvaluationExpression expression = exprs[i];
                this.expressions.add(expression);
                ++i;
            }
        }

        public void importExpressions(InputStream in) throws IOException, FileNotFoundException {
            EvaluationExpression[] importedExprs = new EvaluationExpressionReaderWriter().read(in, null);
            int i = 0;
            while (i < importedExprs.length) {
                this.expressions.add(importedExprs[i]);
                ++i;
            }
        }

        public void exportExpressions(EvaluationExpression[] expressions, OutputStream out) throws IOException {
            new EvaluationExpressionReaderWriter().save(expressions, out);
        }
    }

    private class EvaluationExpressionContentProvider
    implements IStructuredContentProvider {
        private EditableExpressionModel model;

        private EvaluationExpressionContentProvider() {
        }

        public Object[] getElements(Object input) {
            return this.model.getExpressionsAsArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.model = (EditableExpressionModel)newInput;
        }

        public void dispose() {
            this.model = null;
        }
    }

    private class EvaluationExpressionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private EvaluationExpressionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EvaluationExpression exp = (EvaluationExpression)element;
            switch (columnIndex) {
                case 0: {
                    return exp.getName();
                }
                case 1: {
                    return exp.getDescription();
                }
            }
            return "";
        }
    }
}

