/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.radrails.server.bridge;

import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerManagerListener;
import com.aptana.ide.server.core.ServerManagerEvent;
import com.aptana.ide.server.core.model.IServerProviderDelegate;
import com.aptana.radrails.server.bridge.RailsServer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;

public class RailsServerProvider
implements IServerProviderDelegate {
    private HashSet<IServerManagerListener> listeners = new HashSet();
    private HashMap<Server, IServer> map = new HashMap();

    public RailsServerProvider() {
        ServerManager instance = ServerManager.getInstance();
        instance.addServerObserver(new Observer(){

            public void update(Observable o, Object arg) {
                Server s = (Server)o;
                if (arg.equals("remove")) {
                    IServer r = (IServer)RailsServerProvider.this.map.remove(s);
                    RailsServerProvider.this.fireEvent(new ServerManagerEvent(r, 1));
                    return;
                }
                if (arg.equals("add")) {
                    RailsServer railsServer = new RailsServer(s);
                    RailsServerProvider.this.map.put(s, railsServer);
                    RailsServerProvider.this.fireEvent(new ServerManagerEvent((IServer)railsServer, 0));
                    return;
                }
                IServer server = (IServer)RailsServerProvider.this.map.get(s);
                if (server != null) {
                    RailsServerProvider.this.fireEvent(new ServerManagerEvent(server, 2));
                }
            }
        });
        Collection servers = ServerManager.getInstance().getServers();
        for (Server s : servers) {
            this.map.put(s, (IServer)new RailsServer(s));
        }
    }

    protected void fireEvent(ServerManagerEvent serverManagerEvent) {
        for (IServerManagerListener l : this.listeners) {
            l.serversChanged(serverManagerEvent);
        }
    }

    public void addServerChangeListener(IServerManagerListener listener) {
        this.listeners.add(listener);
    }

    public IServer[] getServers() {
        IServer[] result = new IServer[this.map.size()];
        this.map.values().toArray(result);
        return result;
    }

    public void removeServerChangeListener(IServerManagerListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isRemovable(IServer server) {
        return true;
    }

    public void removeServer(IServer server) {
        ServerManager.getInstance().removeServer(((RailsServer)server).getServer());
    }
}

