/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.internal.ui.console;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.progress.UIJob;
import org.radrails.rails.ui.browser.BrowserUtil;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;
import org.radrails.server.internal.ui.ActionUtil;
import org.radrails.server.internal.ui.ServerUIPlugin;

public class LaunchBrowserAction
extends Action
implements Observer {
    private IProcess process;
    private Server server;

    public LaunchBrowserAction(IProcess process) {
        this.process = process;
        ServerManager.getInstance().addServerObserver((Observer)this);
        ActionUtil.initAction((IAction)this, "browser.gif", "Launch Browser");
        Server server = this.getServer();
        if (server != null && server.isStarted()) {
            this.setEnablement(server);
        } else {
            this.setEnabled(false);
        }
    }

    private Server getServer() {
        if (this.server != null) {
            return this.server;
        }
        Server server = ServerManager.getInstance().findByProcess(this.process);
        if (server != null) {
            this.server = server;
        }
        return server;
    }

    public void run() {
        UIJob job = new UIJob("Opening browser"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    Server s = LaunchBrowserAction.this.getServer();
                    if (s == null) {
                        return Status.CANCEL_STATUS;
                    }
                    String port = String.valueOf(s.getPort());
                    BrowserUtil.openBrowser((String)("http://" + s.getBrowserHost() + ":" + port));
                }
                catch (Exception e) {
                    return new Status(4, ServerUIPlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void update(Observable o, Object arg) {
        if (this.getServer() == null) {
            this.setEnabled(false);
            return;
        }
        String action = (String)arg;
        if (action.equals("update")) {
            Server s = (Server)o;
            if (!s.equals((Object)this.getServer())) {
                return;
            }
            this.setEnablement(s);
        }
    }

    private void setEnablement(Server s) {
        if (s == null) {
            this.setEnabled(false);
            return;
        }
        if (s.isStopped() || s.isStopping()) {
            this.setEnabled(false);
            final LaunchBrowserAction self = this;
            Job job = new Job("Remove server observer"){

                protected IStatus run(IProgressMonitor monitor) {
                    ServerManager.getInstance().deleteServerObserver(self);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            this.setEnabled(true);
        }
    }
}

