/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.internal.ui.console;

import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ConsoleTerminateAction;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;
import org.radrails.server.internal.ui.console.LaunchBrowserAction;
import org.radrails.server.internal.ui.console.ServerStopAction;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

public class ServerConsolePageParticipant
implements IConsolePageParticipant {
    private ServerStopAction consoleStopAction;
    private LaunchBrowserAction launchBrowserAction;
    private IToolBarManager toolbar;

    public void init(IPageBookViewPage page, org.eclipse.ui.console.IConsole console) {
        if (!(console instanceof IConsole)) {
            return;
        }
        IConsole processConsole = (IConsole)console;
        IProcess process = processConsole.getProcess();
        if (!this.looksLikeServerStarting(process)) {
            return;
        }
        this.consoleStopAction = new ServerStopAction(process);
        this.launchBrowserAction = new LaunchBrowserAction(process);
        IActionBars bars = page.getSite().getActionBars();
        this.toolbar = bars.getToolBarManager();
        this.removeTerminateAction(this.toolbar);
        bars.getToolBarManager().prependToGroup("launchGroup", (IAction)this.consoleStopAction);
        bars.getToolBarManager().prependToGroup("launchGroup", (IAction)this.launchBrowserAction);
    }

    private void removeTerminateAction(IToolBarManager toolbar) {
        if (toolbar == null) {
            return;
        }
        IContributionItem[] items = toolbar.getItems();
        int i = 0;
        while (i < items.length) {
            ActionContributionItem item;
            IAction action;
            if (items[i] instanceof ActionContributionItem && (action = (item = (ActionContributionItem)items[i]).getAction()) instanceof ConsoleTerminateAction) {
                toolbar.remove((IContributionItem)item);
                toolbar.update(false);
                break;
            }
            ++i;
        }
    }

    private boolean looksLikeServerStarting(IProcess process) {
        if (process == null || process.getLaunch() == null) {
            return false;
        }
        String fileName = process.getLaunch().getAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME);
        if (fileName == null || fileName.trim().length() == 0) {
            return false;
        }
        return fileName.endsWith("mongrel_rails") || fileName.endsWith("server");
    }

    public void dispose() {
        this.consoleStopAction = null;
        this.launchBrowserAction = null;
    }

    public void activated() {
        this.removeTerminateAction(this.toolbar);
    }

    public void deactivated() {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

