/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.internal.ui.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;
import org.radrails.server.internal.ui.ServerUILog;
import org.radrails.server.internal.ui.launching.LaunchingMessages;
import org.radrails.server.internal.ui.launching.RailsAppLaunchHelper;
import org.radrails.server.ui.dialogs.EditServerDialog;
import org.rubypeople.rdt.core.IRubyElement;

public class RailsAppLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof IResource) {
                this.launch(((IResource)object).getProject(), mode);
            } else if (object instanceof IAdaptable) {
                IAdaptable adapt = (IAdaptable)object;
                IResource resource = (IResource)adapt.getAdapter(IResource.class);
                this.launch(resource.getProject(), mode);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            ServerUILog.logError((String)("Could not retrieve input from editor: " + editor.getTitle()), (Throwable)new Exception());
            return;
        }
        IRubyElement rubyElement = (IRubyElement)input.getAdapter(IRubyElement.class);
        if (rubyElement == null) {
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                IFile file = fileInput.getFile();
                this.launch(file.getProject(), mode);
                return;
            }
            ServerUILog.logError((String)"Editor input is not a ruby file or external ruby file.", (Throwable)new Exception());
            return;
        }
        this.launch(rubyElement.getRubyProject().getProject(), mode);
    }

    private void launch(IProject project, String mode) {
        if (!RailsPlugin.hasRailsNature((IProject)project)) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Not a Rails project", (String)"Selected project is not a Rails project");
            return;
        }
        ILaunchConfiguration config = this.findLaunchConfiguration(project, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    private ILaunchConfiguration findLaunchConfiguration(IProject project, String mode) {
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("org.radrails.server.core.launching.project_name", "").equals(project.getName())) {
                    return config;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            ServerUILog.logError((String)"error finding launch configuration", (Throwable)e);
        }
        return this.createConfiguration(project);
    }

    private ILaunchConfiguration createConfiguration(IProject project) {
        ILaunchConfigurationWorkingCopy wc;
        ILaunchConfiguration config;
        block4: {
            boolean createServer;
            config = null;
            ILaunchConfigurationType configType = this.getLaunchConfigType();
            wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(project.getName()));
            RailsAppLaunchHelper.setDefaults(wc);
            String serverName = wc.getAttribute("org.radrails.server.core.launching.server_name", null);
            if (serverName != null || !(createServer = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)LaunchingMessages.RailsAppLaunch_noServerExistsDialog_title, (String)LaunchingMessages.RailsAppLaunch_noServerExistsDialog_msg))) break block4;
            EditServerDialog dialog = new EditServerDialog(Display.getCurrent().getActiveShell());
            dialog.dontAskForProject();
            if (dialog.open() == 0) {
                Server s = new Server(project, dialog.getName(), dialog.getType(), dialog.getHost(), dialog.getPort(), dialog.getEnvironment());
                ServerManager.getInstance().addServer(s);
                wc.setAttribute("org.radrails.server.core.launching.server_name", s.getName());
                break block4;
            }
            return null;
        }
        try {
            config = wc.doSave();
        }
        catch (CoreException e) {
            ServerUILog.logError((String)"error creating launch configuration", (Throwable)e);
        }
        return config;
    }

    private ILaunchConfigurationType getLaunchConfigType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager.getLaunchConfigurationType("org.radrails.server.ui.RailsAppLaunchConfigurationType");
    }
}

