/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseCharacterStreamWrapper;
import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseColumns;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseImplServiceResultSet;
import com.microsoft.jdbc.base.BaseInputStreamWrapper;
import com.microsoft.util.UtilStringFunctions;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class BaseImplUpdatableResultSet
extends BaseImplServiceResultSet {
    private static String footprint = "$Revision:   1.13.1.0.1.0  $";
    private String tableName;
    private BaseColumns columns;
    private BaseData[] keyValues;
    private BaseData[] updatedValues;
    private BaseConnection connection;
    private PreparedStatement updateStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement insertStatement;
    private int[] previousUpdateColumns;
    private int[] previousDeleteColumns;
    private int[] previousInsertColumns;
    boolean onInsertRow;
    String identifierQuote;

    BaseImplUpdatableResultSet(BaseConnection baseConnection, String string, BaseColumns baseColumns, String string2) throws SQLException {
        this.connection = baseConnection;
        this.tableName = string;
        this.columns = baseColumns;
        this.identifierQuote = string2;
        this.onInsertRow = false;
    }

    private void cacheBoundColumns(int[] nArray) {
        int n;
        int n2 = 1;
        if (this.updatedValues != null) {
            n = 0;
            while (n < this.updatedValues.length) {
                if (this.updatedValues[n] != null) {
                    nArray[n2] = n;
                    ++n2;
                }
                ++n;
            }
        }
        if (this.keyValues != null) {
            n = 0;
            while (n < this.keyValues.length) {
                if (this.keyValues[n] != null && this.keyValues[n].data != null) {
                    nArray[n2] = n + 10000;
                    ++n2;
                }
                ++n;
            }
        }
        nArray[0] = n2 - 1;
    }

    private void cacheKeyDataUpToColumn(int n) throws SQLException {
        this.setupKeyValues();
        --n;
        int n2 = 0;
        while (n2 < n) {
            if (this.keyValues[n2] == null && this.columns.get((int)(n2 + 1)).isKey) {
                this.keyValues[n2] = this.subImplResultSet.getData(n2 + 1, this.columns.get((int)(n2 + 1)).baseDataType);
            }
            ++n2;
        }
    }

    public void cancelInsertRow() throws SQLException {
        this.cancelUpdates();
        this.onInsertRow = false;
    }

    public void cancelUpdates() throws SQLException {
        if (this.updatedValues != null) {
            int n = 0;
            while (n < this.updatedValues.length) {
                this.updatedValues[n] = null;
                ++n;
            }
        }
    }

    public void close() throws SQLException {
        super.close();
        if (this.updateStatement != null) {
            this.updateStatement.close();
        }
        if (this.deleteStatement != null) {
            this.deleteStatement.close();
        }
        if (this.insertStatement != null) {
            this.insertStatement.close();
        }
    }

    public void deleteRow() throws SQLException {
        this.setupPreviousColumnsLists();
        this.deleteStatement = this.executeStatement(this.deleteStatement, this.previousDeleteColumns, "DELETE FROM " + this.tableName, null, false, " ", " WHERE ", 6058, 6060);
    }

    public PreparedStatement executeStatement(PreparedStatement preparedStatement, int[] nArray, String string, String string2, boolean bl, String string3, String string4, int n, int n2) throws SQLException {
        BaseColumn baseColumn;
        int n3;
        int n4 = 0;
        int n5 = this.getUpdatedValuesCount();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        n4 = this.columns.count(0);
        if (string4 != null) {
            n7 = this.columns.count(3);
            this.cacheKeyDataUpToColumn(n4 + 1);
        }
        if (this.statementNeedsBuilding(preparedStatement, nArray)) {
            n3 = 0;
            while (n3 < n4) {
                baseColumn = this.columns.get(n3 + 1);
                if (string2 != null && n3 < this.updatedValues.length && this.updatedValues[n3] != null) {
                    boolean bl2 = true;
                    if (bl) {
                        string = String.valueOf(string) + this.identifierQuote + UtilStringFunctions.trim(baseColumn.name, 2) + this.identifierQuote;
                    }
                    string = String.valueOf(string) + string2;
                    if (++n6 < n5 && bl2) {
                        string = String.valueOf(string) + ", ";
                    }
                }
                if (string4 != null && baseColumn.isKey) {
                    string4 = this.keyValues[n3].data == null ? String.valueOf(string4) + this.identifierQuote + UtilStringFunctions.trim(baseColumn.name, 2) + this.identifierQuote + " IS NULL " : String.valueOf(string4) + this.identifierQuote + UtilStringFunctions.trim(baseColumn.name, 2) + this.identifierQuote + " = ? ";
                    if (n8 < n7 - 1) {
                        string4 = String.valueOf(string4) + "and ";
                    }
                    ++n8;
                }
                ++n3;
            }
            String string5 = String.valueOf(string) + string3;
            if (string4 != null) {
                string5 = String.valueOf(string5) + string4;
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            preparedStatement = this.connection.prepareStatement(string5);
        }
        n6 = 0;
        n8 = 0;
        n3 = 0;
        while (n3 < n4) {
            baseColumn = this.columns.get(n3 + 1);
            if (string2 != null && n3 < this.updatedValues.length && this.updatedValues[n3] != null) {
                this.setParameter(preparedStatement, n6 + 1, this.updatedValues[n3], baseColumn, false);
                ++n6;
            }
            if (string4 != null && this.keyValues[n3] != null && baseColumn.isKey && this.keyValues[n3].data != null) {
                this.setParameter(preparedStatement, n5 + n8 + 1, this.keyValues[n3], baseColumn, true);
                ++n8;
            }
            ++n3;
        }
        this.cacheBoundColumns(nArray);
        int n9 = 0;
        try {
            n9 = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 0, n);
        }
        if (n9 > 1) {
            String[] stringArray = new String[]{Integer.toString(n9)};
            this.warnings.add(n2, stringArray);
        } else if (n9 != 1) {
            throw this.implStatement.implConnection.exceptions.getException(n);
        }
        return preparedStatement;
    }

    public int getConcurrency() {
        return 1008;
    }

    public BaseData getData(int n, int n2) throws SQLException {
        if (this.subImplResultSet.getColumnAccess() == 1) {
            this.cacheKeyDataUpToColumn(n);
        }
        BaseData baseData = this.subImplResultSet.getData(n, n2);
        this.setupKeyValues();
        this.keyValues[n - 1] = baseData;
        return baseData;
    }

    private int getKeyValuesCount() {
        int n = 0;
        if (this.keyValues != null) {
            int n2 = 0;
            while (n2 < this.keyValues.length) {
                if (this.keyValues[n2] != null && this.keyValues[n2].data != null) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    private int getUpdatedValuesCount() {
        int n = 0;
        if (this.updatedValues != null) {
            int n2 = 0;
            while (n2 < this.updatedValues.length) {
                if (this.updatedValues[n2] != null) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public void insertRow() throws SQLException {
        this.setupPreviousColumnsLists();
        String string = "INSERT INTO " + this.tableName;
        this.setupUpdatedValues();
        int n = this.columns.count(1);
        boolean bl = false;
        if (this.getUpdatedValuesCount() == 0) {
            switch (this.connection.getEmptyRowInsertSyntax()) {
                case 1: {
                    string = String.valueOf(string) + " default values";
                    break;
                }
                case 2: {
                    string = String.valueOf(string) + " values ()";
                    break;
                }
                case 3: {
                    string = String.valueOf(string) + " values (";
                    int n2 = this.columns.count(0);
                    int n3 = 0;
                    while (n3 < n2) {
                        if (n3 != 0) {
                            string = String.valueOf(string) + ",";
                        }
                        string = String.valueOf(string) + "default";
                        ++n3;
                    }
                    string = String.valueOf(string) + " )";
                    break;
                }
                default: {
                    throw this.implStatement.implConnection.exceptions.getException(6077);
                }
            }
            this.insertStatement = this.executeStatement(this.insertStatement, this.previousInsertColumns, string, "", false, "", null, 6063, 0);
        } else {
            string = String.valueOf(string) + " (";
            int n4 = 0;
            while (n4 < n) {
                BaseColumn baseColumn = this.columns.get(n4 + 1);
                if (this.updatedValues[n4] != null) {
                    if (bl) {
                        string = String.valueOf(string) + ", ";
                    } else {
                        bl = true;
                    }
                    string = String.valueOf(string) + this.identifierQuote + baseColumn.name + this.identifierQuote;
                }
                ++n4;
            }
            string = String.valueOf(string) + ") VALUES (";
            this.insertStatement = this.executeStatement(this.insertStatement, this.previousInsertColumns, string, "? ", false, ")", null, 6063, 0);
        }
    }

    public boolean positionCursor(int n) throws SQLException {
        this.keyValues = null;
        this.updatedValues = null;
        boolean bl = this.subImplResultSet.positionCursor(n);
        return bl;
    }

    public void prepareInsertRow() throws SQLException {
        this.cancelUpdates();
        this.onInsertRow = true;
    }

    private void setParameter(PreparedStatement preparedStatement, int n, BaseData baseData, BaseColumn baseColumn, boolean bl) throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = null;
        BaseCharacterStreamWrapper baseCharacterStreamWrapper = null;
        switch (baseData.type) {
            case 1015: {
                baseInputStreamWrapper = (BaseInputStreamWrapper)baseData.getASCIIStream(-1, this.connection, this.implStatement.implConnection.exceptions);
                preparedStatement.setAsciiStream(n, (InputStream)baseInputStreamWrapper, (int)baseInputStreamWrapper.numTotalBytesInStream);
                break;
            }
            case 1016: 
            case 1017: 
            case 1018: {
                baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)baseData.getCharacterStreamReader(-1, this.connection, this.implStatement.implConnection.exceptions);
                preparedStatement.setCharacterStream(n, (Reader)baseCharacterStreamWrapper, (int)baseCharacterStreamWrapper.numTotalCharsInReader);
                break;
            }
            case 1014: {
                baseInputStreamWrapper = (BaseInputStreamWrapper)baseData.getBinaryStream(-1, this.connection, this.implStatement.implConnection.exceptions);
                preparedStatement.setBinaryStream(n, (InputStream)baseInputStreamWrapper, (int)baseInputStreamWrapper.numTotalBytesInStream);
                break;
            }
            case 1019: {
                preparedStatement.setNull(n, baseColumn.type);
                break;
            }
            default: {
                preparedStatement.setObject(n, baseData.data);
            }
        }
    }

    private void setupKeyValues() {
        if (this.keyValues == null) {
            this.keyValues = new BaseData[this.columns.count(0)];
        }
    }

    private void setupPreviousColumnsLists() {
        int n = this.columns.count(0) * 2 + 1;
        if (this.previousDeleteColumns == null) {
            this.previousDeleteColumns = new int[n];
            this.previousDeleteColumns[0] = 0;
        }
        if (this.previousInsertColumns == null) {
            this.previousInsertColumns = new int[n];
            this.previousInsertColumns[0] = 0;
        }
        if (this.previousUpdateColumns == null) {
            this.previousUpdateColumns = new int[n];
            this.previousUpdateColumns[0] = 0;
        }
    }

    private void setupUpdatedValues() {
        if (this.updatedValues == null) {
            this.updatedValues = new BaseData[this.columns.count(1)];
        }
    }

    private boolean statementNeedsBuilding(PreparedStatement preparedStatement, int[] nArray) {
        int n;
        int n2;
        if (preparedStatement == null) {
            return true;
        }
        if (nArray[0] != this.getUpdatedValuesCount() + this.getKeyValuesCount()) {
            return true;
        }
        if (this.updatedValues != null) {
            n2 = 0;
            while (n2 < this.updatedValues.length) {
                if (this.updatedValues[n2] != null) {
                    n = 0;
                    while (n < nArray[0]) {
                        if (nArray[n + 1] == n2) break;
                        ++n;
                    }
                    if (n == nArray[0]) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        if (this.keyValues != null) {
            n2 = 0;
            while (n2 < this.keyValues.length) {
                if (this.keyValues[n2] != null && this.keyValues[n2].data != null) {
                    n = 0;
                    while (n < nArray[0]) {
                        if (nArray[n + 1] == n2 + 10000) break;
                        ++n;
                    }
                    if (n == nArray[0]) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public void updateData(int n, BaseData baseData) throws SQLException {
        if (this.subImplResultSet.getColumnAccess() == 1 && !this.onInsertRow) {
            this.cacheKeyDataUpToColumn(n + 1);
        }
        this.setupUpdatedValues();
        this.updatedValues[n - 1] = baseData;
    }

    public void updateRow() throws SQLException {
        this.setupPreviousColumnsLists();
        this.setupUpdatedValues();
        this.updateStatement = this.executeStatement(this.updateStatement, this.previousUpdateColumns, "UPDATE " + this.tableName + " set ", " = ? ", true, "", "WHERE ", 6058, 6057);
    }
}

