/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.db.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.radrails.rails.internal.core.RailsPlugin;

public class DatabaseDescriptor {
    private static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    private static final String DEFAULT_HOST = "localhost";
    private String descriptorName;
    private String adapter;
    private String database;
    private String host;
    private String username;
    private String password;
    private String port;
    private String sslCert;
    private String sslCapath;
    private String sslCipher;
    private String socket;
    private String sslKey;
    private String schemaOrder;
    private String dbFile;
    private String driver;
    private String url;
    private IProject project;

    public DatabaseDescriptor(String name, IProject project) {
        this.project = project;
        this.descriptorName = name;
        this.adapter = "";
        this.database = "";
        this.host = DEFAULT_HOST;
        this.username = "";
        this.password = "";
        this.port = "";
        this.socket = "";
        this.sslCert = "";
        this.sslCapath = "";
        this.sslKey = "";
        this.schemaOrder = "";
        this.dbFile = "";
        this.url = "";
        this.driver = "";
    }

    public IProject getProject() {
        return this.project;
    }

    public String getName() {
        return this.descriptorName;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getHost() {
        if (this.host == null || this.host.trim().equals("")) {
            this.host = DEFAULT_HOST;
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getDBFile() {
        return this.dbFile;
    }

    public void setDBFile(String dbfile) {
        this.dbFile = dbfile;
    }

    public String getPort() {
        if (this.port == null || this.port.trim().equals("")) {
            if (this.isMySQL()) {
                return "3306";
            }
            if (this.isIBMDB2()) {
                return "50000";
            }
            if (this.isOracle()) {
                return "1521";
            }
            if (this.isPostgresql()) {
                return "5432";
            }
            if (this.isSQLServer()) {
                return "1433";
            }
        }
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getSchemaOrder() {
        return this.schemaOrder;
    }

    public void setSchemaOrder(String schema_order) {
        this.schemaOrder = schema_order;
    }

    public String getSocket() {
        return this.socket;
    }

    public void setSocket(String socket) {
        this.socket = socket;
    }

    public String getSSLCapath() {
        return this.sslCapath;
    }

    public void setSSLCapath(String sslcapath) {
        this.sslCapath = sslcapath;
    }

    public String getSSLCert() {
        return this.sslCert;
    }

    public void setSSLCert(String sslcert) {
        this.sslCert = sslcert;
    }

    public String getSSLCipher() {
        return this.sslCipher;
    }

    public void setSSLCipher(String sslcipher) {
        this.sslCipher = sslcipher;
    }

    public String getSSLKey() {
        return this.sslKey;
    }

    public void setSSLKey(String sslkey) {
        this.sslKey = sslkey;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriver() {
        if (this.driver == null || this.driver.trim().equals("")) {
            return this.buildDriver();
        }
        return this.driver;
    }

    private String buildDriver() {
        if (this.isMySQL()) {
            return MYSQL_DRIVER;
        }
        if (this.isODBC()) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        if (this.isOracle()) {
            return "oracle.jdbc.driver.OracleDriver";
        }
        if (this.isPostgresql()) {
            return "org.postgresql.Driver";
        }
        if (this.isSQLServer()) {
            return "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        }
        if (this.isIBMDB2()) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        if (this.isSQLite()) {
            return "org.sqlite.JDBC";
        }
        return "";
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUrl() {
        if (this.url == null || this.url.trim().equals("")) {
            return this.buildURL();
        }
        return this.url;
    }

    private String buildURL() {
        if (this.isSQLite()) {
            String file = this.getDBFile();
            if (file == null || file.trim().length() == 0) {
                file = this.getDatabase();
            }
            IPath root = RailsPlugin.findRailsRoot((IProject)this.project);
            file = this.project.getLocation().append(root).append(file).toOSString();
            return "jdbc:sqlite:" + file;
        }
        String extra = "";
        if (this.isMySQL()) {
            extra = "?zeroDateTimeBehavior=convertToNull";
        }
        return String.valueOf(this.getConnectFragment()) + this.getHost() + ":" + this.getPort() + "/" + this.getDatabase() + extra;
    }

    private String getConnectFragment() {
        String connect = "jdbc:" + this.getAdapter() + "://";
        if (this.isOracle()) {
            connect = "jdbc:oracle:thin:@";
        } else if (this.isSQLServer()) {
            connect = "jdbc:Microsoft:sqlserver://";
        } else if (this.isODBC()) {
            connect = "jdbc:odbc:";
        }
        return connect;
    }

    public boolean isODBC() {
        return this.getAdapter().equals("odbc");
    }

    public boolean isSQLServer() {
        return this.getAdapter().equals("sqlserver");
    }

    public boolean isSQLite() {
        return this.getAdapter().equals("sqlite") || this.getAdapter().equals("sqlite3");
    }

    public boolean isPostgresql() {
        return this.getAdapter().equals("postgresql");
    }

    public boolean isOracle() {
        return this.getAdapter().equals("oci");
    }

    public boolean isIBMDB2() {
        return this.getAdapter().equals("db2");
    }

    public boolean isMySQL() {
        return this.getAdapter().equals("mysql");
    }

    public String toYML() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append(":\n");
        builder.append("  adapter: ").append(this.getAdapter()).append("\n");
        builder.append("  username: ").append(this.getUsername()).append("\n");
        builder.append("  password: ").append(this.getPassword()).append("\n");
        builder.append("  host: ").append(this.getHost()).append("\n");
        builder.append("  database: ").append(this.getDatabase()).append("\n");
        return builder.toString();
    }
}

