/*
 * Decompiled with CFR 0.152.
 */
package org.kxml2.wap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WbxmlParser
implements XmlPullParser {
    public static final int WAP_EXTENSION = 64;
    private static final String UNEXPECTED_EOF = "Unexpected EOF";
    private static final String ILLEGAL_TYPE = "Wrong event type";
    private InputStream in;
    private String[] attrStartTable;
    private String[] attrValueTable;
    private String[] tagTable;
    private String stringTable;
    private boolean processNsp;
    private int depth;
    private String[] elementStack = new String[16];
    private String[] nspStack = new String[8];
    private int[] nspCounts = new int[4];
    private int attributeCount;
    private String[] attributes = new String[16];
    private int nextId = -2;
    int version;
    int publicIdentifierId;
    int charSet;
    private String prefix;
    private String namespace;
    private String name;
    private String text;
    private Object wapExtensionData;
    private int wapExtensionCode;
    private int type;
    private boolean degenerated;
    private boolean isWhitespace;

    public boolean getFeature(String feature) {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(feature)) {
            return this.processNsp;
        }
        return false;
    }

    public String getInputEncoding() {
        return null;
    }

    public void defineEntityReplacementText(String entity, String value) throws XmlPullParserException {
    }

    public Object getProperty(String property) {
        return null;
    }

    public int getNamespaceCount(int depth) {
        if (depth > this.depth) {
            throw new IndexOutOfBoundsException();
        }
        return this.nspCounts[depth];
    }

    public String getNamespacePrefix(int pos) {
        return this.nspStack[pos << 1];
    }

    public String getNamespaceUri(int pos) {
        return this.nspStack[(pos << 1) + 1];
    }

    public String getNamespace(String prefix) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        int i = (this.getNamespaceCount(this.depth) << 1) - 2;
        while (i >= 0) {
            if (prefix == null ? this.nspStack[i] == null : prefix.equals(this.nspStack[i])) {
                return this.nspStack[i + 1];
            }
            i -= 2;
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getPositionDescription() {
        StringBuffer buf = new StringBuffer(this.type < TYPES.length ? TYPES[this.type] : "unknown");
        buf.append(' ');
        if (this.type == 2 || this.type == 3) {
            if (this.degenerated) {
                buf.append("(empty) ");
            }
            buf.append('<');
            if (this.type == 3) {
                buf.append('/');
            }
            if (this.prefix != null) {
                buf.append("{" + this.namespace + "}" + this.prefix + ":");
            }
            buf.append(this.name);
            int cnt = this.attributeCount << 2;
            int i = 0;
            while (i < cnt) {
                buf.append(' ');
                if (this.attributes[i + 1] != null) {
                    buf.append("{" + this.attributes[i] + "}" + this.attributes[i + 1] + ":");
                }
                buf.append(String.valueOf(this.attributes[i + 2]) + "='" + this.attributes[i + 3] + "'");
                i += 4;
            }
            buf.append('>');
        } else if (this.type != 7) {
            if (this.type != 4) {
                buf.append(this.getText());
            } else if (this.isWhitespace) {
                buf.append("(whitespace)");
            } else {
                String text = this.getText();
                if (text.length() > 16) {
                    text = String.valueOf(text.substring(0, 16)) + "...";
                }
                buf.append(text);
            }
        }
        return buf.toString();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.type != 4 && this.type != 7 && this.type != 5) {
            this.exception(ILLEGAL_TYPE);
        }
        return this.isWhitespace;
    }

    public String getText() {
        return this.text;
    }

    public char[] getTextCharacters(int[] poslen) {
        if (this.type >= 4) {
            poslen[0] = 0;
            poslen[1] = this.text.length();
            char[] buf = new char[this.text.length()];
            this.text.getChars(0, this.text.length(), buf, 0);
            return buf;
        }
        poslen[0] = -1;
        poslen[1] = -1;
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.type != 2) {
            this.exception(ILLEGAL_TYPE);
        }
        return this.degenerated;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public String getAttributeNamespace(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[index << 2];
    }

    public String getAttributeName(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(index << 2) + 2];
    }

    public String getAttributePrefix(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(index << 2) + 1];
    }

    public String getAttributeValue(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(index << 2) + 3];
    }

    public String getAttributeValue(String namespace, String name) {
        int i = (this.attributeCount << 2) - 4;
        while (i >= 0) {
            if (this.attributes[i + 2].equals(name) && (namespace == null || this.attributes[i].equals(namespace))) {
                return this.attributes[i + 3];
            }
            i -= 4;
        }
        return null;
    }

    public int getEventType() throws XmlPullParserException {
        return this.type;
    }

    public int next() throws XmlPullParserException, IOException {
        this.isWhitespace = true;
        int minType = 9999;
        block3: while (true) {
            String save = this.text;
            this.nextImpl();
            if (this.type < minType) {
                minType = this.type;
            }
            if (minType > 5) continue;
            if (minType < 4) break;
            if (save != null) {
                this.text = this.text != null ? save : String.valueOf(save) + this.text;
            }
            switch (this.peekId()) {
                case 2: 
                case 3: 
                case 4: 
                case 68: 
                case 132: 
                case 196: {
                    continue block3;
                }
            }
            break;
        }
        this.type = minType;
        if (this.type > 4) {
            this.type = 4;
        }
        return this.type;
    }

    public int nextToken() throws XmlPullParserException, IOException {
        this.isWhitespace = true;
        this.nextImpl();
        return this.type;
    }

    public int nextTag() throws XmlPullParserException, IOException {
        this.next();
        if (this.type == 4 && this.isWhitespace) {
            this.next();
        }
        if (this.type != 3 && this.type != 2) {
            this.exception("unexpected type");
        }
        return this.type;
    }

    public String nextText() throws XmlPullParserException, IOException {
        String result;
        if (this.type != 2) {
            this.exception("precondition: START_TAG");
        }
        this.next();
        if (this.type == 4) {
            result = this.getText();
            this.next();
        } else {
            result = "";
        }
        if (this.type != 3) {
            this.exception("END_TAG expected");
        }
        return result;
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (type != this.type || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            this.exception("expected: " + TYPES[type] + " {" + namespace + "}" + name);
        }
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        this.exception("InputStream required");
    }

    public void setInput(InputStream in, String enc) throws XmlPullParserException {
        this.in = in;
        try {
            this.version = this.readByte();
            this.publicIdentifierId = this.readInt();
            if (this.publicIdentifierId == 0) {
                this.readInt();
            }
            this.charSet = this.readInt();
            int strTabSize = this.readInt();
            StringBuffer buf = new StringBuffer(strTabSize);
            int i = 0;
            while (i < strTabSize) {
                buf.append((char)this.readByte());
                ++i;
            }
            this.stringTable = buf.toString();
        }
        catch (IOException iOException) {
            this.exception("Illegal input format");
        }
    }

    public void setFeature(String feature, boolean value) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(feature)) {
            this.processNsp = value;
        } else {
            this.exception("unsupported feature: " + feature);
        }
    }

    public void setProperty(String property, Object value) throws XmlPullParserException {
        throw new XmlPullParserException("unsupported property: " + property);
    }

    private final boolean adjustNsp() throws XmlPullParserException {
        int cut;
        int cut2;
        String attrName;
        boolean any = false;
        int i = 0;
        while (i < this.attributeCount << 2) {
            block21: {
                String prefix;
                block20: {
                    block19: {
                        attrName = this.attributes[i + 2];
                        cut2 = attrName.indexOf(58);
                        if (cut2 == -1) break block19;
                        prefix = attrName.substring(0, cut2);
                        attrName = attrName.substring(cut2 + 1);
                        break block20;
                    }
                    if (!attrName.equals("xmlns")) break block21;
                    prefix = attrName;
                    attrName = null;
                }
                if (!prefix.equals("xmlns")) {
                    any = true;
                } else {
                    int n = this.depth;
                    int n2 = this.nspCounts[n];
                    this.nspCounts[n] = n2 + 1;
                    int j = n2 << 1;
                    this.nspStack = this.ensureCapacity(this.nspStack, j + 2);
                    this.nspStack[j] = attrName;
                    this.nspStack[j + 1] = this.attributes[i + 3];
                    if (attrName != null && this.attributes[i + 3].equals("")) {
                        this.exception("illegal empty namespace");
                    }
                    System.arraycopy(this.attributes, i + 4, this.attributes, i, (--this.attributeCount << 2) - i);
                    i -= 4;
                }
            }
            i += 4;
        }
        if (any) {
            i = (this.attributeCount << 2) - 4;
            while (i >= 0) {
                attrName = this.attributes[i + 2];
                cut2 = attrName.indexOf(58);
                if (cut2 == 0) {
                    throw new RuntimeException("illegal attribute name: " + attrName + " at " + this);
                }
                if (cut2 != -1) {
                    String attrPrefix = attrName.substring(0, cut2);
                    attrName = attrName.substring(cut2 + 1);
                    String attrNs = this.getNamespace(attrPrefix);
                    if (attrNs == null) {
                        throw new RuntimeException("Undefined Prefix: " + attrPrefix + " in " + this);
                    }
                    this.attributes[i] = attrNs;
                    this.attributes[i + 1] = attrPrefix;
                    this.attributes[i + 2] = attrName;
                    int j = (this.attributeCount << 2) - 4;
                    while (j > i) {
                        if (attrName.equals(this.attributes[j + 2]) && attrNs.equals(this.attributes[j])) {
                            this.exception("Duplicate Attribute: {" + attrNs + "}" + attrName);
                        }
                        j -= 4;
                    }
                }
                i -= 4;
            }
        }
        if ((cut = this.name.indexOf(58)) == 0) {
            this.exception("illegal tag name: " + this.name);
        } else if (cut != -1) {
            this.prefix = this.name.substring(0, cut);
            this.name = this.name.substring(cut + 1);
        }
        this.namespace = this.getNamespace(this.prefix);
        if (this.namespace == null) {
            if (this.prefix != null) {
                this.exception("undefined prefix: " + this.prefix);
            }
            this.namespace = "";
        }
        return any;
    }

    private final void exception(String desc) throws XmlPullParserException {
        throw new XmlPullParserException(desc, this, null);
    }

    private final void nextImpl() throws IOException, XmlPullParserException {
        if (this.type == 3) {
            --this.depth;
        }
        if (this.degenerated) {
            this.type = 3;
            return;
        }
        this.text = null;
        this.prefix = null;
        this.name = null;
        int id = this.peekId();
        this.nextId = -2;
        switch (id) {
            case -1: {
                this.type = 1;
                break;
            }
            case 0: {
                if (this.readByte() == 0) break;
                throw new IOException("Curr. only CP0 supported");
            }
            case 1: {
                int sp = this.depth - 1 << 2;
                this.type = 3;
                this.namespace = this.elementStack[sp];
                this.prefix = this.elementStack[sp + 1];
                this.name = this.elementStack[sp + 2];
                break;
            }
            case 2: {
                this.type = 6;
                char c = (char)this.readInt();
                this.text = "" + c;
                this.name = "#" + c;
                break;
            }
            case 3: {
                this.type = 4;
                this.text = this.readStrI();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 128: 
            case 129: 
            case 130: 
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                this.parseWapExtension(id);
                break;
            }
            case 67: {
                throw new RuntimeException("PI curr. not supp.");
            }
            case 131: {
                this.type = 4;
                int pos = this.readInt();
                int end = this.stringTable.indexOf(0, pos);
                this.text = this.stringTable.substring(pos, end);
                break;
            }
            default: {
                this.parseElement(id);
            }
        }
    }

    public void parseWapExtension(int id) throws IOException, XmlPullParserException {
        this.type = 64;
        this.wapExtensionCode = id;
        switch (id) {
            case 64: 
            case 65: 
            case 66: {
                this.wapExtensionData = this.readStrI();
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                this.wapExtensionData = new Integer(this.readInt());
                break;
            }
            case 192: 
            case 193: 
            case 194: {
                break;
            }
            case 195: {
                int len = this.readInt();
                byte[] buf = new byte[len];
                int i = 0;
                while (i < len) {
                    buf[i] = (byte)this.readByte();
                    ++i;
                }
                this.wapExtensionData = buf;
            }
        }
        throw new IOException("illegal id!");
    }

    public void readAttr() throws IOException {
        int id = this.readByte();
        int i = 0;
        while (id != 1) {
            StringBuffer value;
            String name = this.resolveId(this.attrStartTable, id);
            int cut = name.indexOf(61);
            if (cut == -1) {
                value = new StringBuffer();
            } else {
                value = new StringBuffer(name.substring(cut + 1));
                name = name.substring(0, cut);
            }
            id = this.readByte();
            while (id > 128 || id == 2 || id == 3 || id == 131 || id >= 64 && id <= 66 || id >= 128 && id <= 130) {
                switch (id) {
                    case 2: {
                        value.append((char)this.readInt());
                        break;
                    }
                    case 3: {
                        value.append(this.readStrI());
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: {
                        throw new RuntimeException("wap extension in attr not supported yet");
                    }
                    case 131: {
                        value.append(this.readStrT());
                        break;
                    }
                    default: {
                        value.append(this.resolveId(this.attrValueTable, id));
                    }
                }
                id = this.readByte();
            }
            this.attributes = this.ensureCapacity(this.attributes, i + 4);
            this.attributes[i++] = "";
            this.attributes[i++] = null;
            this.attributes[i++] = name;
            this.attributes[i++] = value.toString();
        }
    }

    private int peekId() throws IOException {
        if (this.nextId == -2) {
            this.nextId = this.in.read();
        }
        return this.nextId;
    }

    String resolveId(String[] tab, int id) throws IOException {
        int idx = (id & 0x7F) - 5;
        if (idx == -1) {
            return this.readStrT();
        }
        if (idx < 0 || tab == null || idx >= tab.length || tab[idx] == null) {
            throw new IOException("id " + id + " undef.");
        }
        return tab[idx];
    }

    void parseElement(int id) throws IOException, XmlPullParserException {
        this.name = this.resolveId(this.tagTable, id & 0x3F);
        if ((id & 0x80) != 0) {
            this.readAttr();
        }
        this.degenerated = (id & 0x40) == 0;
        int sp = this.depth++ << 2;
        this.elementStack = this.ensureCapacity(this.elementStack, sp + 4);
        this.elementStack[sp + 3] = this.name;
        int i = this.attributeCount - 1;
        while (i > 0) {
            int j = 0;
            while (j < i) {
                if (this.getAttributeName(i).equals(this.getAttributeName(j))) {
                    this.exception("Duplicate Attribute: " + this.getAttributeName(i));
                }
                ++j;
            }
            --i;
        }
        if (this.processNsp) {
            this.adjustNsp();
        } else {
            this.namespace = "";
        }
        this.elementStack[sp] = this.namespace;
        this.elementStack[sp + 1] = this.prefix;
        this.elementStack[sp + 2] = this.name;
    }

    private final String[] ensureCapacity(String[] arr, int required) {
        if (arr.length >= required) {
            return arr;
        }
        String[] bigger = new String[required + 16];
        System.arraycopy(arr, 0, bigger, 0, arr.length);
        return bigger;
    }

    int readByte() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IOException(UNEXPECTED_EOF);
        }
        return i;
    }

    int readInt() throws IOException {
        int i;
        int result = 0;
        do {
            i = this.readByte();
            result = result << 7 | i & 0x7F;
        } while ((i & 0x80) != 0);
        return result;
    }

    String readStrI() throws IOException {
        StringBuffer buf = new StringBuffer();
        boolean wsp = true;
        while (true) {
            int i;
            if ((i = this.in.read()) == -1) {
                throw new IOException(UNEXPECTED_EOF);
            }
            if (i == 0) break;
            if (i > 32) {
                wsp = false;
            }
            buf.append((char)i);
        }
        this.isWhitespace = wsp;
        return buf.toString();
    }

    String readStrT() throws IOException {
        int pos = this.readInt();
        int end = this.stringTable.indexOf(0, pos);
        return this.stringTable.substring(pos, end);
    }

    public void setTagTable(int page, String[] tagTable) {
        this.tagTable = tagTable;
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrStartTable(int page, String[] attrStartTable) {
        this.attrStartTable = attrStartTable;
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrValueTable(int page, String[] attrStartTable) {
        this.attrValueTable = attrStartTable;
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }
}

