/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;
import org.radrails.rails.internal.ui.RailsConsoleLine;
import org.radrails.rails.ui.RailsUILog;

public class RailsConsoleHyperlink
implements IHyperlink {
    private IConsole fConsole;
    private RailsConsoleLine fLine;

    public RailsConsoleHyperlink(IConsole console, RailsConsoleLine line) {
        this.fConsole = console;
        this.fLine = line;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        ILaunch launch = this.getConsole().getProcess().getLaunch();
        if (launch == null) {
            return;
        }
        String filename = this.getFilename();
        try {
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filename)));
        }
        catch (CoreException e) {
            RailsUILog.logError((String)"Could not open editor or set line in editor", (Throwable)e);
        }
    }

    public int getLineNumber() {
        return this.fLine.getLineNumber();
    }

    public String getFilename() {
        return this.fLine.getFilename();
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws BadLocationException {
        IRegion region = this.getConsole().getRegion((IHyperlink)this);
        return this.getConsole().getDocument().get(region.getOffset(), region.getLength());
    }
}

