/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.radrails.rails.internal.ui.RailsConsoleHyperlink;
import org.radrails.rails.internal.ui.generators.GeneratorsConsoleLine;
import org.radrails.rails.ui.RailsUILog;
import org.rubypeople.rdt.internal.debug.ui.console.RubyConsoleTracker;

public class RailsConsoleTracker
extends RubyConsoleTracker {
    public void lineAppended(IRegion line) {
        try {
            int prefix = 0;
            String text = this.getText(line);
            while (GeneratorsConsoleLine.isMatching(text)) {
                IProject project = this.getProject();
                if (project == null) {
                    return;
                }
                GeneratorsConsoleLine consoleLine = new GeneratorsConsoleLine(text, project);
                RailsConsoleHyperlink link = new RailsConsoleHyperlink(this.fConsole, consoleLine);
                this.fConsole.addLink((IHyperlink)link, line.getOffset() + prefix + consoleLine.getOffset(), consoleLine.getLength());
                prefix = consoleLine.getOffset() + consoleLine.getLength();
                int substring = consoleLine.getOffset() + consoleLine.getLength();
                if (substring >= text.length()) {
                    text = "";
                    continue;
                }
                if (substring <= 0 || !(text = text.substring(substring)).startsWith(":in `require':")) continue;
                text = text.substring(14);
                prefix += 14;
            }
        }
        catch (BadLocationException e) {
            RailsUILog.logError((String)"Error hyperlinking console line", (Throwable)e);
        }
    }
}

