/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.ui.RailsUIPlugin;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;

public class RailsProjectListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        if (event.getType() == 4) {
            IProject project = (IProject)event.getResource();
            if (RailsPlugin.hasRailsNature((IProject)project)) {
                this.railsProjectRemoved(project);
            }
            return;
        }
        if (event.getType() == 1) {
            IResourceDelta delta = event.getDelta();
            this.checkDelta(delta);
        }
    }

    private void railsProjectRemoved(IProject project) {
        this.cleanProfile(project.getLocation());
    }

    private void cleanProfile(IPath path) {
        String profilePath = path.toFile().toURI().toString();
        if (profilePath.endsWith("/") || profilePath.endsWith("\\")) {
            profilePath = profilePath.substring(0, profilePath.length() - 1);
        }
        UnifiedEditorsPlugin.getDefault().getProfileManager().removeProfile(profilePath);
    }

    private void checkDelta(IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        IResource resource = delta.getResource();
        if (!(resource instanceof IContainer)) {
            return;
        }
        if (resource instanceof IProject || resource instanceof IFolder) {
            if (2 == delta.getKind()) {
                return;
            }
            IContainer rootFolder = (IContainer)resource;
            IProject project = rootFolder.getProject();
            if (RailsPlugin.hasRailsNature((IProject)project)) {
                return;
            }
            if (this.hasRailsLayout(rootFolder)) {
                RailsNatureAdder job = new RailsNatureAdder(project);
                job.schedule(500L);
                return;
            }
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.checkDelta(children[i]);
            ++i;
        }
    }

    private boolean hasRailsLayout(IContainer folder) {
        return this.folderExists(folder, "app") && this.folderExists(folder, "lib") && this.folderExists(folder, "script") && this.folderExists(folder, "db") && this.folderExists(folder, "vendor") && this.folderExists(folder, "config") && this.folderExists(folder, "public") && this.folderExists(folder, "test");
    }

    private boolean folderExists(IContainer rootFolder, String name) {
        IFolder folder = rootFolder.getFolder((IPath)new Path(name));
        return folder != null && folder.exists();
    }

    private static class RailsNatureAdder
    extends Job {
        private IProject project;

        public RailsNatureAdder(IProject project) {
            super("Add Rails Nature");
            this.project = project;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                RailsPlugin.addRailsNature((IProject)this.project, (IProgressMonitor)monitor);
                IRubyProject rubyProject = RubyCore.create((IProject)this.project);
                if (!RailsUIPlugin.hasRailsFrozenInVendor(rubyProject)) {
                    RailsUIPlugin.addDefaultRailsLoadpaths(rubyProject, monitor);
                }
                RailsUIPlugin.overrideDocumentRoot(this.project);
            }
            catch (CoreException e) {
                RailsLog.log((CoreException)e);
            }
            return Status.OK_STATUS;
        }
    }
}

