/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.actions.mvc;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.radrails.rails.internal.core.RailsPlugin;

public abstract class MVCEditorActionDelegate
implements IEditorActionDelegate {
    private IFile currentFile = null;
    private IEditorPart activeEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
        this.getCurrentFile(targetEditor);
        this.setEnabled(action);
    }

    protected IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    private void getCurrentFile(IEditorPart targetEditor) {
        IEditorPart part = targetEditor;
        if (part == null) {
            return;
        }
        IEditorInput input = part.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return;
        }
        this.currentFile = ((IFileEditorInput)input).getFile();
    }

    protected IFile getCurrentFile() {
        return this.currentFile;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void setEnabled(IAction action) {
        IFile currentFile = this.getCurrentFile();
        if (currentFile == null || !RailsPlugin.hasRailsNature((IProject)currentFile.getProject())) {
            action.setEnabled(false);
            return;
        }
        action.setEnabled(this.isEnabled());
    }

    protected abstract boolean isEnabled();
}

