/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.autotest;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PlatformUI;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.RailsUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutotestHelper {
    private static IFile editorFile;

    public static boolean runAutotestOnSave() {
        return RailsUIPlugin.getInstance().getPreferenceStore().getBoolean("rails.ui.test.autotest.run_on_save");
    }

    public static boolean runAutotestOnInterval() {
        return RailsUIPlugin.getInstance().getPreferenceStore().getBoolean("rails.ui.test.autotest.run_on_interval");
    }

    public static int getAutotestIntervalLength() {
        return RailsUIPlugin.getInstance().getPreferenceStore().getInt("rails.ui.test.autotest.interval_length");
    }

    public static IFile getActiveEditorFile() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (part != null) {
                    IEditorInput input = part.getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        IFileEditorInput fei = (IFileEditorInput)part.getEditorInput();
                        editorFile = fei.getFile();
                    } else if (input instanceof IPathEditorInput) {
                        IPathEditorInput pei = (IPathEditorInput)part.getEditorInput();
                        try {
                            editorFile = ResourcesPlugin.getWorkspace().getRoot().getFile(pei.getPath());
                        }
                        catch (Exception e) {
                            RailsUILog.logError((String)"Error obtaining file based on path editor input", (Throwable)e);
                        }
                    }
                }
            }
        });
        return editorFile;
    }

    public static List<String> getTests(IProject project, IPath srcFile) {
        List<String> tests = null;
        tests = AutotestHelper.testsForModel(project, srcFile);
        if (tests != null) {
            return tests;
        }
        tests = AutotestHelper.testsForController(project, srcFile);
        if (tests != null) {
            return tests;
        }
        tests = AutotestHelper.testsForPlugin(project, srcFile);
        if (tests != null) {
            return tests;
        }
        return new ArrayList<String>();
    }

    private static List<String> testsForModel(IProject project, IPath file) {
        ArrayList<String> tests = new ArrayList<String>();
        String srcDir = "app/models";
        String destDir = "test/unit";
        String destSuffix = "_test";
        String filepath = file.toString();
        Matcher m = Pattern.compile("^((?:.+?/)?)" + srcDir + "/(.+)" + "\\.rb$").matcher(filepath);
        if (!m.matches() && !(m = Pattern.compile("^((?:.+?/)?)" + destDir + "/(.+)" + destSuffix + "\\.rb$").matcher(filepath)).matches()) {
            return null;
        }
        IPreferenceStore prefStore = RailsUIPlugin.getInstance().getPreferenceStore();
        if (prefStore.getBoolean("rails.ui.test.autotest.model.assoc_unit")) {
            IPath thePath = project.getProjectRelativePath().append(String.valueOf(m.group(1).length() == 0 ? "" : "/") + m.group(1) + "/" + destDir + "/" + m.group(2) + destSuffix + ".rb");
            if (project.getLocation().append(thePath).toFile().exists()) {
                tests.add(thePath.toOSString());
            }
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.model.all_unit")) {
            tests.add(RailsPlugin.getInstance().getRubyScriptPath("run_unit.rb"));
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.model.all_functional")) {
            tests.add(RailsPlugin.getInstance().getRubyScriptPath("run_functional.rb"));
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.model.all_integration")) {
            tests.add(RailsPlugin.getInstance().getRubyScriptPath("run_integration.rb"));
        }
        return tests;
    }

    private static List<String> testsForController(IProject project, IPath file) {
        ArrayList<String> tests = new ArrayList<String>();
        String srcDir = "app/controllers";
        String destDir = "test/functional";
        String destSuffix = "_test";
        String filepath = file.toString();
        Matcher m = Pattern.compile("^((?:.+?/)?)" + srcDir + "/(.+)" + "\\.rb$").matcher(filepath);
        if (!m.matches() && !(m = Pattern.compile("^((?:.+?/)?)" + destDir + "/(.+)" + destSuffix + "\\.rb$").matcher(filepath)).matches()) {
            return null;
        }
        IPreferenceStore prefStore = RailsUIPlugin.getInstance().getPreferenceStore();
        if (prefStore.getBoolean("rails.ui.test.autotest.controller.assoc_functional")) {
            IPath thePath = project.getProjectRelativePath().append(String.valueOf(m.group(1).length() == 0 ? "" : "/") + m.group(1) + "/" + destDir + "/" + m.group(2) + destSuffix + ".rb");
            if (project.getLocation().append(thePath).toFile().exists()) {
                tests.add(thePath.toOSString());
            }
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.controller.all_unit")) {
            tests.add(RailsPlugin.getInstance().getRubyScriptPath("run_unit.rb"));
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.controller.all_functional")) {
            tests.add(RailsPlugin.getInstance().getRubyScriptPath("run_functional.rb"));
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.controller.all_integration")) {
            tests.add(RailsPlugin.getInstance().getRubyScriptPath("run_integration.rb"));
        }
        return tests;
    }

    private static List<String> testsForPlugin(IProject project, IPath file) {
        IPath thePath;
        ArrayList<String> tests = new ArrayList<String>();
        String srcDir = "vendor/plugins";
        String destDir = "vendor/plugins";
        String destSuffix = "_test";
        String filepath = file.toString();
        Matcher m = Pattern.compile("^((?:.+?/)?)" + srcDir + "/(.+?/)lib/(.+)" + "\\.rb$").matcher(filepath);
        if (!m.matches() && !(m = Pattern.compile("^((?:.+?/)?)" + destDir + "/(.+?/)lib/(.+)" + destSuffix + "\\.rb$").matcher(filepath)).matches()) {
            return null;
        }
        IPreferenceStore prefStore = RailsUIPlugin.getInstance().getPreferenceStore();
        if (prefStore.getBoolean("rails.ui.test.autotest.plugin.assoc")) {
            thePath = project.getProjectRelativePath().append(String.valueOf(m.group(1).length() == 0 ? "" : "/") + m.group(1) + "/" + destDir + "/" + m.group(2) + "test" + "/" + m.group(3) + destSuffix + ".rb");
            if (project.getLocation().append(thePath).toFile().exists()) {
                tests.add(thePath.toOSString());
            }
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.plugin.all")) {
            thePath = project.getLocation().append(String.valueOf(m.group(1).length() == 0 ? "" : "/") + m.group(1) + "/" + destDir + "/" + m.group(2) + "test" + "/");
            System.out.println("plugin test path=" + thePath.toString());
            File[] testFiles = thePath.toFile().listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith("_test.rb");
                }
            });
            if (testFiles != null) {
                int i = 0;
                while (i < testFiles.length) {
                    tests.add(testFiles[i].toString());
                    ++i;
                }
            }
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.plugin.all_unit")) {
            tests.add(RailsPlugin.getInstance().getRubyScriptPath("run_unit.rb"));
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.plugin.all_functional")) {
            tests.add(RailsPlugin.getInstance().getRubyScriptPath("run_functional.rb"));
        }
        if (prefStore.getBoolean("rails.ui.test.autotest.plugin.all_integration")) {
            tests.add(RailsPlugin.getInstance().getRubyScriptPath("run_integration.rb"));
        }
        return tests;
    }
}

