/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.autotest;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.autotest.AutotestHelper;
import org.radrails.rails.internal.ui.autotest.IAutotestRunListener;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.test.TestLauncher;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitView;
import org.rubypeople.rdt.internal.testunit.ui.TestunitPlugin;
import org.rubypeople.rdt.testunit.ITestRunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutotestManager
implements IResourceChangeListener,
IPropertyChangeListener,
ITestRunListener {
    private Collection<IAutotestRunListener> fRunListeners;
    private AutotestThread fAutotestThread;
    private TestUnitView view;
    private IResourceDeltaVisitor fDeltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) throws CoreException {
            switch (delta.getKind()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    if ((delta.getFlags() & 0x100) != 256 || delta.getResource() == null || !(delta.getResource() instanceof IFile)) break;
                    IFile changedFile = (IFile)delta.getResource();
                    IFile activeEditorFile = AutotestHelper.getActiveEditorFile();
                    if (!changedFile.getLocation().equals((Object)activeEditorFile.getLocation()) || !changedFile.getFileExtension().equals("rb")) break;
                    AutotestManager.this.attemptTestLaunch(delta.getResource());
                }
            }
            return true;
        }
    };
    private boolean fTestsPass;

    public AutotestManager() {
        this.fRunListeners = new ArrayList<IAutotestRunListener>();
        if (AutotestHelper.runAutotestOnInterval()) {
            this.fAutotestThread = new AutotestThread();
            this.fAutotestThread.start();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        boolean runOnSave = AutotestHelper.runAutotestOnSave();
        try {
            IResourceDelta delta;
            if (runOnSave && (delta = event.getDelta()) != null) {
                delta.accept(this.fDeltaVisitor);
            }
        }
        catch (CoreException e) {
            RailsUILog.logError((String)"Error launching tests", (Throwable)e);
        }
    }

    public void attemptTestLaunch(final IResource file) {
        Job j = new Job("Autotest suite"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Running autotest suite", 3);
                monitor.worked(1);
                List<String> tests = AutotestHelper.getTests(file.getProject(), file.getProjectRelativePath());
                monitor.worked(1);
                if (!tests.isEmpty()) {
                    AutotestManager.this.launchTests(file.getProject(), tests);
                }
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        j.schedule();
    }

    private void launchTests(IProject project, List<String> testFiles) {
        try {
            TestLauncher launcher = new TestLauncher();
            IPath path = RailsPlugin.getInstance().getStateLocation();
            path = path.append("run_auto2.rb");
            File temp = path.toFile();
            FileWriter writer = new FileWriter(temp);
            writer.write("require 'test/unit'\n");
            for (String string : testFiles) {
                writer.write("require '" + string + "'\n");
            }
            writer.close();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    AutotestManager.this.view = TestunitPlugin.getDefault().findTestUnitViewInActivePage();
                }
            });
            boolean oldShowOnErrorOnly = false;
            if (this.view != null) {
                oldShowOnErrorOnly = this.view.getShowOnErrorOnly();
                this.view.setShowOnErrorOnly(true);
            }
            TestunitPlugin.getDefault().addTestRunListener((ITestRunListener)this);
            ILaunch launch = launcher.goLaunch(project, "run", "run_auto2.rb");
            if (launch == null) {
                return;
            }
            IProcess iproc = launch.getProcesses()[0];
            while (!iproc.isTerminated()) {
                Thread.yield();
            }
            if (this.view != null) {
                this.view.setShowOnErrorOnly(oldShowOnErrorOnly);
            }
            TestunitPlugin.getDefault().removeTestRunListener((ITestRunListener)this);
        }
        catch (IOException e) {
            RailsUILog.log((Exception)e);
        }
    }

    public void addRunListener(IAutotestRunListener listener) {
        this.fRunListeners.add(listener);
    }

    public void removeRunListener(IAutotestRunListener listener) {
        this.fRunListeners.remove(listener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("rails.ui.test.autotest.run_on_interval")) {
            boolean enabled = (Boolean)event.getNewValue();
            if (enabled) {
                if (this.fAutotestThread != null) {
                    this.fAutotestThread.stopRunning();
                }
                this.fAutotestThread = new AutotestThread();
                this.fAutotestThread.start();
            } else {
                this.fAutotestThread.stopRunning();
                this.fAutotestThread = null;
            }
        }
    }

    public void testEnded(String testId, String testName) {
    }

    public void testFailed(int status, String testId, String testName, String trace) {
        for (IAutotestRunListener listener : this.fRunListeners) {
            if (status == 1) {
                listener.suiteError();
                continue;
            }
            listener.suiteFail();
        }
        this.fTestsPass = false;
    }

    public void testReran(String testId, String testClass, String testName, int status, String trace) {
    }

    public void testRunEnded(long elapsedTime) {
        if (!this.fTestsPass) {
            return;
        }
        for (IAutotestRunListener listener : this.fRunListeners) {
            listener.suitePass();
        }
    }

    public void testRunStarted(int testCount) {
        this.fTestsPass = true;
    }

    public void testRunStopped(long elapsedTime) {
    }

    public void testRunTerminated() {
    }

    public void testStarted(String testId, String testName) {
    }

    private class AutotestThread
    extends Thread {
        private boolean keepRunning = true;

        public void run() {
            while (this.keepRunning) {
                int intervalMinutes = AutotestHelper.getAutotestIntervalLength();
                long intervalMs = intervalMinutes * 60 * 1000;
                try {
                    AutotestThread.sleep(intervalMs);
                }
                catch (InterruptedException e) {
                    RailsUILog.logError((String)"Error sleeping during autotest interval", (Throwable)e);
                }
                IFile activeEditorFile = AutotestHelper.getActiveEditorFile();
                if (activeEditorFile == null) continue;
                AutotestManager.this.attemptTestLaunch((IResource)activeEditorFile);
            }
        }

        public void stopRunning() {
            this.keepRunning = false;
        }
    }
}

