/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.browser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.RectangleAnimation;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroLaunchBarElement;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.IntroTheme;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.presentations.IntroLaunchBar;
import org.eclipse.ui.internal.intro.impl.util.DialogUtil;
import org.eclipse.ui.internal.intro.impl.util.StringUtil;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.eclipse.ui.intro.config.IIntroAction;
import org.eclipse.ui.intro.config.IIntroURL;
import org.radrails.rails.internal.ui.browser.URLParser;

public class CoreURL
implements IIntroURL {
    public static final String INTRO_PROTOCOL = "http";
    public static final String INTRO_HOST_ID = "org.eclipse.ui.intro";
    public static final String SET_STANDBY_MODE = "setStandbyMode";
    public static final String SHOW_STANDBY = "showStandby";
    public static final String CLOSE = "close";
    public static final String SHOW_HELP_TOPIC = "showHelpTopic";
    public static final String SHOW_HELP = "showHelp";
    public static final String OPEN_BROWSER = "openBrowser";
    public static final String OPEN_URL = "openURL";
    public static final String RUN_ACTION = "runAction";
    public static final String SHOW_PAGE = "showPage";
    public static final String SHOW_MESSAGE = "showMessage";
    public static final String NAVIGATE = "navigate";
    public static final String SWITCH_TO_LAUNCH_BAR = "switchToLaunchBar";
    public static final String EXECUTE = "execute";
    public static final String KEY_ID = "id";
    public static final String KEY_PLUGIN_ID = "pluginId";
    public static final String KEY_CLASS = "class";
    public static final String KEY_STANDBY = "standby";
    public static final String KEY_PART_ID = "partId";
    public static final String KEY_INPUT = "input";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_URL = "url";
    public static final String KEY_DIRECTION = "direction";
    public static final String KEY_EMBED = "embed";
    public static final String KEY_EMBED_TARGET = "embedTarget";
    public static final String KEY_DECODE = "decode";
    public static final String KEY_COMAND = "command";
    public static final String VALUE_BACKWARD = "backward";
    public static final String VALUE_FORWARD = "forward";
    public static final String VALUE_HOME = "home";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    private String action = null;
    private Properties parameters = null;
    private Browser browser;

    CoreURL(String action, Properties parameters) {
        this.action = action;
        this.parameters = parameters;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public boolean execute() {
        final boolean[] result = new boolean[1];
        Display display = Display.getCurrent();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                result[0] = CoreURL.this.doExecute();
            }
        });
        return result[0];
    }

    protected boolean doExecute() {
        if (this.action.equals(SHOW_HELP)) {
            return this.showHelp();
        }
        if (this.action.equals(SHOW_HELP_TOPIC)) {
            return this.showHelpTopic(this.getParameter(KEY_ID), this.getParameter(KEY_EMBED), this.getParameter(KEY_EMBED_TARGET));
        }
        if (this.action.equals(OPEN_BROWSER)) {
            return this.openBrowser(this.getParameter(KEY_URL), this.getParameter(KEY_PLUGIN_ID));
        }
        if (this.action.equals(OPEN_URL)) {
            return this.openURL(this.getParameter(KEY_URL), this.getParameter(KEY_PLUGIN_ID));
        }
        if (this.action.equals(RUN_ACTION)) {
            return this.runAction(this.getParameter(KEY_PLUGIN_ID), this.getParameter(KEY_CLASS), this.parameters, this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(EXECUTE)) {
            return this.executeCommand(this.getParameter(KEY_COMAND), this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(SHOW_PAGE)) {
            return this.showPage(this.getParameter(KEY_ID), this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(SHOW_MESSAGE)) {
            return this.showMessage(this.getParameter(KEY_MESSAGE));
        }
        if (this.action.equals(NAVIGATE)) {
            return this.navigate(this.getParameter(KEY_DIRECTION));
        }
        if (this.action.equals(SWITCH_TO_LAUNCH_BAR)) {
            return this.switchToLaunchBar();
        }
        return this.handleCustomAction();
    }

    private boolean runAction(String pluginId, String className, Properties parameters, String standbyState) {
        block6: {
            Object actionObject = ModelLoaderUtil.createClassInstance((String)pluginId, (String)className);
            try {
                if (actionObject instanceof IIntroAction) {
                    IIntroAction introAction = (IIntroAction)actionObject;
                    introAction.run(null, parameters);
                    break block6;
                }
                if (actionObject instanceof IAction) {
                    IAction action = (IAction)actionObject;
                    action.run();
                    break block6;
                }
                if (actionObject instanceof IActionDelegate) {
                    final IActionDelegate delegate = (IActionDelegate)actionObject;
                    if (delegate instanceof IWorkbenchWindowActionDelegate) {
                        ((IWorkbenchWindowActionDelegate)delegate).init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    }
                    Action proxy = new Action(this.action){

                        public void run() {
                            delegate.run((IAction)this);
                        }
                    };
                    proxy.run();
                    break block6;
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private boolean executeCommand(String command, String standbyState) {
        ICommandService commandService = this.getCommandService();
        if (commandService == null) {
            return false;
        }
        try {
            ParameterizedCommand pCommand = commandService.deserialize(command);
            pCommand.executeWithChecks(null, null);
        }
        catch (CommandException commandException) {
            return false;
        }
        return true;
    }

    private ICommandService getCommandService() {
        Object serviceObject;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (serviceObject = wb.getAdapter(ICommandService.class)) != null) {
            ICommandService service = (ICommandService)serviceObject;
            return service;
        }
        return null;
    }

    private boolean showHelpTopic(String href, String embed, String embedTarget) {
        boolean isEmbedded;
        if (href == null) {
            return false;
        }
        boolean bl = isEmbedded = embed != null && embed.equals(VALUE_TRUE);
        if (!isEmbedded) {
            boolean bl2 = isEmbedded = embedTarget != null;
        }
        if (isEmbedded) {
            href = PlatformUI.getWorkbench().getHelpSystem().resolve(href, true).toExternalForm();
            if (embedTarget == null && this.browser != null) {
                return this.browser.setUrl(href);
            }
            IntroModelRoot model = IntroPlugin.getDefault().getIntroModelRoot();
            return this.handleEmbedURLInDiv(href, embedTarget, model.getCurrentPage());
        }
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
        return true;
    }

    private boolean handleEmbedURLInDiv(String href, String embedTarget, AbstractIntroPage currentPage) {
        IntroModelRoot model = (IntroModelRoot)currentPage.getParentPage().getParent();
        String currentPageId = null;
        currentPageId = currentPage.isIFramePage() ? currentPage.getUnmangledId() : currentPage.getId();
        String mangledPageId = String.valueOf(currentPageId) + "_" + "WITH_IFRAME";
        boolean standby = IntroPlugin.isIntroStandby();
        String standbyAsString = standby ? VALUE_TRUE : VALUE_FALSE;
        AbstractIntroPage pageWithIFrame = (AbstractIntroPage)model.findChild(mangledPageId, 12);
        if (pageWithIFrame != null) {
            pageWithIFrame.setIFrameURL(href);
            return this.showPage(mangledPageId, standbyAsString);
        }
        AbstractIntroPage clonedPage = null;
        try {
            clonedPage = (AbstractIntroPage)currentPage.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return false;
        }
        boolean canInjectFrame = clonedPage.injectIFrame(href, embedTarget);
        if (!canInjectFrame) {
            return false;
        }
        clonedPage.setId(mangledPageId);
        model.addChild((AbstractIntroElement)clonedPage);
        return this.showPage(clonedPage.getId(), standbyAsString);
    }

    private boolean showHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp();
        return true;
    }

    private boolean openBrowser(String url, String pluginId) {
        url = ModelUtil.resolveURL((String)url, (String)pluginId);
        return Util.openBrowser((String)url);
    }

    private boolean openURL(String url, String pluginId) {
        IntroModelRoot model = IntroPlugin.getDefault().getIntroModelRoot();
        String presentationStyle = model.getPresentation().getImplementationKind();
        if (presentationStyle.equals("html")) {
            url = ModelUtil.resolveURL((String)url, (String)pluginId);
            BrowserIntroPartImplementation impl = (BrowserIntroPartImplementation)IntroPlugin.getDefault().getIntroModelRoot().getPresentation().getIntroPartImplementation();
            Browser browser = impl.getBrowser();
            return browser.setUrl(url);
        }
        return this.openBrowser(url, pluginId);
    }

    private boolean showMessage(String message) {
        if (message == null) {
            return false;
        }
        DialogUtil.displayInfoMessage(null, (String)message);
        return true;
    }

    boolean showPage(String pageId, String standbyState) {
        CustomizableIntroPart currentIntroPart = (CustomizableIntroPart)IntroPlugin.getIntro();
        currentIntroPart.getControl().setRedraw(false);
        IntroModelRoot modelRoot = IntroPlugin.getDefault().getIntroModelRoot();
        boolean success = modelRoot.setCurrentPageId(pageId);
        if (!success) {
            success = this.includePageToShow(modelRoot, pageId);
        }
        currentIntroPart.getControl().setRedraw(true);
        if (success) {
            modelRoot.getPresentation().updateHistory(modelRoot.getCurrentPage());
        }
        return false;
    }

    private boolean includePageToShow(IntroModelRoot model, String pageId) {
        AbstractIntroPage page = this.findPageToShow(pageId);
        if (page == null) {
            return false;
        }
        page.getChildren();
        String currentPresentationKind = model.getPresentation().getImplementationKind();
        IntroPartPresentation targetPresentation = ((IntroModelRoot)page.getParent()).getPresentation();
        String targetSharedStyle = targetPresentation.getSharedStyle(currentPresentationKind);
        AbstractIntroPage clonedPage = null;
        try {
            clonedPage = (AbstractIntroPage)page.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return false;
        }
        clonedPage.setParent((AbstractIntroElement)model);
        if (targetSharedStyle != null) {
            clonedPage.insertStyle(targetSharedStyle, 0);
        }
        model.addChild((AbstractIntroElement)clonedPage);
        return model.setCurrentPageId(clonedPage.getId());
    }

    private AbstractIntroPage findPageToShow(String pageId) {
        Hashtable models = ExtensionPointManager.getInst().getIntroModels();
        Enumeration values = models.elements();
        while (values.hasMoreElements()) {
            IntroModelRoot model = (IntroModelRoot)values.nextElement();
            AbstractIntroPage page = (AbstractIntroPage)model.findChild(pageId, 12);
            if (page == null) continue;
            return page;
        }
        return null;
    }

    private boolean navigate(String direction) {
        CustomizableIntroPart introPart = (CustomizableIntroPart)IntroPlugin.getIntro();
        if (introPart == null) {
            return false;
        }
        IntroPartPresentation presentation = (IntroPartPresentation)introPart.getAdapter(IntroPartPresentation.class);
        if (direction.equalsIgnoreCase(VALUE_BACKWARD)) {
            return presentation.navigateBackward();
        }
        if (direction.equalsIgnoreCase(VALUE_FORWARD)) {
            return presentation.navigateForward();
        }
        if (direction.equalsIgnoreCase(VALUE_HOME)) {
            return presentation.navigateHome();
        }
        return false;
    }

    public String getAction() {
        return this.action;
    }

    public String getParameter(String parameterId) {
        String value = this.parameters.getProperty(parameterId);
        String decode = this.parameters.getProperty(KEY_DECODE);
        if (value != null) {
            try {
                if (decode != null && decode.equalsIgnoreCase(VALUE_TRUE)) {
                    return StringUtil.decode((String)value, (String)"UTF-8");
                }
                return value;
            }
            catch (Exception exception) {}
        }
        return value;
    }

    private boolean handleCustomAction() {
        String replaces = null;
        if (this.action.equals("installPlugin")) {
            replaces = "runAction?pluginId=com.aptana.ide.extras&class=com.aptana.ide.extras.plugins.InstallPlugin";
        } else if (this.action.equals("disablePlugin")) {
            replaces = "runAction?pluginId=com.aptana.ide.extras&class=com.aptana.ide.extras.plugins.DisablePlugin";
        }
        if (replaces != null) {
            StringBuffer url = new StringBuffer();
            url.append("http://org.eclipse.ui.intro/");
            url.append(replaces);
            url.append("&");
            url.append(this.retrieveInitialQuery());
            URLParser parser = new URLParser(url.toString());
            parser.getIntroURL().doExecute();
        }
        return false;
    }

    private String retrieveInitialQuery() {
        StringBuffer query = new StringBuffer();
        Enumeration<Object> keys = this.parameters.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            query.append(key);
            query.append("=");
            query.append(this.parameters.get(key));
            if (!keys.hasMoreElements()) continue;
            query.append("&");
        }
        return query.toString();
    }

    private boolean switchToLaunchBar() {
        IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        if (intro == null) {
            return false;
        }
        CustomizableIntroPart cpart = (CustomizableIntroPart)intro;
        IntroModelRoot modelRoot = IntroPlugin.getDefault().getIntroModelRoot();
        String pageId = modelRoot.getCurrentPageId();
        IntroTheme theme = modelRoot.getTheme();
        Rectangle bounds = cpart.getControl().getBounds();
        Rectangle startBounds = Geometry.toDisplay((Control)cpart.getControl().getParent(), (Rectangle)bounds);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IntroLaunchBarElement launchBarElement = modelRoot.getPresentation().getLaunchBarElement();
        if (launchBarElement == null) {
            return true;
        }
        IntroLaunchBar launchBar = new IntroLaunchBar(launchBarElement.getOrientation(), pageId, launchBarElement, theme);
        launchBar.createInActiveWindow();
        Rectangle endBounds = Geometry.toDisplay((Control)launchBar.getControl().getParent(), (Rectangle)launchBar.getControl().getBounds());
        RectangleAnimation animation = new RectangleAnimation(window.getShell(), startBounds, endBounds);
        animation.schedule();
        return true;
    }
}

