/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.browser;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.rubyeditor.ExternalRubyFileEditorInput;

public class OpenEditorAction
implements IIntroAction {
    public void run(IIntroSite site, Properties params) {
        String path = (String)params.get("path");
        if (path.startsWith("<A href")) {
            return;
        }
        String rawLine = (String)params.get("line");
        int line = -1;
        try {
            line = Integer.parseInt(rawLine);
        }
        catch (NumberFormatException numberFormatException) {
            line = -1;
        }
        try {
            IEditorPart part;
            IFile file = this.getFile(path);
            if (file == null) {
                ExternalRubyFileEditorInput input = new ExternalRubyFileEditorInput(new File(path));
                part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "org.rubypeople.rdt.ui.ExternalRubyEditor");
            } else {
                part = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            if (part == null) {
                RailsUILog.logError((String)"Error creating editor input for stack trace from browser", null);
                return;
            }
            if (line == -1) {
                return;
            }
            if (part instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)part;
                IDocument doc = editor.getDocumentProvider().getDocument((Object)part.getEditorInput());
                try {
                    int offset = doc.getLineOffset(line - 1);
                    EditorUtility.revealInEditor((IEditorPart)part, (int)offset, (int)0);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        catch (CoreException e) {
            RailsUILog.logError((String)"Could not open editor or set line in editor", (Throwable)e);
        }
    }

    private IFile getFile(String path) {
        if (path.indexOf(":/") != -1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
        }
        if (!path.startsWith("./")) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        }
        Collection servers = ServerManager.getInstance().getServers();
        for (Server s : servers) {
            if (!s.isStarted()) continue;
            String tmp = "/" + s.getProject().getName() + path.substring(1);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(tmp));
            if (file == null || !file.exists()) continue;
            return file;
        }
        return null;
    }
}

