/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.console;

import com.aptana.rdt.rake.IRakeHelper;
import com.aptana.rdt.rake.RakePlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.radrails.rails.internal.ui.console.RailsShell;
import org.radrails.rails.internal.ui.console.RailsShellCompletionProposal;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsShellContentAssistProcessor
implements IContentAssistProcessor {
    private IProject fProject;

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{' '};
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(String prefix, int offset) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(prefix);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String token = null;
        try {
            token = tokenizer.nextToken();
            if (token.trim().startsWith(">")) {
                token = token.trim().substring(">".length());
            }
            if (token.trim().length() == 0) {
                token = tokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            token = "";
        }
        while (token.trim().length() > 0) {
            tokens.add(token);
            token = this.nextToken(tokenizer);
        }
        if (tokens.isEmpty()) {
            proposals.add(this.createProposal("debug", "Run the trailing command under the debugger", offset, ""));
            proposals.add(this.createProposal("profile", "Run the trailing command under the profiler", offset, ""));
        } else if (((String)tokens.get(0)).equals("debug") || ((String)tokens.get(0)).equals("profile") || ((String)tokens.get(0)).equals("ruby")) {
            tokens.remove(0);
        }
        String command = "";
        if (!tokens.isEmpty()) {
            command = (String)tokens.get(0);
        }
        List<RailsShellCommandProvider> providers = this.getCommandProviders();
        for (RailsShellCommandProvider railsShellCommandProvider : providers) {
            if (railsShellCommandProvider.projectNeedsToBeSelected() && this.fProject == null || !this.commandMatches(railsShellCommandProvider, command)) continue;
            proposals.addAll(railsShellCommandProvider.getCompletionProposals(prefix, tokens, offset));
        }
        Iterator iter = proposals.iterator();
        while (iter.hasNext()) {
            ICompletionProposal prop = (ICompletionProposal)iter.next();
            if (prop != null) continue;
            iter.remove();
        }
        Collections.sort(proposals, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return o1.getDisplayString().compareTo(o2.getDisplayString());
            }
        });
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix = this.getLinePrefix(viewer, offset);
        if (prefix.trim().length() == 0) {
            offset -= prefix.length();
        }
        return this.computeCompletionProposals(prefix, offset);
    }

    private boolean commandMatches(RailsShellCommandProvider railsShellCommandProvider, String command) {
        for (String handledCommand : railsShellCommandProvider.commandsHandled()) {
            if (!handledCommand.startsWith(command)) continue;
            return true;
        }
        return false;
    }

    private List<RailsShellCommandProvider> getCommandProviders() {
        return RailsShell.getCommandProviders(this.fProject, "run");
    }

    protected IRakeHelper getRakeTasksHelper() {
        return RakePlugin.getDefault().getRakeHelper();
    }

    private String nextToken(StringTokenizer tokenizer) {
        try {
            return tokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return "";
        }
    }

    private String getLinePrefix(ITextViewer viewer, int offset) {
        String prefix = null;
        try {
            IDocument doc = viewer.getDocument();
            prefix = doc.get(0, offset);
            int index = prefix.lastIndexOf("\n");
            if (index > -1) {
                prefix = prefix.substring(index + 1);
            }
        }
        catch (BadLocationException badLocationException) {}
        return prefix;
    }

    private ICompletionProposal createProposal(String string, String description, int offset, String token) {
        if (token != null && !string.startsWith(token)) {
            return null;
        }
        if (token.equals(string)) {
            return null;
        }
        ImageDescriptorRegistry registry = RubyPlugin.getImageDescriptorRegistry();
        Image image = registry.get(RubyPluginImages.DESC_MISC_PUBLIC);
        String display = string;
        if (description != null && description.trim().length() > 0) {
            display = String.valueOf(display) + " - " + description;
        }
        return new RailsShellCompletionProposal(string, offset - token.length(), token.length(), string.length(), image, display, null, description);
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }
}

