/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.console;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.radrails.rails.internal.ui.console.Messages;
import org.radrails.rails.internal.ui.console.RailsShell;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.rubypeople.rdt.launching.ITerminal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsShellExecutor {
    private ITerminal shell;
    private String fRunMode;

    public RailsShellExecutor(ITerminal shell) {
        this.shell = shell;
    }

    public void run(IProject project, String command) {
        this.run(project, command, "run");
    }

    public void run(IProject project, String command, String runMode) {
        this.fRunMode = runMode;
        String modifiedFullCommand = command;
        if (modifiedFullCommand.startsWith("ruby ")) {
            modifiedFullCommand = command.substring(5);
        }
        if (modifiedFullCommand.startsWith("debug ")) {
            modifiedFullCommand = command.substring(6);
            this.fRunMode = "debug";
        } else if (modifiedFullCommand.startsWith("profile ")) {
            modifiedFullCommand = command.substring(8);
            this.fRunMode = "profile";
        }
        if (modifiedFullCommand.trim().length() == 0) {
            this.shell.write("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", "\n>");
            return;
        }
        String firstCommandToken = modifiedFullCommand;
        if (firstCommandToken.startsWith("sudo ")) {
            firstCommandToken = firstCommandToken.substring(5);
        }
        if (firstCommandToken.indexOf(32) != -1) {
            firstCommandToken = firstCommandToken.substring(0, firstCommandToken.indexOf(32));
        }
        List<RailsShellCommandProvider> providers = this.getCommandProviders(project);
        for (RailsShellCommandProvider railsShellCommandProvider : providers) {
            if (!this.commandMatches(railsShellCommandProvider, firstCommandToken)) continue;
            if (project == null && railsShellCommandProvider.projectNeedsToBeSelected()) {
                this.projectNeedsToBeSelected(this.shell);
            } else {
                railsShellCommandProvider.run(this.shell, modifiedFullCommand);
            }
            return;
        }
    }

    private boolean commandMatches(RailsShellCommandProvider railsShellCommandProvider, String firstCommandToken) {
        if (railsShellCommandProvider.handlesAll()) {
            return true;
        }
        for (String command : railsShellCommandProvider.commandsHandled()) {
            if (!command.equals(firstCommandToken)) continue;
            return true;
        }
        return false;
    }

    protected void projectNeedsToBeSelected(ITerminal shell) {
        shell.write("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", String.valueOf(Messages.RailsShell_ProjectNeedsToBeSelected) + "\n");
        shell.write("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", ">");
    }

    private List<RailsShellCommandProvider> getCommandProviders(IProject project) {
        return RailsShell.getCommandProviders(project, this.fRunMode);
    }
}

