/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.console.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.radrails.rails.internal.generators.Generator;
import org.radrails.rails.internal.generators.GeneratorLocatorsManager;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.rubypeople.rdt.launching.ITerminal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptGenerateAndDestroyCommandProvider
extends RailsShellCommandProvider {
    @Override
    public Set<String> commandsHandled() {
        HashSet<String> commands = new HashSet<String>();
        commands.add("script/destroy");
        commands.add("script/generate");
        return commands;
    }

    @Override
    public List<ICompletionProposal> getCompletionProposals(String prefix, List<String> tokens, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String token = this.getLastToken(prefix, tokens);
        if (tokens.size() <= 1 && !tokens.contains("script/destroy") && !tokens.contains("script/generate")) {
            proposals.add(this.createProposal("script/destroy", "Destroy files which were created by a generator", offset, token));
            proposals.add(this.createProposal("script/generate", "Create files using the specified generator", offset, token));
        }
        if (tokens.size() > 1) {
            if (!tokens.contains("-h")) {
                proposals.add(this.createProposal("-h", "Show the help message", offset, token));
            }
            if (tokens.size() <= 2 && !token.startsWith("-")) {
                List generators = GeneratorLocatorsManager.getInstance().getAllGenerators(this.getProject());
                Collections.sort(generators);
                for (Generator generator : generators) {
                    ICompletionProposal proposal = this.createProposal(generator.getName(), offset, token);
                    if (proposal == null) continue;
                    proposals.add(proposal);
                }
            }
        }
        return proposals;
    }

    @Override
    public void run(ITerminal shell, String command) {
        this.launchInsideShell(shell, command);
    }
}

