/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.generators;

import com.aptana.ide.editors.unified.UnifiedMessagePage;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.RailsUIMessages;
import org.radrails.rails.internal.ui.actions.RailsProjectSelectionAction;
import org.radrails.rails.internal.ui.generators.GeneratorsPage;
import org.radrails.rails.ui.RailsUIPlugin;
import org.rubypeople.rdt.ui.IPackagesViewPart;

public class GeneratorsView
extends PageBookView {
    private GeneratorsPage generatorsPage;
    private UnifiedMessagePage messagePage;
    private RailsProjectSelectionAction selectProjectAction;

    protected IPage createDefaultPage(PageBook book) {
        this.createMessagePage(book);
        this.createGeneratorsPage(book);
        Object page = null;
        page = GeneratorsView.getSelectedProject() == null ? this.messagePage : this.generatorsPage;
        if (this.generatorsPage.pulldownEmpty()) {
            this.refreshGenerators();
        }
        return page;
    }

    private static IProject getSelectedProject() {
        IProject proj = RailsUIPlugin.getSelectedOrOnlyRailsProject();
        if (proj != null) {
            return proj;
        }
        Set projects = RailsPlugin.getRailsProjects();
        if (projects == null || projects.size() == 0) {
            return null;
        }
        return (IProject)projects.iterator().next();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.selectProjectAction = new RailsProjectSelectionAction();
        site.getActionBars().getToolBarManager().add((IAction)this.selectProjectAction);
    }

    private void createMessagePage(PageBook book) {
        this.messagePage = new UnifiedMessagePage();
        this.messagePage.createControl((Composite)book);
        this.messagePage.setMessage(RailsUIMessages.SelectRailsProject_message);
    }

    private void createGeneratorsPage(PageBook book) {
        this.generatorsPage = new GeneratorsPage();
        this.initPage((IPageBookViewPage)this.generatorsPage);
        this.generatorsPage.createControl((Composite)book);
        this.selectProjectAction.setListener(this.generatorsPage);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof IPackagesViewPart) {
            this.createGeneratorsPage(this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)this.generatorsPage);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
        this.selectProjectAction.setListener(null);
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IPackagesViewPart;
    }

    public void refreshGenerators() {
        this.generatorsPage.refreshGenerators();
    }

    public void dispose() {
        super.dispose();
    }
}

