/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.tail;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.radrails.rails.internal.ui.tail.TailConsole;

public class TailConsoleManager {
    private static TailConsoleManager instance;
    private List<TailConsole> consoles = new ArrayList<TailConsole>();

    private TailConsoleManager() {
    }

    public static TailConsoleManager getInstance() {
        if (instance == null) {
            instance = new TailConsoleManager();
        }
        return instance;
    }

    public void addConsole(TailConsole console) {
        this.consoles.add(console);
    }

    public void removeTerminatedConsoles() {
        ArrayList<TailConsole> toRemove = new ArrayList<TailConsole>();
        for (TailConsole c : this.consoles) {
            if (!c.isStopped()) continue;
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{c});
            toRemove.add(c);
        }
        for (TailConsole console : toRemove) {
            this.consoles.remove((Object)console);
        }
    }

    public void stopAll() {
        for (TailConsole console : this.consoles) {
            console.stopTail();
        }
    }
}

