/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.RailsInstallDialog;
import org.radrails.rails.internal.ui.wizards.RailsProjectCreator;
import org.radrails.rails.internal.ui.wizards.WizardMessages;
import org.radrails.rails.internal.ui.wizards.pages.WizardNewRailsProjectPage;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.RailsUIPlugin;

public class NewRailsProjectWizard
extends BasicNewProjectResourceWizard {
    private WizardNewRailsProjectPage page;
    private RailsProjectCreator creator;

    public NewRailsProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Rails project");
        this.creator = null;
    }

    public boolean performFinish() {
        if (this.railsNotInstalled() && this.page.getGenerateButtonSelection()) {
            RailsInstallDialog dialog = new RailsInstallDialog(RailsUIPlugin.getInstance().getGemManager());
            dialog.schedule();
            return true;
        }
        this.creator = new RailsProjectCreator(this.page);
        WorkspaceModifyDelegatingOperation newProjectOp = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this.creator);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)newProjectOp);
        }
        catch (Exception e) {
            RailsUILog.logError((String)"Error creating project", (Throwable)e);
            return false;
        }
        if (this.getNewProject() == null) {
            return false;
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)this.getNewProject());
        return true;
    }

    public IProject getNewProject() {
        if (this.creator == null) {
            return null;
        }
        return this.creator.getProject();
    }

    private boolean railsNotInstalled() {
        return RailsPlugin.getInstance().getRailsPath() == null;
    }

    public void addPages() {
        this.page = new WizardNewRailsProjectPage("new.rails.project1");
        this.page.setTitle(WizardMessages.NewRailsProjectWizardAction_text);
        this.page.setDescription(WizardMessages.NewRailsProjectWizardAction_description);
        this.addPage((IWizardPage)this.page);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)RailsUIPlugin.getInstance().getBundle().getSymbolicName(), (String)"icons/newproj_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
    }
}

