/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.ui;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.IGemManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.RailsProjectListener;
import org.radrails.rails.internal.ui.RailsShellOpenJob;
import org.radrails.rails.internal.ui.RakePathPrefMigrator;
import org.radrails.rails.internal.ui.autotest.AutotestManager;
import org.radrails.rails.internal.ui.tail.TailConsoleManager;
import org.radrails.rails.ui.RailsUILog;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyExplorerTracker;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class RailsUIPlugin
extends AbstractUIPlugin {
    private static final boolean DISPLAY_JOBS = true;
    private static RailsUIPlugin instance;
    private static final String PLUGIN_ID = "org.radrails.rails.ui";
    private static Hashtable<String, Image> images;
    private AutotestManager fAutotestManager;
    private RailsProjectListener fRailsListener;
    private ServiceTracker gemManagerTracker;

    static {
        images = new Hashtable();
    }

    public RailsUIPlugin() {
        instance = this;
    }

    public static Image getImage(String path) {
        if (images.get(path) == null) {
            ImageDescriptor id = RailsUIPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            Image i = id.createImage();
            images.put(path, i);
            return i;
        }
        return images.get(path);
    }

    public static RailsUIPlugin getInstance() {
        return instance;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.gemManagerTracker = new ServiceTracker(context, IGemManager.class.getName(), null);
        this.gemManagerTracker.open();
        this.fAutotestManager = new AutotestManager();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fAutotestManager, 1);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.fAutotestManager);
        this.fRailsListener = new RailsProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fRailsListener, 5);
        Object job = new RakePathPrefMigrator();
        job.setSystem(false);
        job.schedule();
        job = new RailsShellOpenJob(context);
        job.setSystem(false);
        job.schedule(1000L);
        job = new Job("Start DB Core plugin"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Platform.getBundle((String)"org.radrails.db.core").loadClass("org.radrails.db.core.DatabasePlugin");
                }
                catch (Exception exception) {}
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule(1000L);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.gemManagerTracker.close();
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fAutotestManager);
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.fAutotestManager);
            IPersistentPreferenceStore ppStore = (IPersistentPreferenceStore)this.getPreferenceStore();
            ppStore.save();
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fRailsListener);
            TailConsoleManager.getInstance().stopAll();
        }
        finally {
            super.stop(context);
        }
    }

    public IGemManager getGemManager() {
        return (IGemManager)this.gemManagerTracker.getService();
    }

    public AutotestManager getAutotestManager() {
        return this.fAutotestManager;
    }

    public static String getPluginIdentifier() {
        return PLUGIN_ID;
    }

    /*
     * Loose catch block
     */
    public String getFileContents(String path) {
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path(path), (boolean)false)));
        StringBuffer buffer = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        String string = buffer.toString();
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException e) {
            try {
                RailsUILog.log((Exception)e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return "";
    }

    public IProject getSelectedRailsProject() {
        return this.getProjectTracker().getSelectedByNatureID("org.radrails.rails.core.railsnature");
    }

    private RubyExplorerTracker getProjectTracker() {
        return RubyPlugin.getDefault().getProjectTracker();
    }

    public IProject getSelectedRailsOrRubyProject() {
        IProject retVal = this.getSelectedRailsProject();
        if (retVal != null) {
            return retVal;
        }
        return this.getProjectTracker().getSelectedRubyProject();
    }

    public static IProject getSelectedOrOnlyRailsProject() {
        IProject project = RailsUIPlugin.getInstance().getSelectedRailsOrRubyProject();
        if (project != null) {
            return project;
        }
        Set projects = RailsPlugin.getRailsProjects();
        if (projects != null && projects.size() == 1) {
            return (IProject)projects.iterator().next();
        }
        return null;
    }

    public static void addDefaultRailsLoadpaths(IRubyProject rubyProject, IProgressMonitor monitor) throws RubyModelException {
        ArrayList<ILoadpathEntry> list = new ArrayList<ILoadpathEntry>();
        IProject project = rubyProject.getProject();
        list.add(RubyCore.newSourceEntry((IPath)project.getFullPath()));
        ILoadpathEntry[] jreEntries = PreferenceConstants.getDefaultRubyVMLibrary();
        int i = 0;
        while (i < jreEntries.length) {
            list.add(jreEntries[i]);
            ++i;
        }
        rubyProject.setRawLoadpath(list.toArray(new ILoadpathEntry[list.size()]), monitor);
        String version = RailsPlugin.getRailsVersion((IProject)project);
        if (version != null) {
            Gem railsGem = new Gem("rails", version, "n/a");
            AptanaRDTPlugin.addGemLoadPath((IRubyProject)rubyProject, (Gem)railsGem, (IProgressMonitor)monitor);
        } else {
            AptanaRDTPlugin.log((String)("Unable to get the version number for rails for project: " + rubyProject.getElementName()));
        }
    }

    public static boolean hasRailsFrozenInVendor(IRubyProject rubyProject) {
        ISourceFolderRoot root = rubyProject.getSourceFolderRoot((IResource)rubyProject.getProject());
        ISourceFolder folder = root.getSourceFolder(new String[]{"vendor", "rails"});
        if (folder == null) {
            return false;
        }
        return folder.exists();
    }

    public static void overrideDocumentRoot(IProject project) throws CoreException {
        project.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.HTML_PREVIEW_OVERRIDE"), "true");
        project.setPersistentProperty(new QualifiedName("", "com.aptana.ide.editor.html.preview.CONTEXT_ROOT"), "/public");
    }
}

