/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.ui.browser;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.radrails.rails.internal.ui.browser.BrowserEditor;
import org.radrails.rails.internal.ui.browser.CoreBrowserLocationListener;
import org.radrails.rails.ui.RailsUIPlugin;

public class BrowserUtil {
    public static final IEditorPart openBrowser(String url) throws PartInitException, MalformedURLException {
        IEditorPart part = IDE.openEditor((IWorkbenchPage)BrowserUtil.getActivePage(), (IEditorInput)BrowserUtil.getInput(url), (String)"org.radrails.rails.ui.browser.BrowserEditor");
        if (part instanceof BrowserEditor) {
            final BrowserEditor browser = (BrowserEditor)part;
            browser.getBrowser().addTitleListener(new TitleListener(){

                public void changed(TitleEvent event) {
                    browser.getBrowser().execute(RailsUIPlugin.getInstance().getFileContents("scripts/link.js"));
                }
            });
            browser.getBrowser().addLocationListener((LocationListener)new CoreBrowserLocationListener());
        }
        return part;
    }

    public static void openOrActivateBrowser(String url) throws PartInitException, MalformedURLException {
        IEditorPart editor = BrowserUtil.getActivePage().findEditor((IEditorInput)BrowserUtil.getInput(url));
        if (editor != null) {
            BrowserUtil.getActivePage().activate((IWorkbenchPart)editor);
        }
        IEditorReference[] refs = BrowserUtil.getActivePage().getEditorReferences();
        int i = 0;
        while (i < refs.length) {
            WebBrowserEditorInput webInput;
            String blah;
            IEditorInput input = refs[i].getEditorInput();
            if (input instanceof WebBrowserEditorInput && (blah = (webInput = (WebBrowserEditorInput)input).getURL().toString()).equals(url) && (editor = refs[i].getEditor(false)) != null) {
                BrowserUtil.getActivePage().activate((IWorkbenchPart)editor);
                return;
            }
            ++i;
        }
        BrowserUtil.openBrowser(url);
    }

    private static WebBrowserEditorInput getInput(String url) throws MalformedURLException {
        return new WebBrowserEditorInput(new URL(url), 6);
    }

    private static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }
}

