/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.ui.text;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.radrails.rails.core.RailsLog;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsHeuristicCompletionComputer {
    private static final String CONTROLLER_FILE_SUFFIX = "_controller.rb";

    public static Map<String, File> getControllerCompletions(File controllersFolder, IDocument doc, int offset) {
        HashMap<String, File> list = new HashMap<String, File>();
        if (controllersFolder == null) {
            return list;
        }
        String fullPrefix = RailsHeuristicCompletionComputer.getFullPrefix(doc, offset);
        if (!RailsHeuristicCompletionComputer.looksLikeControllerCompletion(fullPrefix)) {
            return list;
        }
        File[] controllers = controllersFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(RailsHeuristicCompletionComputer.CONTROLLER_FILE_SUFFIX);
            }
        });
        int i = 0;
        while (i < controllers.length) {
            File controller = controllers[i];
            String name = controller.getName().substring(0, controller.getName().length() - CONTROLLER_FILE_SUFFIX.length());
            String replacement = RailsHeuristicCompletionComputer.surroundWithQuotes(offset, doc, fullPrefix, name);
            list.put(replacement, controller);
            ++i;
        }
        return list;
    }

    private static String surroundWithQuotes(int offset, IDocument doc, String fullPrefix, String replacement) {
        int next = 97;
        try {
            if (offset < doc.getLength()) {
                next = doc.getChar(offset);
            }
        }
        catch (BadLocationException badLocationException) {}
        if (fullPrefix.endsWith("'")) {
            if (next != 39) {
                replacement = String.valueOf(replacement) + "'";
            }
        } else if (fullPrefix.endsWith("\"")) {
            if (next != 34) {
                replacement = String.valueOf(replacement) + "\"";
            }
        } else {
            replacement = "'" + replacement + "'";
        }
        return replacement;
    }

    private static boolean looksLikeControllerCompletion(String prefix) {
        return Pattern.matches(".*:controller\\s*=>\\s*['|\"]?", prefix);
    }

    private static String getFullPrefix(IDocument doc, int offset) {
        int length = 0;
        String prefix = "";
        try {
            while (offset - length > 0 && Pattern.matches("[^\\n|^\\r|^;]", doc.get(offset - length - 1, 1))) {
                ++length;
            }
            prefix = doc.get(offset - length, length);
        }
        catch (BadLocationException badLocationException) {}
        return prefix;
    }

    public static Map<String, File> getActionCompletions(File controllersFolder, IDocument doc, int offset) {
        HashMap<String, File> list = new HashMap<String, File>();
        if (controllersFolder == null) {
            return list;
        }
        String fullPrefix = RailsHeuristicCompletionComputer.getFullPrefix(doc, offset);
        if (!RailsHeuristicCompletionComputer.looksLikeActionCompletion(fullPrefix)) {
            return list;
        }
        String controllerName = RailsHeuristicCompletionComputer.getControllerName(fullPrefix);
        File controller = RailsHeuristicCompletionComputer.getController(controllersFolder, controllerName);
        if (controller == null) {
            return list;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(controller.getAbsolutePath()));
        IRubyScript script = RubyCore.create((IFile)file);
        String typeName = String.valueOf(Util.underscoresToCamelCase((String)RailsHeuristicCompletionComputer.handleNamespacing(controllerName))) + "Controller";
        try {
            IType type = script.getType(typeName);
            if (type == null) {
                return list;
            }
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isPublic()) {
                    String name = methods[i].getElementName();
                    String replacement = RailsHeuristicCompletionComputer.surroundWithQuotes(offset, doc, fullPrefix, name);
                    list.put(replacement, controller);
                }
                ++i;
            }
        }
        catch (RubyModelException e) {
            RailsLog.log((CoreException)((Object)e));
        }
        return list;
    }

    private static String handleNamespacing(String controllerName) {
        String[] parts = controllerName.split("[\\|/]");
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < parts.length) {
            if (i > 0) {
                buffer.append("::");
            }
            String upper = String.valueOf(Character.toUpperCase(parts[i].charAt(0))) + parts[i].substring(1);
            buffer.append(upper);
            ++i;
        }
        return buffer.toString();
    }

    private static File getController(File controllersFolder, String controllerName) {
        String[] parts = controllerName.split("[\\|/]");
        controllerName = parts[parts.length - 1];
        int i = 0;
        while (i < parts.length - 1) {
            if (!(controllersFolder = new File(controllersFolder, parts[i])).exists()) {
                return null;
            }
            ++i;
        }
        File[] controllers = controllersFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(RailsHeuristicCompletionComputer.CONTROLLER_FILE_SUFFIX);
            }
        });
        int i2 = 0;
        while (i2 < controllers.length) {
            File controller = controllers[i2];
            String name = controller.getName().substring(0, controller.getName().length() - CONTROLLER_FILE_SUFFIX.length());
            if (name.equals(controllerName)) {
                return controller;
            }
            ++i2;
        }
        return null;
    }

    private static String getControllerName(String prefix) {
        Pattern pat = Pattern.compile(".*:controller\\s*=>\\s*['|\"|:]?([\\w|\\|/]+)?['|\"]?");
        Matcher matcher = pat.matcher(prefix);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }

    private static boolean looksLikeActionCompletion(String prefix) {
        return Pattern.matches(".*:action\\s*=>\\s*['|\"]?", prefix);
    }
}

